/*
 * Decompiled with CFR 0.152.
 */
package ro.kuberam.libs.java.crypto.toDo;

import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.xml.crypto.dsig.Reference;
import javax.xml.crypto.dsig.SignedInfo;
import javax.xml.crypto.dsig.Transform;
import javax.xml.crypto.dsig.XMLSignature;
import javax.xml.crypto.dsig.XMLSignatureFactory;
import javax.xml.crypto.dsig.dom.DOMSignContext;
import javax.xml.crypto.dsig.keyinfo.KeyInfo;
import javax.xml.crypto.dsig.keyinfo.KeyInfoFactory;
import javax.xml.crypto.dsig.keyinfo.KeyValue;
import javax.xml.crypto.dsig.spec.C14NMethodParameterSpec;
import javax.xml.crypto.dsig.spec.TransformParameterSpec;
import javax.xml.crypto.dsig.spec.XPathFilterParameterSpec;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class SignFileExample {
    private static String KEY_STORE_TYPE = "JKS";
    private static String KEY_STORE_NAME = "/home/claudius/mykeystoreEXist.ks";
    private static String KEY_STORE_PASS = "ab987c";
    private static String PRIVATE_KEY_PASS = "kpi135";
    private static String KEY_ALIAS = "eXist";
    private static String PATH = "/PatientRecord/Account";
    private static String ID = "acct";

    public static void main(String[] args) throws Exception {
        KeyStore keyStore;
        Document doc;
        String inputFile = "doc.xml";
        String outputFile = "doc-signed.xml";
        SignatureType sigType = args.length >= 3 ? ("id".equals(args[2]) ? SignatureType.SIGN_BY_ID : ("path".equals(args[2]) ? SignatureType.SIGN_BY_PATH : SignatureType.SIGN_WHOLE_DOCUMENT)) : SignatureType.SIGN_WHOLE_DOCUMENT;
        DocumentBuilderFactory dbFactory = DocumentBuilderFactory.newInstance();
        dbFactory.setNamespaceAware(true);
        try (InputStream is = Files.newInputStream(Paths.get("doc.xml", new String[0]), new OpenOption[0]);){
            doc = dbFactory.newDocumentBuilder().parse(is);
        }
        String providerName = System.getProperty("jsr105Provider", "org.jcp.xml.dsig.internal.dom.XMLDSigRI");
        final XMLSignatureFactory sigFactory = XMLSignatureFactory.getInstance("DOM", (Provider)Class.forName(providerName).newInstance());
        Node nodeToSign = null;
        Node sigParent = null;
        String referenceURI = null;
        XPathExpression expr = null;
        ArrayList<Transform> transforms = null;
        XPathFactory factory = XPathFactory.newInstance();
        XPath xpath = factory.newXPath();
        switch (sigType) {
            case SIGN_BY_ID: {
                expr = xpath.compile(String.format("//*[@id='%s']", ID));
                NodeList nodes = (NodeList)expr.evaluate(doc, XPathConstants.NODESET);
                if (nodes.getLength() == 0) {
                    System.out.println("Can't find node with id: " + ID);
                    return;
                }
                nodeToSign = nodes.item(0);
                sigParent = nodeToSign.getParentNode();
                referenceURI = "#" + ID;
                break;
            }
            case SIGN_BY_PATH: {
                expr = xpath.compile(PATH);
                NodeList nodes = (NodeList)expr.evaluate(doc, XPathConstants.NODESET);
                if (nodes.getLength() < 1) {
                    System.out.println("Invalid document, can't find node by PATH: " + PATH);
                    return;
                }
                nodeToSign = nodes.item(0);
                sigParent = nodeToSign.getParentNode();
                referenceURI = "";
                transforms = new ArrayList<Transform>(){
                    {
                        this.add(sigFactory.newTransform("http://www.w3.org/TR/1999/REC-xpath-19991116", new XPathFilterParameterSpec(PATH)));
                        this.add(sigFactory.newTransform("http://www.w3.org/2000/09/xmldsig#enveloped-signature", (TransformParameterSpec)null));
                    }
                };
                break;
            }
            default: {
                sigParent = doc.getDocumentElement();
                referenceURI = "";
                transforms = Collections.singletonList(sigFactory.newTransform("http://www.w3.org/2000/09/xmldsig#enveloped-signature", (TransformParameterSpec)null));
            }
        }
        try (InputStream is = Files.newInputStream(Paths.get(KEY_STORE_NAME, new String[0]), new OpenOption[0]);){
            keyStore = KeyStore.getInstance(KEY_STORE_TYPE);
            keyStore.load(is, KEY_STORE_PASS.toCharArray());
        }
        PrivateKey privateKey = (PrivateKey)keyStore.getKey(KEY_ALIAS, PRIVATE_KEY_PASS.toCharArray());
        X509Certificate cert = (X509Certificate)keyStore.getCertificate(KEY_ALIAS);
        PublicKey publicKey = cert.getPublicKey();
        KeyInfoFactory keyInfoFactory = sigFactory.getKeyInfoFactory();
        KeyValue keyValue = keyInfoFactory.newKeyValue(publicKey);
        KeyInfo keyInfo = keyInfoFactory.newKeyInfo(Collections.singletonList(keyValue));
        Reference ref = sigFactory.newReference(referenceURI, sigFactory.newDigestMethod("http://www.w3.org/2000/09/xmldsig#sha1", null), (List<? extends Transform>)transforms, null, null);
        SignedInfo signedInfo = sigFactory.newSignedInfo(sigFactory.newCanonicalizationMethod("http://www.w3.org/TR/2001/REC-xml-c14n-20010315#WithComments", (C14NMethodParameterSpec)null), sigFactory.newSignatureMethod("http://www.w3.org/2000/09/xmldsig#dsa-sha1", null), Collections.singletonList(ref));
        DOMSignContext dsc = new DOMSignContext(privateKey, sigParent);
        XMLSignature signature = sigFactory.newXMLSignature(signedInfo, keyInfo);
        signature.sign(dsc);
        try (OutputStream os = Files.newOutputStream(Paths.get(args[1], new String[0]), new OpenOption[0]);){
            Transformer trans = TransformerFactory.newInstance().newTransformer();
            trans.transform(new DOMSource(doc), new StreamResult(os));
        }
    }

    private static void usage() {
        System.out.println("Usage: java SignFile <inputFile> <outputFile> [id|path|whole]");
    }

    private static enum SignatureType {
        SIGN_BY_ID,
        SIGN_BY_PATH,
        SIGN_WHOLE_DOCUMENT;

    }
}

