/*
 * Decompiled with CFR 0.152.
 */
package ro.kuberam.libs.java.crypto;

import ro.kuberam.libs.java.crypto.CryptoError;
import ro.kuberam.libs.java.crypto.CryptoException;

public class Parameters {
    private String canonicalizationAlgorithm = "http://www.w3.org/TR/2001/REC-xml-c14n-20010315#WithComments";
    private static String[] CANONICALIZATION_ALGORITHM_VALUES = new String[]{"exclusive", "exclusive-with-comments", "inclusive", "inclusive-with-comments"};
    private String digestAlgorithm = "http://www.w3.org/2000/09/xmldsig#sha1";
    private static String[] DIGEST_ALGORITHM_VALUES = new String[]{"SHA1", "SHA256", "SHA512"};
    private String signatureAlgorithm = "http://www.w3.org/2000/09/xmldsig#rsa-sha1";
    private static String[] SIGNATURE_ALGORITHM_VALUES = new String[]{"DSA_SHA1", "RSA_SHA1"};
    private String signatureNamespacePrefix = "dsig";
    private String signatureType = "enveloped";
    private static String[] SIGNATURE_TYPE_VALUES = new String[]{"enveloping", "enveloped", "detached"};

    public String getCanonicalizationAlgorithm() {
        return this.canonicalizationAlgorithm;
    }

    public void setCanonicalizationAlgorithm(String canonicalizationAlgorithm) throws CryptoException {
        if (!this.contains(CANONICALIZATION_ALGORITHM_VALUES, canonicalizationAlgorithm)) {
            throw new CryptoException(CryptoError.NoSuchAlgorithmException);
        }
        if (canonicalizationAlgorithm.equals("exclusive")) {
            this.canonicalizationAlgorithm = "http://www.w3.org/2001/10/xml-exc-c14n#";
        } else if (canonicalizationAlgorithm.equals("exclusive-with-comments")) {
            this.canonicalizationAlgorithm = "http://www.w3.org/2001/10/xml-exc-c14n#WithComments";
        } else if (canonicalizationAlgorithm.equals("inclusive")) {
            this.canonicalizationAlgorithm = "http://www.w3.org/TR/2001/REC-xml-c14n-20010315";
        }
        this.canonicalizationAlgorithm = canonicalizationAlgorithm;
    }

    public String getDigestAlgorithm() {
        return this.digestAlgorithm;
    }

    public void setDigestAlgorithm(String digestAlgorithm) throws CryptoException {
        if (!this.contains(DIGEST_ALGORITHM_VALUES, digestAlgorithm)) {
            throw new CryptoException(CryptoError.NoSuchAlgorithmException);
        }
        this.digestAlgorithm = digestAlgorithm.equals("SHA256") ? "http://www.w3.org/2001/04/xmlenc#sha256" : (digestAlgorithm.equals("SHA512") ? "http://www.w3.org/2001/04/xmlenc#sha512" : digestAlgorithm);
    }

    public String getSignatureAlgorithm() {
        return this.signatureAlgorithm;
    }

    public void setSignatureAlgorithm(String signatureAlgorithm) throws CryptoException {
        if (!this.contains(SIGNATURE_ALGORITHM_VALUES, signatureAlgorithm)) {
            throw new CryptoException(CryptoError.NoSuchAlgorithmException);
        }
        this.signatureAlgorithm = signatureAlgorithm.equals("DSA_SHA1") ? "http://www.w3.org/2000/09/xmldsig#dsa-sha1" : signatureAlgorithm;
    }

    public String getSignatureNamespacePrefix() {
        return this.signatureNamespacePrefix;
    }

    public void setSignatureNamespacePrefix(String signatureNamespacePrefix) {
        this.signatureNamespacePrefix = signatureNamespacePrefix;
    }

    public String getSignatureType() {
        System.out.println("signatureType = http://www.w3.org/2000/09/xmldsig#enveloped-signature");
        return this.signatureType;
    }

    public void setSignatureType(String signatureType) {
        for (String e : SIGNATURE_TYPE_VALUES) {
            System.out.println("SIGNATURE_TYPE_VALUES = " + e);
        }
        if (!SIGNATURE_TYPE_VALUES.equals(signatureType)) {
            // empty if block
        }
        this.signatureType = signatureType;
    }

    private boolean contains(String[] strs, String str) {
        for (String s : strs) {
            if (!s.equals(str)) continue;
            return true;
        }
        return false;
    }
}

