/*
 * Decompiled with CFR 0.152.
 */
package ro.kuberam.libs.java.crypto.certificates;

import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.InvalidAlgorithmParameterException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertPath;
import java.security.cert.CertPathValidator;
import java.security.cert.CertPathValidatorException;
import java.security.cert.CertPathValidatorResult;
import java.security.cert.CertificateException;
import java.security.cert.PKIXCertPathValidatorResult;
import java.security.cert.PKIXParameters;
import java.security.cert.TrustAnchor;
import java.security.cert.X509Certificate;

public class ValidateCertificationPath {
    public static byte[] validate(CertPath certPath) throws Exception {
        try {
            KeyStore keystore = KeyStore.getInstance(KeyStore.getDefaultType());
            String password = "changeit";
            Path filename = Paths.get(System.getProperty("java.home"), "lib", "security", "cacerts");
            try (InputStream is = Files.newInputStream(filename, new OpenOption[0]);){
                keystore.load(is, "changeit".toCharArray());
            }
            PKIXParameters params = new PKIXParameters(keystore);
            params.setRevocationEnabled(false);
            CertPathValidator certPathValidator = CertPathValidator.getInstance(CertPathValidator.getDefaultType());
            CertPathValidatorResult result = certPathValidator.validate(certPath, params);
            PKIXCertPathValidatorResult pkixResult = (PKIXCertPathValidatorResult)result;
            TrustAnchor ta = pkixResult.getTrustAnchor();
            X509Certificate x509Certificate = ta.getTrustedCert();
        }
        catch (InvalidAlgorithmParameterException | KeyStoreException | NoSuchAlgorithmException | CertPathValidatorException | CertificateException generalSecurityException) {
            // empty catch block
        }
        return null;
    }
}

