/*
 * Decompiled with CFR 0.152.
 */
package ro.kuberam.libs.java.crypto.digest;

import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Base64;
import java.util.Optional;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.kuberam.libs.java.crypto.CryptoError;
import ro.kuberam.libs.java.crypto.CryptoException;
import ro.kuberam.libs.java.crypto.utils.HexString;

public class Hash {
    private static final Logger LOG = LoggerFactory.getLogger(Hash.class);

    public static String hashString(String data, String algorithm) throws CryptoException {
        return Hash.hashString(data, algorithm, null);
    }

    public static String hashString(String data, String algorithm, @Nullable String format) throws CryptoException {
        String actualFormat = Optional.ofNullable(format).filter(str -> !str.isEmpty()).orElse("base64");
        MessageDigest messageDigester = Hash.getMessageDigester(algorithm);
        messageDigester.update(data.getBytes(StandardCharsets.UTF_8));
        byte[] resultBytes = messageDigester.digest();
        if (actualFormat.equals("base64")) {
            return Base64.getEncoder().encodeToString(resultBytes);
        }
        return HexString.fromBytes(resultBytes);
    }

    public static String hashBinary(InputStream data, String algorithm) throws CryptoException, IOException {
        return Hash.hashBinary(data, algorithm, null);
    }

    public static String hashBinary(InputStream data, String algorithm, @Nullable String format) throws CryptoException, IOException {
        String actualFormat = Optional.ofNullable(format).filter(str -> !str.isEmpty()).orElse("base64");
        MessageDigest messageDigester = Hash.getMessageDigester(algorithm);
        byte[] buf = new byte[16384];
        int read = -1;
        while ((read = data.read(buf)) > -1) {
            messageDigester.update(buf, 0, read);
        }
        byte[] resultBytes = messageDigester.digest();
        String result = actualFormat.equals("base64") ? Base64.getEncoder().encodeToString(resultBytes) : HexString.fromBytes(resultBytes);
        LOG.debug("hash value is = {}", (Object)result);
        return result;
    }

    private static MessageDigest getMessageDigester(String algorithm) throws CryptoException {
        try {
            return MessageDigest.getInstance(algorithm);
        }
        catch (NoSuchAlgorithmException e) {
            throw new CryptoException(CryptoError.NoSuchAlgorithmException, (Throwable)e);
        }
    }
}

