/*
 * Decompiled with CFR 0.152.
 */
package ro.kuberam.libs.java.crypto.digitalSignature;

import java.io.InputStream;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Signature;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.xml.crypto.XMLStructure;
import javax.xml.crypto.dom.DOMStructure;
import javax.xml.crypto.dsig.Reference;
import javax.xml.crypto.dsig.SignedInfo;
import javax.xml.crypto.dsig.Transform;
import javax.xml.crypto.dsig.XMLObject;
import javax.xml.crypto.dsig.XMLSignature;
import javax.xml.crypto.dsig.XMLSignatureFactory;
import javax.xml.crypto.dsig.dom.DOMSignContext;
import javax.xml.crypto.dsig.keyinfo.KeyInfo;
import javax.xml.crypto.dsig.keyinfo.KeyInfoFactory;
import javax.xml.crypto.dsig.keyinfo.KeyValue;
import javax.xml.crypto.dsig.keyinfo.X509Data;
import javax.xml.crypto.dsig.keyinfo.X509IssuerSerial;
import javax.xml.crypto.dsig.spec.C14NMethodParameterSpec;
import javax.xml.crypto.dsig.spec.TransformParameterSpec;
import javax.xml.crypto.dsig.spec.XPathFilterParameterSpec;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.bootstrap.DOMImplementationRegistry;
import org.w3c.dom.ls.DOMImplementationLS;
import org.w3c.dom.ls.LSSerializer;

public class GenerateSignature {
    public static byte[] generateSignature(byte[] data, PrivateKey key, String algorithm, String provider) throws Exception {
        Signature signer = Signature.getInstance(algorithm);
        signer.initSign(key);
        signer.update(data);
        return signer.sign();
    }

    public static String GenerateDigitalSignature(Document inputDoc, String canonicalizationAlgorithmURI, String digestAlgorithmURI, String signatureAlgorithmURI, String keyPairAlgorithm, String signatureNamespacePrefix, String signatureType, String xpathExprString, String[] certificateDetails, InputStream keyStoreInputStream) throws Exception {
        DocumentBuilderFactory dbf;
        XMLSignature signature;
        DOMSignContext dsc;
        KeyInfo ki;
        PrivateKey privateKey;
        List<Transform> transforms;
        Node sigParent;
        String providerName = System.getProperty("jsr105Provider", "org.jcp.xml.dsig.internal.dom.XMLDSigRI");
        XMLSignatureFactory sigFactory = XMLSignatureFactory.getInstance("DOM");
        if (xpathExprString == null) {
            sigParent = inputDoc.getDocumentElement();
            transforms = Collections.singletonList(sigFactory.newTransform("http://www.w3.org/2000/09/xmldsig#enveloped-signature", (TransformParameterSpec)null));
        } else {
            XPathFactory factory = XPathFactory.newInstance();
            XPath xpath = factory.newXPath();
            XPathExpression expr = xpath.compile(xpathExprString);
            NodeList nodes = (NodeList)expr.evaluate(inputDoc, XPathConstants.NODESET);
            if (nodes.getLength() < 1) {
                throw new Exception("Can't find node by this XPath expression: " + xpathExprString);
            }
            sigParent = nodes.item(0);
            transforms = Arrays.asList(sigFactory.newTransform("http://www.w3.org/TR/1999/REC-xpath-19991116", new XPathFilterParameterSpec(xpathExprString)), sigFactory.newTransform("http://www.w3.org/2000/09/xmldsig#enveloped-signature", (TransformParameterSpec)null));
        }
        Reference ref = sigFactory.newReference("", sigFactory.newDigestMethod(digestAlgorithmURI, null), transforms, null, null);
        SignedInfo si = sigFactory.newSignedInfo(sigFactory.newCanonicalizationMethod(canonicalizationAlgorithmURI, (C14NMethodParameterSpec)null), sigFactory.newSignatureMethod(signatureAlgorithmURI, null), Collections.singletonList(ref));
        if (certificateDetails[0].length() != 0) {
            KeyStore keyStore;
            try {
                keyStore = KeyStore.getInstance(certificateDetails[0]);
            }
            catch (Exception ex) {
                throw new Exception("The keystore type '" + certificateDetails[0] + "' is not supported!.");
            }
            keyStore.load(keyStoreInputStream, certificateDetails[1].toCharArray());
            String alias = certificateDetails[2];
            if (!keyStore.containsAlias(alias)) {
                throw new Exception("Cannot find key for alias '" + alias + "' in given keystore!.");
            }
            privateKey = (PrivateKey)keyStore.getKey(alias, certificateDetails[3].toCharArray());
            X509Certificate cert = (X509Certificate)keyStore.getCertificate(alias);
            PublicKey publicKey = cert.getPublicKey();
            KeyInfoFactory kif = sigFactory.getKeyInfoFactory();
            ArrayList<XMLStructure> kiContent = new ArrayList<XMLStructure>();
            KeyValue keyValue = kif.newKeyValue(publicKey);
            kiContent.add(keyValue);
            ArrayList<Object> x509Content = new ArrayList<Object>();
            X509IssuerSerial issuer = kif.newX509IssuerSerial(cert.getIssuerX500Principal().getName(), cert.getSerialNumber());
            x509Content.add(cert.getSubjectX500Principal().getName());
            x509Content.add(issuer);
            x509Content.add(cert);
            X509Data x509Data = kif.newX509Data(x509Content);
            kiContent.add(x509Data);
            ki = kif.newKeyInfo(kiContent);
        } else {
            KeyPairGenerator kpg = KeyPairGenerator.getInstance(keyPairAlgorithm);
            kpg.initialize(512);
            KeyPair kp = kpg.generateKeyPair();
            KeyInfoFactory kif = sigFactory.getKeyInfoFactory();
            KeyValue kv = kif.newKeyValue(kp.getPublic());
            ki = kif.newKeyInfo(Collections.singletonList(kv));
            privateKey = kp.getPrivate();
        }
        Document signatureDoc = null;
        if (signatureType.equals("enveloped")) {
            dsc = new DOMSignContext(privateKey, sigParent);
            signature = sigFactory.newXMLSignature(si, ki);
        } else if (signatureType.equals("detached")) {
            dbf = DocumentBuilderFactory.newInstance();
            dbf.setNamespaceAware(true);
            sigParent = dbf.newDocumentBuilder().newDocument();
            dsc = new DOMSignContext(privateKey, sigParent);
            signature = sigFactory.newXMLSignature(si, ki);
        } else if (signatureType.equals("enveloping")) {
            dbf = DocumentBuilderFactory.newInstance();
            dbf.setNamespaceAware(true);
            signatureDoc = dbf.newDocumentBuilder().newDocument();
            DOMStructure content = new DOMStructure(sigParent);
            XMLObject xmlobj = sigFactory.newXMLObject(Collections.singletonList(content), "object", null, null);
            dsc = new DOMSignContext(privateKey, (Node)signatureDoc);
            signature = sigFactory.newXMLSignature(si, ki, Collections.singletonList(xmlobj), null, null);
        } else {
            dsc = null;
            signature = null;
        }
        dsc.setDefaultNamespacePrefix(signatureNamespacePrefix);
        signature.sign(dsc);
        DOMImplementationRegistry registry = DOMImplementationRegistry.newInstance();
        DOMImplementationLS impl = (DOMImplementationLS)((Object)registry.getDOMImplementation("LS"));
        LSSerializer serializer = impl.createLSSerializer();
        if (signatureType.equals("enveloping")) {
            return serializer.writeToString(signatureDoc);
        }
        return serializer.writeToString(sigParent);
    }
}

