/*
 * Decompiled with CFR 0.152.
 */
package ro.kuberam.libs.java.crypto.digitalSignature;

import java.security.KeyPair;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Signature;
import ro.kuberam.libs.java.crypto.keyManagement.GenerateKeyPair;

public class GenerateSignatureOnBinary {
    public static byte[] generateSignatureOnBinary(byte[] data, PrivateKey privateKey, String algorithm) throws Exception {
        Signature dsa = Signature.getInstance(algorithm);
        dsa.initSign(privateKey);
        dsa.update(data);
        return dsa.sign();
    }

    public static boolean verifySig(byte[] data, PublicKey key, byte[] sig) throws Exception {
        Signature signer = Signature.getInstance("SHA1withDSA");
        signer.initVerify(key);
        signer.update(data);
        return signer.verify(sig);
    }

    public static void main(String[] args) throws Exception {
        KeyPair keyPair = GenerateKeyPair.generate("SHA1PRNG", 1008L, "base64");
        byte[] data = new byte[]{65, 66, 67, 68, 69, 70, 71, 72, 73, 74};
        byte[] signature = GenerateSignatureOnBinary.generateSignatureOnBinary(data, keyPair.getPrivate(), "SHA1withDSA");
        System.out.println("Signature:\n" + new String(signature));
    }
}

