/*
 * Decompiled with CFR 0.152.
 */
package ro.kuberam.libs.java.crypto.digitalSignature;

import java.io.IOException;
import java.io.InputStream;
import java.security.InvalidAlgorithmParameterException;
import java.security.KeyException;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.xml.crypto.MarshalException;
import javax.xml.crypto.XMLStructure;
import javax.xml.crypto.dom.DOMStructure;
import javax.xml.crypto.dsig.Reference;
import javax.xml.crypto.dsig.SignedInfo;
import javax.xml.crypto.dsig.Transform;
import javax.xml.crypto.dsig.XMLObject;
import javax.xml.crypto.dsig.XMLSignature;
import javax.xml.crypto.dsig.XMLSignatureException;
import javax.xml.crypto.dsig.XMLSignatureFactory;
import javax.xml.crypto.dsig.dom.DOMSignContext;
import javax.xml.crypto.dsig.keyinfo.KeyInfo;
import javax.xml.crypto.dsig.keyinfo.KeyInfoFactory;
import javax.xml.crypto.dsig.keyinfo.KeyValue;
import javax.xml.crypto.dsig.keyinfo.X509Data;
import javax.xml.crypto.dsig.keyinfo.X509IssuerSerial;
import javax.xml.crypto.dsig.spec.C14NMethodParameterSpec;
import javax.xml.crypto.dsig.spec.TransformParameterSpec;
import javax.xml.crypto.dsig.spec.XPathFilterParameterSpec;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.bootstrap.DOMImplementationRegistry;
import org.w3c.dom.ls.DOMImplementationLS;
import org.w3c.dom.ls.LSSerializer;
import ro.kuberam.libs.java.crypto.CryptoError;
import ro.kuberam.libs.java.crypto.CryptoException;

public class GenerateXmlSignature {
    public static String generate(Document inputDoc, String canonicalizationAlgorithm, String digestAlgorithm, String signatureAlgorithm, String signatureNamespacePrefix, String signatureType, String xpathExprString, String[] certificateDetails, InputStream keyStoreInputStream) throws CryptoException, IOException, XMLSignatureException {
        String mechanismType = "DOM";
        return GenerateXmlSignature.generate(inputDoc, mechanismType, canonicalizationAlgorithm, digestAlgorithm, signatureAlgorithm, signatureNamespacePrefix, signatureType, xpathExprString, certificateDetails, keyStoreInputStream);
    }

    public static String generate(Document inputDoc, String mechanismType, String canonicalizationAlgorithm, String digestAlgorithm, String signatureAlgorithm, String signatureNamespacePrefix, String signatureType, String xpathExprString, String[] certificateDetails, InputStream keyStoreInputStream) throws CryptoException, IOException, XMLSignatureException {
        String canonicalizationAlgorithmURI = GenerateXmlSignature.getCanonicalizationAlgorithmUri(canonicalizationAlgorithm);
        String digestAlgorithmURI = GenerateXmlSignature.getDigestAlgorithmURI(digestAlgorithm);
        String signatureAlgorithmURI = GenerateXmlSignature.getSignatureAlgorithmURI(signatureAlgorithm);
        String keyPairAlgorithm = signatureAlgorithm.substring(0, 3);
        XMLSignatureFactory sigFactory = XMLSignatureFactory.getInstance(mechanismType);
        Node sigParent = null;
        try {
            DOMImplementationRegistry registry;
            DocumentBuilderFactory dbf;
            KeyInfo ki;
            PrivateKey privateKey;
            List<Transform> transforms;
            if (xpathExprString == null) {
                sigParent = inputDoc.getDocumentElement();
                transforms = Collections.singletonList(sigFactory.newTransform("http://www.w3.org/2000/09/xmldsig#enveloped-signature", (TransformParameterSpec)null));
            } else {
                XPathFactory factory = XPathFactory.newInstance();
                XPath xpath = factory.newXPath();
                XPathExpression expr = xpath.compile(xpathExprString);
                NodeList nodes = (NodeList)expr.evaluate(inputDoc, XPathConstants.NODESET);
                if (nodes.getLength() < 1) {
                    throw new CryptoException(CryptoError.NoSuchAlgorithmException);
                }
                sigParent = nodes.item(0);
                transforms = Arrays.asList(sigFactory.newTransform("http://www.w3.org/TR/1999/REC-xpath-19991116", new XPathFilterParameterSpec(xpathExprString)), sigFactory.newTransform("http://www.w3.org/2000/09/xmldsig#enveloped-signature", (TransformParameterSpec)null));
            }
            Reference ref = sigFactory.newReference("", sigFactory.newDigestMethod(digestAlgorithmURI, null), transforms, null, null);
            SignedInfo si = sigFactory.newSignedInfo(sigFactory.newCanonicalizationMethod(canonicalizationAlgorithmURI, (C14NMethodParameterSpec)null), sigFactory.newSignatureMethod(signatureAlgorithmURI, null), Collections.singletonList(ref));
            if (certificateDetails[0].length() != 0) {
                KeyStore keyStore;
                try {
                    keyStore = KeyStore.getInstance(certificateDetails[0]);
                }
                catch (KeyStoreException e) {
                    throw CryptoException.fromCause(e);
                }
                keyStore.load(keyStoreInputStream, certificateDetails[1].toCharArray());
                String alias = certificateDetails[2];
                if (!keyStore.containsAlias(alias)) {
                    throw new CryptoException(CryptoError.ALIAS_KEY);
                }
                privateKey = (PrivateKey)keyStore.getKey(alias, certificateDetails[3].toCharArray());
                X509Certificate cert = (X509Certificate)keyStore.getCertificate(alias);
                PublicKey publicKey = cert.getPublicKey();
                KeyInfoFactory kif = sigFactory.getKeyInfoFactory();
                ArrayList<XMLStructure> kiContent = new ArrayList<XMLStructure>();
                KeyValue keyValue = kif.newKeyValue(publicKey);
                kiContent.add(keyValue);
                ArrayList<Object> x509Content = new ArrayList<Object>();
                X509IssuerSerial issuer = kif.newX509IssuerSerial(cert.getIssuerX500Principal().getName(), cert.getSerialNumber());
                x509Content.add(cert.getSubjectX500Principal().getName());
                x509Content.add(issuer);
                x509Content.add(cert);
                X509Data x509Data = kif.newX509Data(x509Content);
                kiContent.add(x509Data);
                ki = kif.newKeyInfo(kiContent);
            } else {
                KeyPairGenerator kpg = KeyPairGenerator.getInstance(keyPairAlgorithm);
                kpg.initialize(512);
                KeyPair kp = kpg.generateKeyPair();
                KeyInfoFactory kif = sigFactory.getKeyInfoFactory();
                KeyValue kv = kif.newKeyValue(kp.getPublic());
                ki = kif.newKeyInfo(Collections.singletonList(kv));
                privateKey = kp.getPrivate();
            }
            DOMSignContext dsc = null;
            XMLSignature signature = null;
            Document signatureDoc = null;
            if (signatureType.equals("enveloped")) {
                dsc = new DOMSignContext(privateKey, sigParent);
                signature = sigFactory.newXMLSignature(si, ki);
            } else if (signatureType.equals("detached")) {
                dbf = DocumentBuilderFactory.newInstance();
                dbf.setNamespaceAware(true);
                sigParent = dbf.newDocumentBuilder().newDocument();
                dsc = new DOMSignContext(privateKey, sigParent);
                signature = sigFactory.newXMLSignature(si, ki);
            } else if (signatureType.equals("enveloping")) {
                dbf = DocumentBuilderFactory.newInstance();
                dbf.setNamespaceAware(true);
                signatureDoc = dbf.newDocumentBuilder().newDocument();
                DOMStructure content = new DOMStructure(sigParent);
                XMLObject xmlobj = sigFactory.newXMLObject(Collections.singletonList(content), "object", null, null);
                dsc = new DOMSignContext(privateKey, (Node)signatureDoc);
                signature = sigFactory.newXMLSignature(si, ki, Collections.singletonList(xmlobj), null, null);
            }
            dsc.setDefaultNamespacePrefix(signatureNamespacePrefix);
            signature.sign(dsc);
            try {
                registry = DOMImplementationRegistry.newInstance();
            }
            catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
                throw new IOException(e);
            }
            DOMImplementationLS impl = (DOMImplementationLS)((Object)registry.getDOMImplementation("LS"));
            LSSerializer serializer = impl.createLSSerializer();
            if (signatureType.equals("enveloping")) {
                return serializer.writeToString(signatureDoc);
            }
            return serializer.writeToString(sigParent);
        }
        catch (InvalidAlgorithmParameterException | NoSuchAlgorithmException e) {
            throw new CryptoException(CryptoError.NoSuchAlgorithmException, (Throwable)e);
        }
        catch (CertificateException e) {
            throw new CryptoException(CryptoError.InvalidKeySpecException, (Throwable)e);
        }
        catch (KeyStoreException e) {
            throw new CryptoException(CryptoError.UNREADABLE_KEYSTORE, (Throwable)e);
        }
        catch (KeyException | UnrecoverableKeyException e) {
            throw new CryptoException(CryptoError.InvalidKeySpecException, (Throwable)e);
        }
        catch (MarshalException | ParserConfigurationException | XPathExpressionException e) {
            throw new IOException(e);
        }
    }

    private static String getCanonicalizationAlgorithmUri(String canonicalizationAlgorithm) throws CryptoException {
        switch (canonicalizationAlgorithm) {
            case "exclusive": {
                return "http://www.w3.org/2001/10/xml-exc-c14n#";
            }
            case "exclusive-with-comments": {
                return "http://www.w3.org/2001/10/xml-exc-c14n#WithComments";
            }
            case "inclusive": {
                return "http://www.w3.org/TR/2001/REC-xml-c14n-20010315";
            }
        }
        throw new CryptoException(CryptoError.NoSuchAlgorithmException);
    }

    private static String getDigestAlgorithmURI(String digestAlgorithm) throws CryptoException {
        switch (digestAlgorithm) {
            case "SHA256": {
                return "http://www.w3.org/2001/04/xmlenc#sha256";
            }
            case "SHA512": {
                return "http://www.w3.org/2001/04/xmlenc#sha512";
            }
            case "SHA1": 
            case "": {
                return "http://www.w3.org/2000/09/xmldsig#sha1";
            }
        }
        throw new CryptoException(CryptoError.NoSuchAlgorithmException);
    }

    private static String getSignatureAlgorithmURI(String signatureAlgorithm) throws CryptoException {
        switch (signatureAlgorithm) {
            case "DSA_SHA1": {
                return "http://www.w3.org/2000/09/xmldsig#dsa-sha1";
            }
            case "RSA_SHA1": 
            case "": {
                return "http://www.w3.org/2000/09/xmldsig#rsa-sha1";
            }
        }
        throw new CryptoException(CryptoError.NoSuchAlgorithmException);
    }
}

