/*
 * Decompiled with CFR 0.152.
 */
package ro.kuberam.libs.java.crypto.encrypt;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.util.Base64;
import java.util.StringTokenizer;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import ro.kuberam.libs.java.crypto.CryptoException;
import ro.kuberam.libs.java.crypto.keyManagement.Load;

public class AsymmetricEncryption {
    public static String encryptString(String data, Key key, String transformationName) throws CryptoException, IOException {
        String provider = "SUN";
        return AsymmetricEncryption.encryptString(data, key, transformationName, provider);
    }

    public static String encryptString(String data, Key key, String transformationName, String provider) throws CryptoException, IOException {
        byte[] dataBytes = data.getBytes(StandardCharsets.UTF_8);
        byte[] resultBytes = null;
        try {
            Cipher cipher = Cipher.getInstance(transformationName);
            cipher.init(1, key);
            resultBytes = cipher.doFinal(dataBytes);
        }
        catch (InvalidKeyException | NoSuchAlgorithmException | BadPaddingException | IllegalBlockSizeException | NoSuchPaddingException e) {
            throw CryptoException.fromCause(e);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return Base64.getEncoder().encodeToString(resultBytes);
    }

    public static String decryptString(String encryptedData, PrivateKey privateKey, String transformationName) throws CryptoException, IOException {
        String provider = "SUN";
        return AsymmetricEncryption.decryptString(encryptedData, privateKey, transformationName, provider);
    }

    public static String decryptString(String encryptedData, PrivateKey privateKey, String transformationName, String provider) throws CryptoException, IOException {
        byte[] dataBytes = Base64.getDecoder().decode(encryptedData);
        byte[] resultBytes = null;
        try {
            Cipher cipher = Cipher.getInstance(transformationName);
            cipher.init(2, privateKey);
            resultBytes = cipher.doFinal(dataBytes);
        }
        catch (InvalidKeyException | NoSuchAlgorithmException | BadPaddingException | IllegalBlockSizeException | NoSuchPaddingException e) {
            throw CryptoException.fromCause(e);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return new String(resultBytes, StandardCharsets.UTF_8);
    }

    public static String encryptBinary(InputStream data, String base64PublicKey, String transformationName, String provider) throws CryptoException, IOException {
        String algorithm = transformationName.split("/")[0];
        byte[] resultBytes = null;
        try {
            Cipher cipher = Cipher.getInstance(transformationName);
            PublicKey publicKey = Load.publicKey(base64PublicKey, algorithm, provider);
            cipher.init(1, publicKey);
            byte[] buf = new byte[16384];
            int read = -1;
            while ((read = data.read(buf)) > -1) {
                cipher.update(buf, 0, read);
            }
            resultBytes = cipher.doFinal();
        }
        catch (InvalidKeyException | NoSuchAlgorithmException | BadPaddingException | IllegalBlockSizeException | NoSuchPaddingException e) {
            throw CryptoException.fromCause(e);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return AsymmetricEncryption.getString(resultBytes);
    }

    public static String decryptBinary(InputStream data, String base64PrivateKey, String transformationName, String provider) throws CryptoException, IOException {
        String algorithm = transformationName.split("/")[0];
        byte[] resultBytes = null;
        try {
            Cipher cipher = Cipher.getInstance(transformationName);
            PrivateKey privateKey = Load.privateKey(base64PrivateKey, algorithm, provider);
            cipher.init(2, privateKey);
            byte[] buf = new byte[16384];
            int read = -1;
            while ((read = data.read(buf)) > -1) {
                cipher.update(buf, 0, read);
            }
            resultBytes = cipher.doFinal();
        }
        catch (InvalidKeyException | NoSuchAlgorithmException | BadPaddingException | IllegalBlockSizeException | NoSuchPaddingException e) {
            throw CryptoException.fromCause(e);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return AsymmetricEncryption.getString(resultBytes);
    }

    public static String getString(byte[] bytes) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < bytes.length; ++i) {
            byte b = bytes[i];
            sb.append(0xFF & b);
            if (i + 1 >= bytes.length) continue;
            sb.append("-");
        }
        return sb.toString();
    }

    public static byte[] getBytes(String str) throws IOException {
        StringTokenizer st = new StringTokenizer(str, "-", false);
        try (ByteArrayOutputStream bos = new ByteArrayOutputStream();){
            while (st.hasMoreTokens()) {
                int i = Integer.parseInt(st.nextToken());
                bos.write((byte)i);
            }
            byte[] byArray = bos.toByteArray();
            return byArray;
        }
    }
}

