/*
 * Decompiled with CFR 0.152.
 */
package ro.kuberam.libs.java.crypto.encrypt;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.util.Optional;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import ro.kuberam.libs.java.crypto.CryptoError;
import ro.kuberam.libs.java.crypto.CryptoException;

public class SymmetricEncryption {
    public static byte[] encrypt(byte[] input, String plainKey, String transformationName, String iv, String provider) throws CryptoException, IOException {
        return SymmetricEncryption.operation(input, plainKey, transformationName, iv, provider, 1);
    }

    public static byte[] decrypt(byte[] encryptedInput, String plainKey, String transformationName, String iv, String provider) throws CryptoException, IOException {
        return SymmetricEncryption.operation(encryptedInput, plainKey, transformationName, iv, provider, 2);
    }

    public static byte[] operation(byte[] input, String secretKey, String transformationName, String iv, String provider, int operationType) throws CryptoException, IOException {
        byte[] result;
        Cipher cipher;
        String algorithm = transformationName.contains("/") ? transformationName.substring(0, transformationName.indexOf("/")) : transformationName;
        String actualProvider = Optional.ofNullable(provider).filter(str -> !str.isEmpty()).orElse("SunJCE");
        try {
            cipher = Cipher.getInstance(transformationName, actualProvider);
        }
        catch (NoSuchAlgorithmException | NoSuchProviderException | NoSuchPaddingException e) {
            throw CryptoException.fromCause(e);
        }
        SecretKeySpec skeySpec = SymmetricEncryption.generateSecretKey(secretKey, algorithm);
        if (transformationName.contains("/")) {
            IvParameterSpec ivSpec = new IvParameterSpec(iv.getBytes(StandardCharsets.UTF_8), 0, 16);
            try {
                cipher.init(operationType, (Key)skeySpec, ivSpec);
            }
            catch (InvalidAlgorithmParameterException | InvalidKeyException e) {
                throw CryptoException.fromCause(e);
            }
        }
        try {
            cipher.init(operationType, skeySpec);
        }
        catch (InvalidKeyException e) {
            throw new CryptoException(CryptoError.InvalidKeySpecException, (Throwable)e);
        }
        try {
            result = cipher.doFinal(input);
        }
        catch (BadPaddingException | IllegalBlockSizeException e) {
            throw CryptoException.fromCause(e);
        }
        return result;
    }

    private static SecretKeySpec generateSecretKey(String secretKey, String algorithm) {
        return new SecretKeySpec(secretKey.getBytes(StandardCharsets.UTF_8), algorithm);
    }
}

