/*
 * Decompiled with CFR 0.152.
 */
package ro.kuberam.libs.java.crypto.keyManagement;

import java.security.GeneralSecurityException;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import java.util.Base64;
import ro.kuberam.libs.java.crypto.randomSequencesGeneration.RandomNumber;

public class GenerateKeyPair {
    private static Base64.Encoder encoder = Base64.getEncoder();

    public static GeneratedKeys run(String algorithm) throws Exception {
        KeyPairGenerator keyGenerator = GenerateKeyPair.getKeyPairGenerator(algorithm);
        keyGenerator.initialize(2048);
        KeyPair keys = keyGenerator.generateKeyPair();
        String privateKey = GenerateKeyPair.outputPrivatekey(keys.getPrivate().getEncoded(), algorithm);
        String publicKey = GenerateKeyPair.outputPublickey(keys.getPublic().getEncoded(), algorithm);
        return new GeneratedKeys(privateKey, publicKey);
    }

    public static GeneratedKeys run(String algorithm, String provider) throws Exception {
        KeyPairGenerator keyGenerator = GenerateKeyPair.getKeyPairGenerator(algorithm, provider);
        keyGenerator.initialize(2048);
        KeyPair keys = keyGenerator.generateKeyPair();
        String privateKey = GenerateKeyPair.outputPrivatekey(keys.getPrivate().getEncoded(), algorithm);
        String publicKey = GenerateKeyPair.outputPublickey(keys.getPublic().getEncoded(), algorithm);
        return new GeneratedKeys(privateKey, publicKey);
    }

    public static KeyPair generate(String algorithm, long seed, String provider) throws Exception {
        KeyPairGenerator keyGenerator = KeyPairGenerator.getInstance(algorithm);
        keyGenerator.initialize(1024, RandomNumber.generate(seed, "SHA1PRNG", provider));
        return keyGenerator.generateKeyPair();
    }

    private static String outputPrivatekey(byte[] privateKey, String algorithm) {
        return "-----BEGIN " + algorithm + " PRIVATE KEY-----\n" + encoder.encodeToString(privateKey) + "\n-----END " + algorithm + " PRIVATE KEY-----\n";
    }

    private static String outputPublickey(byte[] publicKey, String algorithm) {
        return "-----BEGIN " + algorithm + " PUBLIC KEY-----\n" + encoder.encodeToString(publicKey) + "\n-----END " + algorithm + " PUBLIC KEY-----\n";
    }

    private static KeyPairGenerator getKeyPairGenerator(String algorithm) throws NoSuchAlgorithmException {
        return KeyPairGenerator.getInstance(algorithm);
    }

    private static KeyPairGenerator getKeyPairGenerator(String algorithm, String provider) throws NoSuchAlgorithmException, NoSuchProviderException {
        return KeyPairGenerator.getInstance(algorithm, provider);
    }

    public static String savePrivateKey(PrivateKey priv) throws GeneralSecurityException {
        KeyFactory fact = KeyFactory.getInstance("EllipticCurve");
        PKCS8EncodedKeySpec spec = fact.getKeySpec(priv, PKCS8EncodedKeySpec.class);
        return Base64.getEncoder().encodeToString(spec.getEncoded());
    }

    public static String savePublicKey(PublicKey publ) throws GeneralSecurityException {
        KeyFactory fact = KeyFactory.getInstance("EllipticCurve");
        X509EncodedKeySpec spec = fact.getKeySpec(publ, X509EncodedKeySpec.class);
        return Base64.getEncoder().encodeToString(spec.getEncoded());
    }

    public static class GeneratedKeys {
        private final String privateKey;
        private final String publicKey;

        public GeneratedKeys(String privateKey, String publicKey) {
            this.privateKey = privateKey;
            this.publicKey = publicKey;
        }

        public String getPrivateKey() {
            return this.privateKey;
        }

        public String getPublicKey() {
            return this.publicKey;
        }
    }
}

