/*
 * Decompiled with CFR 0.152.
 */
package ro.kuberam.libs.java.crypto.providers;

import java.security.Provider;
import java.security.Security;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;

public class ListAvailableCryptographicServices {
    /*
     * WARNING - void declaration
     */
    private static String[] getServiceTypes() {
        HashSet<String> result = new HashSet<String>();
        Provider[] providers = Security.getProviders();
        for (int i = 0; i < providers.length; ++i) {
            Set<Object> keys = providers[i].keySet();
            for (String string : keys) {
                void var5_5;
                String string2 = string.split(" ")[0];
                if (string2.startsWith("Alg.Alias")) {
                    String string3 = string2.substring(10);
                }
                int ix = var5_5.indexOf(46);
                result.add(var5_5.substring(0, ix));
            }
        }
        return result.toArray(new String[result.size()]);
    }

    private static String[] getCryptoImpls(String serviceType) {
        HashSet<String> result = new HashSet<String>();
        Provider[] providers = Security.getProviders();
        for (int i = 0; i < providers.length; ++i) {
            Set<Object> keys = providers[i].keySet();
            for (String string : keys) {
                String string2 = string.split(" ")[0];
                if (string2.startsWith(serviceType + ".")) {
                    result.add(string2.substring(serviceType.length() + 1));
                    continue;
                }
                if (!string2.startsWith("Alg.Alias." + serviceType + ".")) continue;
                result.add(string2.substring(serviceType.length() + 11));
            }
        }
        return result.toArray(new String[result.size()]);
    }

    private static void listServiceTypes() {
        System.out.println();
        System.out.println("Service Types");
        System.out.println("-------------");
        Object[] serviceTypes = ListAvailableCryptographicServices.getServiceTypes();
        Arrays.sort(serviceTypes);
        for (int i = 0; i < serviceTypes.length; ++i) {
            System.out.println("  - " + (String)serviceTypes[i]);
        }
        System.out.println();
    }

    private static void listCryptoImpls() {
        System.out.println();
        System.out.println("Service Type Implementations");
        System.out.println("----------------------------");
        Object[] serviceTypes = ListAvailableCryptographicServices.getServiceTypes();
        Arrays.sort(serviceTypes);
        for (int i = 0; i < serviceTypes.length; ++i) {
            System.out.println();
            System.out.println("  - " + (String)serviceTypes[i]);
            Object[] serviceTypeImpls = ListAvailableCryptographicServices.getCryptoImpls((String)serviceTypes[i]);
            Arrays.sort(serviceTypeImpls);
            for (int j = 0; j < serviceTypeImpls.length; ++j) {
                System.out.println("      " + (String)serviceTypeImpls[j]);
            }
        }
        System.out.println();
    }

    public static void main(String[] args) {
        ListAvailableCryptographicServices.listServiceTypes();
        ListAvailableCryptographicServices.listCryptoImpls();
    }
}

