/*
 * Decompiled with CFR 0.152.
 */
package ro.kuberam.libs.java.crypto.providers;

import java.io.IOException;
import java.io.StringWriter;
import java.security.Provider;
import java.security.Security;
import java.util.Date;
import java.util.Set;
import javax.xml.stream.FactoryConfigurationError;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import javax.xml.transform.stream.StreamResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ListProviders {
    private static final Logger LOG = LoggerFactory.getLogger(ListProviders.class);
    private static String moduleNsUri = "http://expath.org/ns/crypto";
    private static String modulePrefix = "crypto";

    /*
     * WARNING - void declaration
     */
    public static StreamResult listProviders() throws XMLStreamException, FactoryConfigurationError, IOException {
        long startTime = new Date().getTime();
        try (StringWriter writer = new StringWriter();){
            XMLStreamWriter xmlWriter = XMLOutputFactory.newInstance().createXMLStreamWriter(writer);
            xmlWriter.setPrefix(modulePrefix, moduleNsUri);
            xmlWriter.writeStartDocument();
            xmlWriter.writeStartElement(modulePrefix + ":providers-list");
            xmlWriter.writeNamespace(modulePrefix, moduleNsUri);
            for (Provider provider : Security.getProviders()) {
                xmlWriter.writeStartElement(modulePrefix + ":provider");
                xmlWriter.writeAttribute("name", provider.getName());
                xmlWriter.writeAttribute("version", Double.toString(provider.getVersion()));
                Set<Object> keys = provider.keySet();
                System.out.println(provider.elements().nextElement().toString());
                for (String string : keys) {
                    void var11_13;
                    String string2 = string.split(" ")[0];
                    if (string2.startsWith("Alg.Alias")) {
                        String string3 = string2.substring(10);
                    }
                    int n = var11_13.indexOf(46);
                }
                xmlWriter.writeEndElement();
            }
            xmlWriter.writeEndElement();
            xmlWriter.writeEndDocument();
            xmlWriter.close();
            StreamResult resultAsStreamResult = new StreamResult(writer);
            LOG.debug("The list with cryptographic providers was generated in {} ms.", (Object)(new Date().getTime() - startTime));
            StreamResult streamResult = resultAsStreamResult;
            return streamResult;
        }
    }
}

