/*
 * Decompiled with CFR 0.152.
 */
package ro.kuberam.libs.java.crypto.providers;

import java.io.IOException;
import java.io.StringWriter;
import java.security.Provider;
import java.security.Security;
import java.util.Date;
import javax.xml.stream.FactoryConfigurationError;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import javax.xml.transform.stream.StreamResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ListServices {
    private static final Logger LOG = LoggerFactory.getLogger(ListServices.class);
    private static String moduleNsUri = "http://expath.org/ns/crypto";
    private static String modulePrefix = "crypto";

    public static StreamResult listServices(String providerName) throws XMLStreamException, FactoryConfigurationError, IOException {
        long startTime = new Date().getTime();
        try (StringWriter writer = new StringWriter();){
            XMLStreamWriter xmlWriter = XMLOutputFactory.newInstance().createXMLStreamWriter(writer);
            xmlWriter.setPrefix(modulePrefix, moduleNsUri);
            xmlWriter.writeStartDocument();
            xmlWriter.writeStartElement(modulePrefix + ":providers-list");
            xmlWriter.writeNamespace(modulePrefix, moduleNsUri);
            for (Provider provider : Security.getProviders()) {
                xmlWriter.writeStartElement(modulePrefix + ":provider");
                xmlWriter.writeCharacters(provider.getName());
                xmlWriter.writeEndElement();
            }
            xmlWriter.writeEndElement();
            xmlWriter.writeEndDocument();
            xmlWriter.close();
            StreamResult resultAsStreamResult = new StreamResult(writer);
            LOG.debug("The list with cryptographic services for provider {} was generated in {} ms.", (Object)providerName, (Object)(new Date().getTime() - startTime));
            StreamResult streamResult = resultAsStreamResult;
            return streamResult;
        }
    }
}

