/*
 * Decompiled with CFR 0.152.
 */
package ro.kuberam.libs.java.crypto.secureStorage;

import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.InvalidAlgorithmParameterException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.security.cert.PKIXParameters;
import java.security.cert.TrustAnchor;
import java.security.cert.X509Certificate;

public class ListTrustedCertificateAuthorities {
    public static void main(String[] args) {
        Path filename = Paths.get(System.getProperty("java.home"), "lib", "security", "cacerts");
        try (InputStream is = Files.newInputStream(filename, new OpenOption[0]);){
            KeyStore keystore = KeyStore.getInstance(KeyStore.getDefaultType());
            String password = "changeit";
            keystore.load(is, "changeit".toCharArray());
            PKIXParameters params = new PKIXParameters(keystore);
            for (TrustAnchor ta : params.getTrustAnchors()) {
                X509Certificate cert = ta.getTrustedCert();
                System.out.println(cert.getIssuerDN());
            }
        }
        catch (IOException | InvalidAlgorithmParameterException | KeyStoreException | NoSuchAlgorithmException | CertificateException exception) {
            // empty catch block
        }
    }
}

