/*
 * Decompiled with CFR 0.152.
 */
package ro.kuberam.libs.java.crypto.secureStorage;

import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.security.KeyStore;
import java.security.NoSuchAlgorithmException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;

class ReloadableX509TrustManager
implements X509TrustManager {
    private final String trustStorePath;
    private X509TrustManager trustManager;

    public ReloadableX509TrustManager(String tspath) throws Exception {
        this.trustStorePath = tspath;
        this.reloadTrustManager();
    }

    @Override
    public X509Certificate[] getAcceptedIssuers() {
        X509Certificate[] issuers = this.trustManager.getAcceptedIssuers();
        return issuers;
    }

    private void reloadTrustManager() throws Exception {
        KeyStore ts = KeyStore.getInstance(KeyStore.getDefaultType());
        try (InputStream in = Files.newInputStream(Paths.get(this.trustStorePath, new String[0]), new OpenOption[0]);){
            ts.load(in, null);
        }
        TrustManagerFactory tmf = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
        tmf.init(ts);
        TrustManager[] tms = tmf.getTrustManagers();
        for (int i = 0; i < tms.length; ++i) {
            if (!(tms[i] instanceof X509TrustManager)) continue;
            this.trustManager = (X509TrustManager)tms[i];
            return;
        }
        throw new NoSuchAlgorithmException("No X509TrustManager in TrustManagerFactory");
    }

    private void addServerCertAndReload(Certificate cert, boolean permanent) {
        try {
            if (permanent) {
                Runtime.getRuntime().exec("keytool -importcert ...");
            }
            this.reloadTrustManager();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        this.trustManager.checkClientTrusted(chain, authType);
    }

    @Override
    public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        try {
            this.trustManager.checkServerTrusted(chain, authType);
        }
        catch (CertificateException cx) {
            this.addServerCertAndReload(chain[0], true);
            this.trustManager.checkServerTrusted(chain, authType);
        }
    }
}

