/*
 * Decompiled with CFR 0.152.
 */
package org.fastquery.httpsign;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.ExceptionMapper;
import org.fastquery.httpsign.Code;
import org.fastquery.httpsign.ReplyBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InvokeFaultExceptionMapper
implements ExceptionMapper<Throwable> {
    private static final Logger LOG = LoggerFactory.getLogger(InvokeFaultExceptionMapper.class);
    @Context
    private HttpServletRequest request;
    @Context
    private HttpServletResponse response;

    public Response toResponse(Throwable throwable) {
        LOG.error(throwable.getMessage(), throwable);
        if (throwable instanceof WebApplicationException) {
            WebApplicationException wae = (WebApplicationException)throwable;
            return ReplyBuilder.error(wae.getResponse().getStatus(), wae.getMessage()).build();
        }
        return ReplyBuilder.error(Code.E50300).build();
    }
}

