/*
 * Decompiled with CFR 0.152.
 */
package org.fastquery.httpsign;

import java.io.UnsupportedEncodingException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.util.Base64;
import java.util.SortedMap;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import org.fastquery.httpsign.Factor;

public class SignBuilder {
    public static final String UTF8 = "UTF-8";
    public static final int AUTH_LEN = 34;
    public static final String BASIC = "Basic ";
    public static final int TIME_LIMIT = 600000;
    public static final String HMACSHA = "HMACSHA1";

    private SignBuilder() {
    }

    private static String buildCustomHeader(SortedMap<String, String> headers) {
        if (headers == null || headers.isEmpty()) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        headers.forEach((k, v) -> sb.append(k.toLowerCase()).append(':').append((String)v).append('\n'));
        return sb.toString();
    }

    static String buidStringFactor(Factor factor) {
        StringBuilder sb = new StringBuilder();
        sb.append(factor.getHttpMethod()).append('\n');
        String contentMD5 = factor.getContentMD5();
        if (contentMD5 != null) {
            sb.append(contentMD5).append('\n');
        }
        sb.append(factor.getAccept()).append('\n');
        sb.append(factor.getDate()).append('\n');
        sb.append(SignBuilder.buildCustomHeader(factor.getHeaders()));
        sb.append(factor.getUri()).append('\n');
        sb.append(factor.getRequestParameters());
        return sb.toString();
    }

    static String sign(String accessKeySecret, String stringToSign, String algorithm) throws NoSuchAlgorithmException, InvalidKeyException, UnsupportedEncodingException {
        Mac mac = Mac.getInstance(algorithm);
        mac.init(new SecretKeySpec(accessKeySecret.getBytes(UTF8), algorithm));
        byte[] signData = mac.doFinal(stringToSign.getBytes(UTF8));
        return Base64.getEncoder().encodeToString(signData);
    }

    static String buidAuthorization(String sign) {
        StringBuilder sb = new StringBuilder();
        sb.append(BASIC);
        sb.append(sign);
        return sb.toString();
    }
}

