/*
 * Decompiled with CFR 0.152.
 */
package org.fastquery.httpsign;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.Type;
import java.net.URI;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.TreeMap;
import java.util.UUID;
import javax.ws.rs.client.ClientRequestContext;
import javax.ws.rs.client.ClientRequestFilter;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.UriBuilder;
import org.fastquery.httpsign.AccessAccount;
import org.fastquery.httpsign.Algorithm;
import org.fastquery.httpsign.BinaryUtil;
import org.fastquery.httpsign.Code;
import org.fastquery.httpsign.DateUtil;
import org.fastquery.httpsign.Factor;
import org.fastquery.httpsign.QueryStringParser;
import org.fastquery.httpsign.SignBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AuthAbstractClientRequestFilter
implements ClientRequestFilter,
AccessAccount {
    private static final Logger LOG = LoggerFactory.getLogger(AuthAbstractClientRequestFilter.class);

    private void header(String name, Object value, ClientRequestContext requestContext) {
        MultivaluedMap headers = requestContext.getHeaders();
        if (value == null) {
            headers.remove((Object)name);
        } else {
            headers.remove((Object)name);
            headers.add((Object)name, value);
        }
    }

    public void filter(ClientRequestContext requestContext) throws IOException {
        String sign;
        String contentType;
        MultivaluedMap map = requestContext.getStringHeaders();
        URI uri = requestContext.getUri();
        String nonce = UUID.randomUUID().toString();
        uri = UriBuilder.fromUri((URI)uri).queryParam("nonce", new Object[]{nonce}).build(new Object[0]);
        requestContext.setUri(uri);
        String accessKeyId = new QueryStringParser(uri.getQuery()).get("accessKeyId");
        String accessKeySecret = this.getAccessKeySecret(accessKeyId);
        if (accessKeySecret == null) {
            requestContext.abortWith(Code.E40011.toResponse());
            return;
        }
        String signatureMethod = Algorithm.HMACSHA1.name();
        String rawQueryString = uri.getRawQuery();
        rawQueryString = rawQueryString.replace("+", "%20").replace("*", "%2A").replace("%7E", "~");
        LOG.debug("QueryString\u6309\u7167\u89c4\u8303\u7f16\u7801\u540e:{}", (Object)rawQueryString);
        Object[] ps = rawQueryString.split("\\&");
        Arrays.sort(ps);
        StringBuilder parms = new StringBuilder();
        for (Object p : ps) {
            parms.append('&').append((String)p);
        }
        String requestParameters = parms.substring(1);
        TreeMap<String, String> headerTreeMap = new TreeMap<String, String>();
        map.forEach((name, v) -> {
            String value = (String)v.get(0);
            if (name.toLowerCase().startsWith("x-custom-")) {
                headerTreeMap.put(name.trim(), value.trim());
            }
        });
        String httpMethod = requestContext.getMethod();
        String contentMD5 = requestContext.getHeaderString("Content-MD5");
        if (requestContext.hasEntity() && contentMD5 == null) {
            Type entityType = requestContext.getEntityType();
            if (entityType == String.class) {
                byte[] bytes;
                String body = requestContext.getEntity().toString();
                try {
                    bytes = BinaryUtil.md5(body.getBytes(Charset.forName("UTF-8")));
                }
                catch (NoSuchAlgorithmException e) {
                    LOG.warn(e.getMessage(), (Throwable)e);
                    requestContext.abortWith(Code.E40016.toResponse());
                    return;
                }
                contentMD5 = BinaryUtil.toBase64String(bytes);
            } else if (entityType == File.class) {
                File file = (File)requestContext.getEntity();
                try {
                    contentMD5 = BinaryUtil.toBase64String(BinaryUtil.md5(Files.readAllBytes(file.toPath())));
                }
                catch (NoSuchAlgorithmException e) {
                    LOG.warn(e.getMessage(), (Throwable)e);
                    requestContext.abortWith(Code.E40016.toResponse());
                    return;
                }
            }
        }
        if ((contentType = requestContext.getHeaderString("Accept")) == null) {
            contentType = "application/json";
            this.header("Accept", contentType, requestContext);
        }
        String date = DateUtil.formatRfc822Date();
        String uriPath = uri.getPath();
        Factor factor = new Factor(httpMethod, contentMD5, contentType, date, uriPath, requestParameters, headerTreeMap);
        String stringFactor = SignBuilder.buidStringFactor(factor);
        try {
            sign = SignBuilder.sign(accessKeySecret, stringFactor, signatureMethod);
        }
        catch (InvalidKeyException | NoSuchAlgorithmException e) {
            LOG.warn(e.getMessage(), (Throwable)e);
            requestContext.abortWith(Code.E40017.toResponse());
            return;
        }
        String authorization = SignBuilder.buidAuthorization(sign);
        this.header("Authorization", authorization, requestContext);
        this.header("Content-MD5", contentMD5, requestContext);
        this.header("Date", date, requestContext);
        this.header("User-Agent", "httpsign/1.0", requestContext);
    }
}

