/*
 * Decompiled with CFR 0.152.
 */
package org.fastquery.httpsign;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.text.ParseException;
import java.util.Date;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.SortedMap;
import java.util.TreeMap;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.container.ContainerRequestFilter;
import javax.ws.rs.core.Context;
import org.fastquery.httpsign.AccessAccount;
import org.fastquery.httpsign.Algorithm;
import org.fastquery.httpsign.Code;
import org.fastquery.httpsign.DateUtil;
import org.fastquery.httpsign.Factor;
import org.fastquery.httpsign.RangeTime;
import org.fastquery.httpsign.SignBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AuthAbstractContainerRequestFilter
implements ContainerRequestFilter,
AccessAccount {
    private static final Logger LOG = LoggerFactory.getLogger(AuthAbstractContainerRequestFilter.class);
    @Context
    private HttpServletRequest request;

    private String buildQueryString(SortedMap<String, String> parameters) throws UnsupportedEncodingException {
        Iterator<String> it = parameters.keySet().iterator();
        StringBuilder queryStringTmp = new StringBuilder();
        while (it.hasNext()) {
            String name = it.next();
            queryStringTmp.append("&").append(this.specialUrlEncode(name)).append('=').append(this.specialUrlEncode((String)parameters.get(name)));
        }
        return queryStringTmp.substring(1);
    }

    private String specialUrlEncode(String value) throws UnsupportedEncodingException {
        return URLEncoder.encode(value, "UTF-8").replace("+", "%20").replace("*", "%2A").replace("%7E", "~");
    }

    public void filter(ContainerRequestContext requestContext) throws IOException {
        String nonce = this.request.getParameter("nonce");
        if (nonce == null) {
            requestContext.abortWith(Code.E40008.toResponse());
            return;
        }
        if (RangeTime.exists(nonce)) {
            requestContext.abortWith(Code.E40300.toResponse());
            return;
        }
        String clientAuth = requestContext.getHeaderString("Authorization");
        if (clientAuth == null) {
            requestContext.abortWith(Code.E40000.toResponse());
            return;
        }
        if (clientAuth.length() != 34) {
            requestContext.abortWith(Code.E40001.toResponse());
            return;
        }
        String accept = requestContext.getHeaderString("Accept");
        if (!(accept == null || "application/json".equals(accept) || "application/xml".equals(accept) || "image/*".equals(accept))) {
            requestContext.abortWith(Code.E40002.toResponse());
            return;
        }
        String date = requestContext.getHeaderString("Date");
        if (date == null) {
            requestContext.abortWith(Code.E40003.toResponse());
            return;
        }
        Date clientDate = null;
        try {
            clientDate = DateUtil.parseRfc822Date(date);
        }
        catch (ParseException e) {
            requestContext.abortWith(Code.E40003.toResponse());
            return;
        }
        long current = System.currentTimeMillis();
        if (Math.abs(current - clientDate.getTime()) > 600000L) {
            requestContext.abortWith(Code.E40004.toResponse());
            return;
        }
        RangeTime.add(current, nonce);
        int nonceLen = nonce.length();
        if (nonceLen < 8 || nonceLen > 36) {
            requestContext.abortWith(Code.E40009.toResponse());
            return;
        }
        this.sign(requestContext, clientAuth, accept, date);
    }

    private void sign(ContainerRequestContext requestContext, String clientAuth, String accept, String date) throws UnsupportedEncodingException {
        String sign;
        String accessKeyId = this.request.getParameter("accessKeyId");
        if (accessKeyId == null || accessKeyId.length() < 8 || accessKeyId.length() > 36) {
            requestContext.abortWith(Code.E40010.toResponse());
            return;
        }
        String accessKeySecret = this.getAccessKeySecret(accessKeyId);
        if (accessKeySecret == null) {
            requestContext.abortWith(Code.E40011.toResponse());
            return;
        }
        String signatureMethod = this.request.getParameter("signatureMethod");
        if (signatureMethod != null && !Algorithm.HMACSHA1.name().equals(signatureMethod) && !Algorithm.HMACSHA256.name().equals(signatureMethod)) {
            requestContext.abortWith(Code.E40012.toResponse());
            return;
        }
        if (signatureMethod == null) {
            signatureMethod = "HMACSHA1";
        }
        String httpMethod = requestContext.getMethod();
        String contentMD5 = requestContext.getHeaderString("Content-MD5");
        if (requestContext.getLength() > 0 && contentMD5 == null) {
            requestContext.abortWith(Code.E40015.toResponse());
            return;
        }
        String uriPath = requestContext.getUriInfo().getRequestUri().getPath();
        TreeMap<String, String> parametersMap = new TreeMap<String, String>();
        Enumeration enumeration = this.request.getParameterNames();
        while (enumeration.hasMoreElements()) {
            String name = (String)enumeration.nextElement();
            parametersMap.put(name, this.request.getParameter(name));
        }
        String requestParameters = this.buildQueryString(parametersMap);
        Enumeration enumHeaderNames = this.request.getHeaderNames();
        TreeMap<String, String> headerTreeMap = new TreeMap<String, String>();
        while (enumHeaderNames.hasMoreElements()) {
            String name = (String)enumHeaderNames.nextElement();
            String value = this.request.getHeader(name);
            if (!name.toLowerCase().startsWith("x-custom-")) continue;
            headerTreeMap.put(name, value);
        }
        Factor factor = new Factor(httpMethod, contentMD5, accept, date, uriPath, requestParameters, headerTreeMap);
        String stringFactor = SignBuilder.buidStringFactor(factor);
        try {
            sign = SignBuilder.sign(accessKeySecret, stringFactor, signatureMethod);
        }
        catch (InvalidKeyException | NoSuchAlgorithmException e) {
            LOG.error(e.getMessage(), (Throwable)e);
            requestContext.abortWith(Code.E40017.toResponse());
            return;
        }
        String authorization = SignBuilder.buidAuthorization(sign);
        if (!authorization.equals(clientAuth)) {
            requestContext.abortWith(Code.E40018.toResponse());
        }
    }
}

