/*
 * Decompiled with CFR 0.152.
 */
package fj.test;

import fj.Bottom;
import fj.F;
import fj.Function;
import fj.Monoid;
import fj.Ord;
import fj.P2;
import fj.Unit;
import fj.control.Trampoline;
import fj.data.Array;
import fj.data.List;
import fj.function.Effect1;
import fj.test.Rand;

public final class Gen<A> {
    private final F<Integer, F<Rand, A>> f;

    private Gen(F<Integer, F<Rand, A>> f) {
        this.f = f;
    }

    public A gen(int i, Rand r) {
        return (A)((F)this.f.f((Object)i)).f((Object)r);
    }

    public <B> Gen<B> map(F<A, B> f) {
        return new Gen<A>(i -> r -> f.f(this.gen((int)i, (Rand)r)));
    }

    public Gen<A> filter(F<A, Boolean> f) {
        return Gen.gen(Function.curry((i, r) -> {
            A a;
            while (!((Boolean)f.f(a = this.gen((int)i, (Rand)r))).booleanValue()) {
            }
            return a;
        }));
    }

    public Unit foreach(Integer i, Rand r, F<A, Unit> f) {
        return (Unit)f.f(((F)this.f.f((Object)i)).f((Object)r));
    }

    public void foreachDoEffect(Integer i, Rand r, Effect1<A> f) {
        f.f(((F)this.f.f((Object)i)).f((Object)r));
    }

    public <B> Gen<B> bind(F<A, Gen<B>> f) {
        return new Gen<A>(i -> r -> ((F)((Gen)f.f(this.gen((int)i.intValue(), (Rand)r))).f.f(i)).f(r));
    }

    public <B, C> Gen<C> bind(Gen<B> gb, F<A, F<B, C>> f) {
        return gb.apply(this.map(f));
    }

    public <B, C, D> Gen<D> bind(Gen<B> gb, Gen<C> gc, F<A, F<B, F<C, D>>> f) {
        return gc.apply(this.bind(gb, f));
    }

    public <B, C, D, E> Gen<E> bind(Gen<B> gb, Gen<C> gc, Gen<D> gd, F<A, F<B, F<C, F<D, E>>>> f) {
        return gd.apply(this.bind(gb, gc, f));
    }

    public <B, C, D, E, F$> Gen<F$> bind(Gen<B> gb, Gen<C> gc, Gen<D> gd, Gen<E> ge, F<A, F<B, F<C, F<D, F<E, F$>>>>> f) {
        return ge.apply(this.bind(gb, gc, gd, f));
    }

    public <B, C, D, E, F$, G> Gen<G> bind(Gen<B> gb, Gen<C> gc, Gen<D> gd, Gen<E> ge, Gen<F$> gf, F<A, F<B, F<C, F<D, F<E, F<F$, G>>>>>> f) {
        return gf.apply(this.bind(gb, gc, gd, ge, f));
    }

    public <B, C, D, E, F$, G, H> Gen<H> bind(Gen<B> gb, Gen<C> gc, Gen<D> gd, Gen<E> ge, Gen<F$> gf, Gen<G> gg, F<A, F<B, F<C, F<D, F<E, F<F$, F<G, H>>>>>>> f) {
        return gg.apply(this.bind(gb, gc, gd, ge, gf, f));
    }

    public <B, C, D, E, F$, G, H, I> Gen<I> bind(Gen<B> gb, Gen<C> gc, Gen<D> gd, Gen<E> ge, Gen<F$> gf, Gen<G> gg, Gen<H> gh, F<A, F<B, F<C, F<D, F<E, F<F$, F<G, F<H, I>>>>>>>> f) {
        return gh.apply(this.bind(gb, gc, gd, ge, gf, gg, f));
    }

    public <B> Gen<B> apply(Gen<F<A, B>> gf) {
        return gf.bind(this::map);
    }

    public Gen<A> resize(int s) {
        return new Gen<A>(i -> r -> ((F)this.f.f((Object)s)).f(r));
    }

    public static <A> Gen<A> gen(F<Integer, F<Rand, A>> f) {
        return new Gen<A>(f);
    }

    public static <A> Gen<List<A>> sequence(List<Gen<A>> gs) {
        return Gen.gen(i -> r -> gs.map(g -> g.gen((int)i, (Rand)r)));
    }

    public static <A> Gen<List<A>> sequenceN(int n, Gen<A> g) {
        return Gen.sequence(List.replicate((int)n, g));
    }

    public static <A> Gen<A> parameterised(F<Integer, F<Rand, Gen<A>>> f) {
        return new Gen<A>(Function.curry((i, r) -> ((Gen)((F)f.f(i)).f(r)).gen((int)i, (Rand)r)));
    }

    public static <A> Gen<A> sized(F<Integer, Gen<A>> f) {
        return Gen.parameterised(Function.flip((F)Function.constant(f)));
    }

    public static <A> Gen<A> value(A a) {
        return new Gen<A>(i -> r -> a);
    }

    public static Gen<Integer> choose(int from, int to) {
        int f = Math.min(from, to);
        int t = Math.max(from, to);
        return Gen.parameterised(Function.curry((i, r) -> Gen.value(r.choose(f, t))));
    }

    public static Gen<Long> choose(long from, long to) {
        long f = Math.min(from, to);
        long t = Math.max(from, to);
        return Gen.parameterised(i -> r -> Gen.value(r.choose(f, t)));
    }

    public static Gen<Double> choose(double from, double to) {
        double f = Math.min(from, to);
        double t = Math.max(from, to);
        return Gen.parameterised(i -> r -> Gen.value(r.choose(f, t)));
    }

    public static <A> Gen<A> fail() {
        return new Gen<A>(i -> r -> {
            throw Bottom.error((String)"Failing generator");
        });
    }

    public static <A> Gen<A> join(Gen<Gen<A>> g) {
        return g.bind(Function.identity());
    }

    public static <A> Gen<A> frequency(List<P2<Integer, Gen<A>>> gs) {
        F f = P2.__1();
        return Gen.choose(1, (Integer)Monoid.intAdditionMonoid.sumLeft(gs.map(f))).bind(i -> {
            final class Pick {
                Pick() {
                }

                Gen<A> pick(int n, List<P2<Integer, Gen<A>>> gs) {
                    if (gs.isEmpty()) {
                        return Gen.fail();
                    }
                    int k = (Integer)((P2)gs.head())._1();
                    return n <= k ? (Gen)((P2)gs.head())._2() : this.pick(n - k, gs.tail());
                }
            }
            return new Pick().pick((int)i, gs);
        });
    }

    public static <A> Gen<A> elemFrequency(List<P2<Integer, A>> as) {
        return Gen.frequency(as.map(p -> p.map2(Gen::value)));
    }

    @SafeVarargs
    public static <A> Gen<A> elements(A ... as) {
        return Array.array((Object[])as).isEmpty() ? Gen.fail() : Gen.choose(0, as.length - 1).map(i -> as[i]);
    }

    public static <A> Gen<A> oneOf(List<Gen<A>> gs) {
        return gs.isEmpty() ? Gen.fail() : Gen.choose(0, gs.length() - 1).bind(arg_0 -> gs.index(arg_0));
    }

    public static <A> Gen<List<A>> listOf(Gen<A> g, int x) {
        return Gen.sized(size -> Gen.choose(x, Math.max(x, size)).bind(n -> Gen.sequenceN(n, g)));
    }

    public static <A> Gen<List<A>> listOfSorted(Gen<A> g, int x, Ord<A> ord) {
        return Gen.listOf(g, x).map(l -> l.sort(ord));
    }

    public static <A> Gen<List<A>> listOf(Gen<A> g) {
        return Gen.listOf(g, 0);
    }

    public static <A> Gen<List<A>> listOf1(Gen<A> g) {
        return Gen.listOf(g, 1);
    }

    public static <A> Gen<A> pickOne(List<A> as) {
        return Gen.wordOf(1, as).map(List::head);
    }

    @Deprecated
    public static <A> Gen<List<A>> pick(int n, List<A> as) {
        return Gen.combinationOf(n, as);
    }

    public static <A> Gen<List<A>> combinationOf(int n, List<A> as) {
        int aLength = as.length();
        return n >= 0 && n <= aLength ? Gen.parameterised(s -> r -> {
            final class Tramp {
                final /* synthetic */ Rand val$r;

                Tramp(Rand rand) {
                    this.val$r = rand;
                }

                private Trampoline<List<A>> tramp(List<A> remainAs, int remainN, int remainALength) {
                    return Trampoline.suspend(() -> remainN == 0 ? Trampoline.pure((Object)List.nil()) : (this.val$r.choose(0, remainALength - 1) < remainN ? this.tramp(remainAs.tail(), remainN - 1, remainALength - 1).map(pickedTail -> List.cons((Object)remainAs.head(), (List)pickedTail)) : this.tramp(remainAs.tail(), remainN, remainALength - 1)));
                }
            }
            return Gen.value(new Tramp((Rand)r).tramp(as, n, aLength).run());
        }) : Gen.fail();
    }

    public static <A> Gen<List<A>> selectionOf(int n, List<A> as) {
        Array aArr = as.toArray();
        return n >= 0 ? Gen.pick(Gen.indexWord(n, aArr.length()).map(indexes -> indexes.sort(Ord.intOrd)), aArr) : Gen.fail();
    }

    public static <A> Gen<List<A>> permutationOf(int n, List<A> as) {
        return Gen.parameterised(s -> r -> Gen.combinationOf(n, as).map(combination -> {
            Array aArr = combination.toArray();
            int length = aArr.length();
            for (int i = length - 1; i > 0; --i) {
                int j = r.choose(0, i);
                Object tmp = aArr.get(i);
                aArr.set(i, aArr.get(j));
                aArr.set(j, tmp);
            }
            return aArr.toList();
        }));
    }

    public static <A> Gen<List<A>> wordOf(int n, List<A> as) {
        Array aArr = as.toArray();
        return n >= 0 ? Gen.pick(Gen.indexWord(n, aArr.length()), aArr) : Gen.fail();
    }

    private static Gen<List<Integer>> indexWord(int n, int m) {
        return Gen.sequenceN(n, Gen.choose(0, m - 1));
    }

    private static <A> Gen<List<A>> pick(Gen<List<Integer>> indexesGen, Array<A> as) {
        return indexesGen.map(indexes -> ((List)indexes.foldLeft((acc, index) -> List.cons((Object)as.get(index.intValue()), (List)acc), (Object)List.nil())).reverse());
    }

    @Deprecated
    public static <A> Gen<List<A>> someOf(List<A> as) {
        return Gen.someCombinationOf(as);
    }

    public static <A> Gen<List<A>> someCombinationOf(List<A> as) {
        return Gen.choose(0, as.length()).bind(n -> Gen.combinationOf(n, as));
    }

    public static <A> Gen<List<A>> someSelectionOf(int maxLength, List<A> as) {
        return Gen.choose(0, maxLength).bind(n -> Gen.selectionOf(n, as));
    }

    public static <A> Gen<List<A>> somePermutationOf(List<A> as) {
        return Gen.choose(0, as.length()).bind(n -> Gen.permutationOf(n, as));
    }

    public static <A> Gen<List<A>> someWordOf(int maxLength, List<A> as) {
        return Gen.choose(0, maxLength).bind(n -> Gen.wordOf(n, as));
    }

    public static <A, B> Gen<F<A, B>> promote(F<A, Gen<B>> f) {
        return new Gen<F<A, B>>(i -> r -> a -> ((F)((Gen)f.f((Object)a)).f.f(i)).f(r));
    }
}

