/*
 * Decompiled with CFR 0.152.
 */
package fj.data;

import fj.Equal;
import fj.F;
import fj.Function;
import fj.Hash;
import fj.Monoid;
import fj.Ord;
import fj.Ordering;
import fj.P;
import fj.P2;
import fj.P3;
import fj.Show;
import fj.data.Array;
import fj.data.Either;
import fj.data.List;
import fj.data.Option;
import fj.data.Stream;
import fj.function.Booleans;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.TreeSet;

public abstract class Set<A>
implements Iterable<A> {
    private final Ord<A> ord;

    private Set(Ord<A> ord) {
        this.ord = ord;
    }

    public final boolean isEmpty() {
        return this instanceof Empty;
    }

    abstract Color color();

    abstract Set<A> l();

    abstract A head();

    abstract Set<A> r();

    public final Ord<A> ord() {
        return this.ord;
    }

    public final P2<Boolean, Set<A>> update(A a, F<A, A> f) {
        return this.isEmpty() ? P.p(false, this) : this.tryUpdate(a, f).either(a2 -> P.p(true, this.delete(a).insert(a2)), Function.identity());
    }

    private Either<A, P2<Boolean, Set<A>>> tryUpdate(A a, F<A, A> f) {
        if (this.isEmpty()) {
            return Either.right(P.p(false, this));
        }
        if (this.ord.isLessThan(a, this.head())) {
            return super.tryUpdate(a, f).right().map(set -> (Boolean)set._1() != false ? P.p(true, new Tree(this.ord, this.color(), (Set)set._2(), this.head(), this.r())) : set);
        }
        if (this.ord.eq(a, this.head())) {
            A h = f.f(this.head());
            return this.ord.eq(this.head(), h) ? Either.right(P.p(true, new Tree(this.ord, this.color(), this.l(), h, this.r()))) : Either.left(h);
        }
        return super.tryUpdate(a, f).right().map(set -> (Boolean)set._1() != false ? P.p(true, new Tree(this.ord, this.color(), this.l(), this.head(), (Set)set._2())) : set);
    }

    public static <A> Set<A> empty(Ord<A> ord) {
        return new Empty(ord);
    }

    public final boolean equals(Object other) {
        return Equal.equals0(Set.class, this, other, () -> Equal.setEqual(Equal.anyEqual()));
    }

    public final int hashCode() {
        return Hash.setHash(Hash.anyHash()).hash(this);
    }

    public final String toString() {
        return Show.setShow(Show.anyShow()).showS(this);
    }

    public final boolean member(A x) {
        return !this.isEmpty() && (this.ord.isLessThan(x, this.head()) ? this.l().member(x) : this.ord.eq(this.head(), x) || this.r().member(x));
    }

    public static <A> F<Set<A>, F<A, Boolean>> member() {
        return Function.curry(Set::member);
    }

    public final Set<A> insert(A x) {
        return super.makeBlack();
    }

    public static <A> F<A, F<Set<A>, Set<A>>> insert() {
        return Function.curry((a, set) -> set.insert(a));
    }

    private Set<A> ins(A x) {
        return this.isEmpty() ? new Tree(this.ord, Color.R, Set.empty(this.ord), x, Set.empty(this.ord)) : (this.ord.isLessThan(x, this.head()) ? Set.balance(this.ord, this.color(), super.ins(x), this.head(), this.r()) : (this.ord.eq(x, this.head()) ? new Tree(this.ord, this.color(), this.l(), x, this.r()) : Set.balance(this.ord, this.color(), this.l(), this.head(), super.ins(x))));
    }

    private Set<A> makeBlack() {
        return new Tree(this.ord, Color.B, this.l(), this.head(), this.r());
    }

    private static <A> Tree<A> tr(Ord<A> o, Set<A> a, A x, Set<A> b, A y, Set<A> c, A z, Set<A> d) {
        return new Tree(o, Color.R, new Tree(o, Color.B, a, x, b), y, new Tree(o, Color.B, c, z, d));
    }

    private static <A> Set<A> balance(Ord<A> ord, Color c, Set<A> l, A h, Set<A> r) {
        return c == Color.B && super.isTR() && super.isTR() ? Set.tr(ord, l.l().l(), l.l().head(), l.l().r(), l.head(), l.r(), h, r) : (c == Color.B && super.isTR() && super.isTR() ? Set.tr(ord, l.l(), l.head(), l.r().l(), l.r().head(), l.r().r(), h, r) : (c == Color.B && super.isTR() && super.isTR() ? Set.tr(ord, l, h, r.l().l(), r.l().head(), r.l().r(), r.head(), r.r()) : (c == Color.B && super.isTR() && super.isTR() ? Set.tr(ord, l, h, r.l(), r.head(), r.r().l(), r.r().head(), r.r().r()) : new Tree(ord, c, l, h, r))));
    }

    private boolean isTR() {
        return !this.isEmpty() && this.color() == Color.R;
    }

    @Override
    public final Iterator<A> iterator() {
        return this.toStream().iterator();
    }

    public static <A> Set<A> single(Ord<A> o, A a) {
        return Set.empty(o).insert(a);
    }

    public final <B> Set<B> map(Ord<B> o, F<A, B> f) {
        return Set.iterableSet(o, this.toStream().map(f));
    }

    public final <B> B foldMap(F<A, B> f, Monoid<B> m) {
        return this.isEmpty() ? m.zero() : m.sum(m.sum(this.l().foldMap(f, m), f.f(this.head())), this.r().foldMap(f, m));
    }

    public final <B> B foldMapRight(F<A, B> f, Monoid<B> m) {
        return this.isEmpty() ? m.zero() : m.sum(m.sum(this.r().foldMapRight(f, m), f.f(this.head())), this.l().foldMapRight(f, m));
    }

    public final List<A> toList() {
        return this.foldMap(List.cons(List.nil()), Monoid.listMonoid());
    }

    public final java.util.Set<A> toJavaSet() {
        return this.toJavaHashSet();
    }

    public final HashSet<A> toJavaHashSet() {
        return new HashSet<A>(this.toStream().toCollection());
    }

    public final TreeSet<A> toJavaTreeSet() {
        return new TreeSet<A>(this.toStream().toCollection());
    }

    public final java.util.List<A> toJavaList() {
        return new ArrayList<A>(this.toStream().toCollection());
    }

    public final List<A> toListReverse() {
        return this.foldMapRight(List.cons(List.nil()), Monoid.listMonoid());
    }

    public final Stream<A> toStream() {
        if (this.isEmpty()) {
            return Stream.nil();
        }
        if (this.l().isEmpty()) {
            return Stream.cons(this.head(), () -> this.r().toStream());
        }
        return this.l().toStream().append(Stream.cons(this.head(), () -> this.r().toStream()));
    }

    public final Stream<A> toStreamReverse() {
        if (this.isEmpty()) {
            return Stream.nil();
        }
        if (this.r().isEmpty()) {
            return Stream.cons(this.head(), () -> this.l().toStreamReverse());
        }
        return this.r().toStreamReverse().append(Stream.cons(this.head(), () -> this.l().toStreamReverse()));
    }

    public final <B> Set<B> bind(Ord<B> o, F<A, Set<B>> f) {
        return Set.join(o, this.map(Ord.setOrd(o), f));
    }

    public final Set<A> union(Set<A> s) {
        return Set.iterableSet(this.ord, s.toStream().append(this.toStream()));
    }

    public static <A> F<Set<A>, F<Set<A>, Set<A>>> union() {
        return Function.curry(Set::union);
    }

    public final Set<A> filter(F<A, Boolean> f) {
        return Set.iterableSet(this.ord, this.toStream().filter(f));
    }

    public final Set<A> delete(A a) {
        return this.minus(Set.single(this.ord, a));
    }

    public final F<A, F<Set<A>, Set<A>>> delete() {
        return Function.curry((a, set) -> set.delete(a));
    }

    public final Set<A> intersect(Set<A> s) {
        return this.filter(Set.member().f(s));
    }

    public static <A> F<Set<A>, F<Set<A>, Set<A>>> intersect() {
        return Function.curry(Set::intersect);
    }

    public final Set<A> minus(Set<A> s) {
        return this.filter(Function.compose(Booleans.not, Set.member().f(s)));
    }

    public static <A> F<Set<A>, F<Set<A>, Set<A>>> minus() {
        return Function.curry(Set::minus);
    }

    public final Option<A> min() {
        return this.isEmpty() ? Option.none() : this.l().min().orElse(Option.some(this.head()));
    }

    public final Option<A> max() {
        return this.isEmpty() ? Option.none() : this.r().max().orElse(Option.some(this.head()));
    }

    public final int size() {
        F one = Function.constant(1);
        return this.foldMap(one, Monoid.intAdditionMonoid);
    }

    public final P3<Set<A>, Option<A>, Set<A>> split(A a) {
        if (this.isEmpty()) {
            return P.p(Set.empty(this.ord), Option.none(), Set.empty(this.ord));
        }
        A h = this.head();
        Ordering i = this.ord.compare(a, h);
        if (i == Ordering.LT) {
            P3<Set<A>, Option<A>, Set<A>> lg = this.l().split(a);
            return P.p(lg._1(), lg._2(), lg._3().insert(h).union(this.r()));
        }
        if (i == Ordering.GT) {
            P3<Set<A>, Option<A>, Set<A>> lg = this.r().split(a);
            return P.p(lg._1().insert(h).union(this.l()), lg._2(), lg._3());
        }
        return P.p(this.l(), Option.some(h), this.r());
    }

    public final Option<A> lookup(A a) {
        A h;
        Set<A> s = this;
        while (true) {
            if (s.isEmpty()) {
                return Option.none();
            }
            h = s.head();
            Ordering i = this.ord.compare(a, h);
            if (i == Ordering.LT) {
                s = s.l();
                continue;
            }
            if (i != Ordering.GT) break;
            s = s.r();
        }
        return Option.some(h);
    }

    public final Option<A> lookupLT(A a) {
        Set<A> s = this;
        Option<Object> r = Option.none();
        while (!s.isEmpty()) {
            A h = s.head();
            Ordering i = this.ord.compare(a, h);
            if (i == Ordering.GT) {
                r = Option.some(h);
                s = s.r();
                continue;
            }
            s = s.l();
        }
        return r;
    }

    public final Option<A> lookupGT(A a) {
        Set<A> s = this;
        Option<Object> r = Option.none();
        while (!s.isEmpty()) {
            A h = s.head();
            Ordering i = this.ord.compare(a, h);
            if (i == Ordering.LT) {
                r = Option.some(h);
                s = s.l();
                continue;
            }
            s = s.r();
        }
        return r;
    }

    public final Option<A> lookupLE(A a) {
        A h;
        Set<A> s = this;
        Option<Object> r = Option.none();
        while (true) {
            if (s.isEmpty()) {
                return r;
            }
            h = s.head();
            Ordering i = this.ord.compare(a, h);
            if (i == Ordering.LT) {
                s = s.l();
                continue;
            }
            if (i != Ordering.GT) break;
            r = Option.some(h);
            s = s.r();
        }
        return Option.some(h);
    }

    public final Option<A> lookupGE(A a) {
        A h;
        Set<A> s = this;
        Option<Object> r = Option.none();
        while (true) {
            if (s.isEmpty()) {
                return r;
            }
            h = s.head();
            Ordering i = this.ord.compare(a, h);
            if (i == Ordering.LT) {
                r = Option.some(h);
                s = s.l();
                continue;
            }
            if (i != Ordering.GT) break;
            s = s.r();
        }
        return Option.some(h);
    }

    public final boolean subsetOf(Set<A> s) {
        if (this.isEmpty() || s.isEmpty()) {
            return this.isEmpty();
        }
        P3<Set<A>, Option<A>, Set<A>> find = s.split(this.head());
        return find._2().isSome() && this.l().subsetOf(find._1()) && this.r().subsetOf(find._3());
    }

    public static <A> Set<A> join(Ord<A> o, Set<Set<A>> s) {
        F id = Function.identity();
        return s.foldMap(id, Monoid.setMonoid(o));
    }

    public static <A> Set<A> iterableSet(Ord<A> o, Iterable<A> as) {
        Set<A> s = Set.empty(o);
        for (A a : as) {
            s = s.insert(a);
        }
        return s;
    }

    public static <A> Set<A> iteratorSet(Ord<A> o, Iterator<A> as) {
        return Set.iterableSet(o, () -> as);
    }

    @SafeVarargs
    public static <A> Set<A> arraySet(Ord<A> o, A ... as) {
        return Set.iterableSet(o, Array.array(as));
    }

    @SafeVarargs
    public static <A> Set<A> set(Ord<A> o, A ... as) {
        return Set.arraySet(o, as);
    }

    @Deprecated
    public static <A> Set<A> set(Ord<A> o, List<A> list) {
        return Set.iterableSet(o, list);
    }

    @Deprecated
    public static <A> Set<A> fromList(Ord<A> o, List<A> list) {
        return Set.iterableSet(o, list);
    }

    private static final class Tree<A>
    extends Set<A> {
        private final Color c;
        private final Set<A> a;
        private final A x;
        private final Set<A> b;

        private Tree(Ord<A> ord, Color c, Set<A> a, A x, Set<A> b) {
            super(ord);
            this.c = c;
            this.a = a;
            this.x = x;
            this.b = b;
        }

        @Override
        public Color color() {
            return this.c;
        }

        @Override
        public Set<A> l() {
            return this.a;
        }

        @Override
        public A head() {
            return this.x;
        }

        @Override
        public Set<A> r() {
            return this.b;
        }
    }

    private static final class Empty<A>
    extends Set<A> {
        private Empty(Ord<A> ord) {
            super(ord);
        }

        @Override
        public Color color() {
            return Color.B;
        }

        @Override
        public Set<A> l() {
            throw new Error("Left on empty set.");
        }

        @Override
        public Set<A> r() {
            throw new Error("Right on empty set.");
        }

        @Override
        public A head() {
            throw new Error("Head on empty set.");
        }
    }

    private static enum Color {
        R,
        B;

    }
}

