/*
 * Decompiled with CFR 0.152.
 */
package fj.data.hamt;

import fj.Equal;
import fj.F2;
import fj.Monoid;
import fj.Show;
import fj.data.List;
import fj.data.Stream;

public final class BitSet {
    public static final int TRUE_BIT = 1;
    public static final int FALSE_BIT = 0;
    public static final BitSet EMPTY = new BitSet(0L);
    public static final long BASE_LONG = 1L;
    public static final int MAX_BIT_SIZE = 64;
    public static final int MAX_BIT_INDEX = 63;
    private final long value;

    private BitSet(long l) {
        this.value = l;
    }

    public static BitSet empty() {
        return EMPTY;
    }

    public static BitSet longBitSet(long l) {
        return new BitSet(l);
    }

    public static BitSet listBitSet(List<Boolean> list) {
        int n = list.length();
        if (n > 64) {
            throw new IllegalArgumentException("Does not support lists greater than 64 bits, actual size is " + n);
        }
        long result = 0L;
        for (Boolean b : list) {
            result = result << 1 | (long)BitSet.toInt(b);
        }
        return BitSet.longBitSet(result);
    }

    public static BitSet streamBitSet(Stream<Boolean> s) {
        return BitSet.listBitSet(s.toList());
    }

    public static BitSet stringBitSet(String s) {
        return BitSet.streamBitSet(Stream.fromString(s).map(BitSet::toBoolean));
    }

    public boolean isSet(int index) {
        return (this.value & 1L << index) != 0L;
    }

    public boolean isEmpty() {
        return this.value == 0L;
    }

    public BitSet set(int index) {
        return BitSet.longBitSet(this.value | 1L << index);
    }

    public BitSet set(int index, boolean b) {
        return b ? this.set(index) : this.clear(index);
    }

    public BitSet clear(int index) {
        return BitSet.longBitSet(this.value & (1L << index ^ 0xFFFFFFFFFFFFFFFFL));
    }

    public long longValue() {
        return this.value;
    }

    public BitSet and(BitSet bs) {
        return BitSet.longBitSet(this.value & bs.longValue());
    }

    public BitSet or(BitSet bs) {
        return BitSet.longBitSet(this.value | bs.longValue());
    }

    public BitSet shiftRight(int n) {
        return BitSet.longBitSet(this.value >> n);
    }

    public BitSet shiftLeft(int n) {
        return BitSet.longBitSet(this.value << n);
    }

    public int bitsUsed() {
        return this.toStream().length();
    }

    public int bitsOn() {
        return this.toStream().foldLeft((B acc, A b) -> acc + (b != false ? 1 : 0), Integer.valueOf(0));
    }

    public Stream<Boolean> toStream() {
        return Stream.fromString(Long.toBinaryString(this.value)).map(BitSet::toBoolean).dropWhile(b -> b == false);
    }

    public String toString() {
        return Show.bitSetShow.showS(this);
    }

    public boolean equals(Object obj) {
        return Equal.equals0(BitSet.class, this, obj, Equal.bitSetSequal);
    }

    public int bitsToRight(int index) {
        int pos;
        if (index >= 64) {
            throw new IllegalArgumentException("Does not support an index greater than or equal to 64 bits, actual argument is " + index);
        }
        long mask = 1L << pos;
        int result = 0;
        for (pos = index - 1; pos >= 0; --pos) {
            if ((mask & this.value) != 0L) {
                ++result;
            }
            mask >>= 1;
        }
        return result;
    }

    public List<Boolean> toList() {
        return this.toStream().toList();
    }

    public <A> A foldRight(F2<Boolean, A, A> f, A acc) {
        return this.toStream().foldRight((A b) -> p -> f.f((Boolean)b, p._1()), acc);
    }

    public <A> A foldLeft(F2<A, Boolean, A> f, A acc) {
        return this.toStream().foldLeft(f, acc);
    }

    public BitSet xor(BitSet bs) {
        return BitSet.longBitSet(this.value ^ bs.longValue());
    }

    public BitSet not() {
        return BitSet.longBitSet(this.value ^ 0xFFFFFFFFFFFFFFFFL);
    }

    public BitSet takeLower(int n) {
        return BitSet.streamBitSet(this.toStream().reverse().take(n).reverse());
    }

    public BitSet takeUpper(int n) {
        String zero = Integer.toString(0);
        String current = this.asString();
        String pad = Monoid.stringMonoid.sumLeft(List.replicate(64 - current.length(), zero));
        return BitSet.stringBitSet(pad + current.substring(0, Math.max(n - pad.length(), 0)));
    }

    public BitSet range(int highIndex, int lowIndex) {
        int min;
        int max = Math.max(lowIndex, highIndex);
        return new BitSet(max == (min = Math.min(lowIndex, highIndex)) ? 0L : this.value << 64 - max >>> 64 - max + min);
    }

    public static boolean toBoolean(char c) {
        return c != '0';
    }

    public static boolean toBoolean(int i) {
        return i != 0;
    }

    public static int toInt(boolean b) {
        return b ? 1 : 0;
    }

    public String asString() {
        return Long.toBinaryString(this.value);
    }
}

