/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.graphchi;

import edu.cmu.graphchi.datablocks.BytesToValueConverter;
import edu.cmu.graphchi.engine.VertexInterval;
import edu.cmu.graphchi.io.CompressedIO;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.lang.management.RuntimeMXBean;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import sun.management.VMManagement;

public class ChiFilenames {
    public static String vertexDataSuffix = "";

    public static String getFilenameOfVertexData(String string, BytesToValueConverter bytesToValueConverter, boolean bl) {
        return string + "." + bytesToValueConverter.sizeOf() + "Bj.vout" + vertexDataSuffix + (bl ? ".sparse" : "");
    }

    public static String getFilenameOfDegreeData(String string, boolean bl) {
        return string + "_degsj.bin" + (bl ? ".sparse" : "");
    }

    public static String getPartStr(int n, int n2) {
        return "." + n + "_" + n2;
    }

    public static String getDirnameShardEdataBlock(String string, int n) {
        if (CompressedIO.isCompressionEnabled()) {
            string = string + ".Z.";
        }
        return string + "_blockdir_" + n;
    }

    public static String getFilenameShardEdataBlock(String string, int n, int n2) {
        return ChiFilenames.getDirnameShardEdataBlock(string, n2) + "/" + n;
    }

    public static int getShardEdataSize(String string) throws IOException {
        String string2 = string + ".size";
        BufferedReader bufferedReader = new BufferedReader(new FileReader(new File(string2)));
        String string3 = bufferedReader.readLine();
        bufferedReader.close();
        return Integer.parseInt(string3);
    }

    public static String getFilenameShardEdata(String string, BytesToValueConverter bytesToValueConverter, int n, int n2) {
        return string + ".edata_java.e" + bytesToValueConverter.sizeOf() + "B." + n + "_" + n2;
    }

    public static String getFilenameShardsAdj(String string, int n, int n2) {
        return string + ".edata_java." + n + "_" + n2 + ".adj";
    }

    public static String getFilenameIntervals(String string, int n) {
        return string + "." + n + ".intervalsjava";
    }

    public static String getVertexTranslateDefFile(String string, int n) {
        return string + "." + n + ".vtranslate";
    }

    public static int getBlocksize(int n) {
        int n2 = 0x400000;
        while (n2 % n != 0) {
            ++n2;
        }
        assert (n2 % n == 0);
        return n2;
    }

    public static int getPid() {
        try {
            RuntimeMXBean runtimeMXBean = ManagementFactory.getRuntimeMXBean();
            Field field = runtimeMXBean.getClass().getDeclaredField("jvm");
            field.setAccessible(true);
            VMManagement vMManagement = (VMManagement)field.get(runtimeMXBean);
            Method method = vMManagement.getClass().getDeclaredMethod("getProcessId", new Class[0]);
            method.setAccessible(true);
            return (Integer)method.invoke((Object)vMManagement, new Object[0]);
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    public static ArrayList<VertexInterval> loadIntervals(String string, int n) throws FileNotFoundException, IOException {
        String string2;
        String string3 = ChiFilenames.getFilenameIntervals(string, n);
        BufferedReader bufferedReader = new BufferedReader(new FileReader(new File(string3)));
        int n2 = 0;
        ArrayList<VertexInterval> arrayList = new ArrayList<VertexInterval>(n);
        while ((string2 = bufferedReader.readLine()) != null) {
            int n3 = Integer.parseInt(string2);
            arrayList.add(new VertexInterval(n2, n3));
            n2 = n3 + 1;
        }
        return arrayList;
    }

    public static int numVertices(String string, int n) throws IOException {
        ArrayList<VertexInterval> arrayList = ChiFilenames.loadIntervals(string, n);
        return arrayList.get(arrayList.size() - 1).getLastVertex() + 1;
    }
}

