/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.graphchi;

import java.io.File;
import java.io.FileInputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.text.FieldPosition;
import java.text.MessageFormat;
import java.util.Date;
import java.util.logging.ConsoleHandler;
import java.util.logging.Formatter;
import java.util.logging.LogManager;
import java.util.logging.LogRecord;
import java.util.logging.Logger;

public class ChiLogger {
    public static void init() {
        try {
            File file = new File("conf/logging.properties");
            if (file.exists()) {
                LogManager.getLogManager().readConfiguration(new FileInputStream(file.getAbsolutePath()));
            } else {
                System.err.println("Could not find cond/logging.properties!");
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public static Logger getLogger(String string) {
        Logger logger = Logger.getLogger(string);
        if (logger.getHandlers().length == 0) {
            ConsoleHandler consoleHandler = new ConsoleHandler();
            consoleHandler.setFormatter(new SingleLineFormatter());
            logger.setUseParentHandlers(false);
            logger.addHandler(consoleHandler);
        }
        return logger;
    }

    public static class SingleLineFormatter
    extends Formatter {
        Date dat = new Date();
        private static final String format = "{0,time}";
        private MessageFormat formatter;
        private Object[] args = new Object[1];
        private String lineSeparator = "\n";

        @Override
        public synchronized String format(LogRecord logRecord) {
            StringBuilder stringBuilder = new StringBuilder();
            this.dat.setTime(logRecord.getMillis());
            this.args[0] = this.dat;
            StringBuffer stringBuffer = new StringBuffer();
            if (this.formatter == null) {
                this.formatter = new MessageFormat(format);
            }
            this.formatter.format(this.args, stringBuffer, (FieldPosition)null);
            stringBuilder.append(stringBuffer);
            stringBuilder.append(" ");
            stringBuilder.append(logRecord.getLoggerName());
            if (logRecord.getSourceMethodName() != null) {
                stringBuilder.append(" ");
                stringBuilder.append(logRecord.getSourceMethodName());
            }
            stringBuilder.append(" - t:");
            stringBuilder.append(Thread.currentThread().getId());
            stringBuilder.append(" ");
            String string = this.formatMessage(logRecord);
            stringBuilder.append(logRecord.getLevel().getLocalizedName());
            stringBuilder.append(": ");
            int n = (1000 - logRecord.getLevel().intValue()) / 100;
            for (int i = 0; i < n; ++i) {
                stringBuilder.append(" ");
            }
            stringBuilder.append(string);
            stringBuilder.append(this.lineSeparator);
            if (logRecord.getThrown() != null) {
                try {
                    StringWriter stringWriter = new StringWriter();
                    PrintWriter printWriter = new PrintWriter(stringWriter);
                    logRecord.getThrown().printStackTrace(printWriter);
                    printWriter.close();
                    stringBuilder.append(stringWriter.toString());
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return stringBuilder.toString();
        }
    }
}

