/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.graphchi;

import edu.cmu.graphchi.ChiEdge;
import edu.cmu.graphchi.datablocks.BytesToValueConverter;
import edu.cmu.graphchi.datablocks.ChiPointer;
import edu.cmu.graphchi.datablocks.DataBlockManager;
import edu.cmu.graphchi.engine.auxdata.VertexDegree;
import java.lang.reflect.Field;
import sun.misc.Unsafe;

public class ChiVertex<VertexValue, EdgeValue> {
    private int id;
    public static DataBlockManager blockManager;
    public static BytesToValueConverter vertexValueConverter;
    public static BytesToValueConverter edgeValueConverter;
    public static boolean disableInedges;
    public static boolean disableOutedges;
    private volatile int nInedges = 0;
    private int[] inEdgeDataArray = null;
    private volatile int nOutedges = 0;
    private int[] outEdgeDataArray = null;
    public boolean parallelSafe = true;
    private static final Unsafe unsafe;
    private static final long valueOffset_nInedges;
    private static final long valueOffset_nOutedges;
    private ChiPointer vertexPtr;

    private static Unsafe getUnsafe() {
        try {
            Field field = Unsafe.class.getDeclaredField("theUnsafe");
            field.setAccessible(true);
            return (Unsafe)field.get(null);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw illegalArgumentException;
        }
        catch (SecurityException securityException) {
            throw securityException;
        }
        catch (NoSuchFieldException noSuchFieldException) {
            throw new RuntimeException(noSuchFieldException);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new RuntimeException(illegalAccessException);
        }
    }

    public ChiVertex(int n, VertexDegree vertexDegree) {
        this.id = n;
        if (vertexDegree != null) {
            if (!disableInedges) {
                this.inEdgeDataArray = new int[vertexDegree.inDegree * (edgeValueConverter != null ? 3 : 1)];
            } else {
                this.nInedges = vertexDegree.inDegree;
            }
            if (!disableOutedges) {
                this.outEdgeDataArray = new int[vertexDegree.outDegree * (edgeValueConverter != null ? 3 : 1)];
            } else {
                this.nOutedges = vertexDegree.outDegree;
            }
        }
    }

    public int getId() {
        return this.id;
    }

    public void setDataPtr(ChiPointer chiPointer) {
        this.vertexPtr = chiPointer;
    }

    public VertexValue getValue() {
        return (VertexValue)blockManager.dereference(this.vertexPtr, vertexValueConverter);
    }

    public void setValue(VertexValue VertexValue) {
        blockManager.writeValue(this.vertexPtr, vertexValueConverter, VertexValue);
    }

    public int getRandomOutNeighbor() {
        int n = (int)(Math.random() * (double)this.numOutEdges());
        if (edgeValueConverter != null) {
            int n2 = n * 3;
            return this.outEdgeDataArray[n2 + 2];
        }
        return this.outEdgeDataArray[n];
    }

    public int getRandomNeighbor() {
        if (this.numEdges() == 0) {
            return -1;
        }
        int n = (int)(Math.random() * (double)this.numEdges());
        return this.edge(n).getVertexId();
    }

    public int numOutEdges() {
        return this.nOutedges;
    }

    public int numInEdges() {
        return this.nInedges;
    }

    public void addInEdge(int n, int n2, int n3) {
        int n4;
        int n5;
        while (!unsafe.compareAndSwapInt(this, valueOffset_nInedges, n5 = this.nInedges, n4 = n5 + 1)) {
        }
        --n4;
        if (edgeValueConverter != null) {
            n5 = n4 * 3;
            this.inEdgeDataArray[n5] = n;
            this.inEdgeDataArray[n5 + 1] = n2;
            this.inEdgeDataArray[n5 + 2] = n3;
        } else if (this.inEdgeDataArray != null) {
            this.inEdgeDataArray[n4] = n3;
        }
    }

    public void addOutEdge(int n, int n2, int n3) {
        int n4;
        int n5;
        while (!unsafe.compareAndSwapInt(this, valueOffset_nOutedges, n5 = this.nOutedges, n4 = n5 + 1)) {
        }
        --n4;
        if (edgeValueConverter != null) {
            n5 = n4 * 3;
            this.outEdgeDataArray[n5] = n;
            this.outEdgeDataArray[n5 + 1] = n2;
            this.outEdgeDataArray[n5 + 2] = n3;
        } else if (this.outEdgeDataArray != null) {
            this.outEdgeDataArray[n4] = n3;
        }
    }

    public ChiEdge<EdgeValue> inEdge(int n) {
        if (edgeValueConverter != null) {
            int n2 = n * 3;
            return new Edge(new ChiPointer(this.inEdgeDataArray[n2], this.inEdgeDataArray[n2 + 1]), this.inEdgeDataArray[n2 + 2]);
        }
        return new Edge(null, this.inEdgeDataArray[n]);
    }

    public ChiEdge<EdgeValue> outEdge(int n) {
        if (edgeValueConverter != null) {
            int n2 = n * 3;
            return new Edge(new ChiPointer(this.outEdgeDataArray[n2], this.outEdgeDataArray[n2 + 1]), this.outEdgeDataArray[n2 + 2]);
        }
        return new Edge(null, this.outEdgeDataArray[n]);
    }

    public int getOutEdgeId(int n) {
        if (edgeValueConverter != null) {
            int n2 = n * 3;
            return this.outEdgeDataArray[n2 + 2];
        }
        return this.outEdgeDataArray[n];
    }

    public ChiEdge<EdgeValue> edge(int n) {
        if (n < this.nInedges) {
            return this.inEdge(n);
        }
        return this.outEdge(n - this.nInedges);
    }

    public int numEdges() {
        return this.nInedges + this.nOutedges;
    }

    public int[] getOutNeighborArray() {
        if (edgeValueConverter != null) {
            int[] nArray = new int[this.numOutEdges()];
            for (int i = 0; i < nArray.length; ++i) {
                nArray[i] = this.outEdgeDataArray[i * 3 + 2];
            }
            return nArray;
        }
        return (int[])this.outEdgeDataArray.clone();
    }

    public EdgeValue getOutEdgeValue(int n) {
        int n2 = n * 3;
        return (EdgeValue)blockManager.dereference(new ChiPointer(this.outEdgeDataArray[n2], this.outEdgeDataArray[n2 + 1]), edgeValueConverter);
    }

    static {
        disableInedges = false;
        disableOutedges = false;
        unsafe = ChiVertex.getUnsafe();
        try {
            valueOffset_nInedges = unsafe.objectFieldOffset(ChiVertex.class.getDeclaredField("nInedges"));
            valueOffset_nOutedges = unsafe.objectFieldOffset(ChiVertex.class.getDeclaredField("nOutedges"));
        }
        catch (Exception exception) {
            throw new Error(exception);
        }
    }

    class Edge
    implements ChiEdge<EdgeValue> {
        ChiPointer dataPtr;
        int vertexId;

        Edge(ChiPointer chiPointer, int n) {
            this.dataPtr = chiPointer;
            this.vertexId = n;
        }

        @Override
        public int getVertexId() {
            return this.vertexId;
        }

        @Override
        public EdgeValue getValue() {
            return blockManager.dereference(this.dataPtr, edgeValueConverter);
        }

        @Override
        public void setValue(EdgeValue EdgeValue) {
            blockManager.writeValue(this.dataPtr, edgeValueConverter, EdgeValue);
        }
    }
}

