/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.graphchi;

import edu.cmu.graphchi.Scheduler;
import edu.cmu.graphchi.engine.VertexInterval;
import edu.cmu.graphchi.preprocessing.VertexIdTranslate;

public class GraphChiContext {
    private Object threadLocal = null;
    private int threadId;
    private int iteration;
    private int numIterations;
    private long numEdges;
    private long numVertices;
    private Scheduler scheduler;
    private VertexInterval curInterval;
    private VertexIdTranslate vertexIdTranslate;

    public VertexInterval getCurInterval() {
        return this.curInterval;
    }

    protected void setCurInterval(VertexInterval vertexInterval) {
        this.curInterval = vertexInterval;
    }

    public int getIteration() {
        return this.iteration;
    }

    protected void setIteration(int n) {
        this.iteration = n;
    }

    public int getNumIterations() {
        return this.numIterations;
    }

    protected void setNumIterations(int n) {
        this.numIterations = n;
    }

    public Scheduler getScheduler() {
        return this.scheduler;
    }

    protected void setScheduler(Scheduler scheduler) {
        this.scheduler = scheduler;
    }

    public long getNumEdges() {
        return this.numEdges;
    }

    protected void setNumEdges(long l) {
        this.numEdges = l;
    }

    public long getNumVertices() {
        return this.numVertices;
    }

    protected void setNumVertices(long l) {
        this.numVertices = l;
    }

    public int getThreadId() {
        return this.threadId;
    }

    public boolean isLastIteration() {
        return this.iteration == this.getNumIterations() - 1;
    }

    public Object getThreadLocal() {
        return this.threadLocal;
    }

    public void setThreadLocal(Object object) {
        this.threadLocal = object;
    }

    public VertexIdTranslate getVertexIdTranslate() {
        return this.vertexIdTranslate;
    }

    protected void setVertexIdTranslate(VertexIdTranslate vertexIdTranslate) {
        this.vertexIdTranslate = vertexIdTranslate;
    }

    public GraphChiContext clone(int n) {
        GraphChiContext graphChiContext = new GraphChiContext();
        graphChiContext.threadId = n;
        graphChiContext.iteration = this.iteration;
        graphChiContext.numIterations = this.numIterations;
        graphChiContext.numEdges = this.numEdges;
        graphChiContext.numVertices = this.numVertices;
        graphChiContext.scheduler = this.scheduler;
        graphChiContext.curInterval = this.curInterval;
        graphChiContext.vertexIdTranslate = this.vertexIdTranslate;
        return graphChiContext;
    }
}

