/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.graphchi.apps;

import edu.cmu.graphchi.ChiLogger;
import edu.cmu.graphchi.ChiVertex;
import edu.cmu.graphchi.GraphChiContext;
import edu.cmu.graphchi.GraphChiProgram;
import edu.cmu.graphchi.datablocks.IntConverter;
import edu.cmu.graphchi.engine.GraphChiEngine;
import edu.cmu.graphchi.engine.VertexInterval;
import edu.cmu.graphchi.preprocessing.EdgeProcessor;
import edu.cmu.graphchi.preprocessing.FastSharder;
import edu.cmu.graphchi.preprocessing.VertexProcessor;
import edu.cmu.graphchi.vertexdata.VertexAggregator;
import edu.cmu.graphchi.vertexdata.VertexIdValue;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.logging.Logger;

public class SmokeTest
implements GraphChiProgram<Integer, Integer> {
    private static Logger logger = ChiLogger.getLogger("smoketest");
    private static HashMap<Integer, Integer> loadedVertexValues = new HashMap();

    @Override
    public void update(ChiVertex<Integer, Integer> chiVertex, GraphChiContext graphChiContext) {
        int n;
        int n2;
        if (graphChiContext.getIteration() == 0) {
            n2 = graphChiContext.getVertexIdTranslate().backward(chiVertex.getId());
            if (loadedVertexValues.containsKey(n2)) {
                if (!chiVertex.getValue().equals(loadedVertexValues.get(n2))) {
                    throw new RuntimeException("Vertex value for vertex " + n2 + " not loaded properly:" + chiVertex.getValue() + " !=" + loadedVertexValues.get(n2));
                }
                logger.info("Loaded vertex value correctly: " + n2 + " = " + loadedVertexValues.get(n2));
            }
            chiVertex.setValue(chiVertex.getId() + graphChiContext.getIteration());
        } else {
            n2 = chiVertex.getValue();
            if (n2 != (n = chiVertex.getId() + graphChiContext.getIteration() - 1)) {
                throw new RuntimeException("Mismatch (vertex). Expected: " + n + " but had " + n2);
            }
            for (int i = 0; i < chiVertex.numInEdges(); ++i) {
                int n3 = chiVertex.inEdge(i).getValue();
                int n4 = chiVertex.getId() > chiVertex.inEdge(i).getVertexId() ? 1 : 0;
                int n5 = chiVertex.inEdge(i).getVertexId() + graphChiContext.getIteration() - 1 + n4;
                if (n5 == n3) continue;
                throw new RuntimeException("Mismatch (edge): " + n5 + " expected but had " + n3 + ". Iteration:" + graphChiContext.getIteration() + ", edge:" + chiVertex.inEdge(i).getVertexId() + " -> " + chiVertex.getId());
            }
            chiVertex.setValue(chiVertex.getId() + graphChiContext.getIteration());
        }
        n2 = chiVertex.getValue();
        for (n = 0; n < chiVertex.numOutEdges(); ++n) {
            chiVertex.outEdge(n).setValue(n2);
        }
    }

    @Override
    public void beginIteration(GraphChiContext graphChiContext) {
    }

    @Override
    public void endIteration(GraphChiContext graphChiContext) {
    }

    @Override
    public void beginInterval(GraphChiContext graphChiContext, VertexInterval vertexInterval) {
    }

    @Override
    public void endInterval(GraphChiContext graphChiContext, VertexInterval vertexInterval) {
    }

    @Override
    public void beginSubInterval(GraphChiContext graphChiContext, VertexInterval vertexInterval) {
    }

    @Override
    public void endSubInterval(GraphChiContext graphChiContext, VertexInterval vertexInterval) {
    }

    protected static FastSharder createSharder(String string, int n) throws IOException {
        return new FastSharder<Integer, Integer>(string, n, new VertexProcessor<Integer>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Integer receiveVertexValue(int n, String string) {
                if (string == null) {
                    return 0;
                }
                1 var3_3 = this;
                synchronized (var3_3) {
                    loadedVertexValues.put(n, Integer.parseInt(string));
                }
                return Integer.parseInt(string);
            }
        }, new EdgeProcessor<Integer>(){

            @Override
            public Integer receiveEdge(int n, int n2, String string) {
                return string == null ? 0 : Integer.parseInt(string);
            }
        }, new IntConverter(), new IntConverter());
    }

    public static void main(String[] stringArray) throws Exception {
        String string = stringArray[0];
        int n = Integer.parseInt(stringArray[1]);
        String string2 = stringArray.length >= 3 ? stringArray[2] : null;
        FastSharder fastSharder = SmokeTest.createSharder(string, n);
        fastSharder.setAllowSparseDegreesAndVertexData(false);
        if (string.equals("pipein")) {
            fastSharder.shard(System.in);
        } else {
            fastSharder.shard((InputStream)new FileInputStream(new File(string)), string2);
        }
        GraphChiEngine<Integer, Integer> graphChiEngine = new GraphChiEngine<Integer, Integer>(string, n);
        graphChiEngine.setEdataConverter(new IntConverter());
        graphChiEngine.setVertexDataConverter(new IntConverter());
        graphChiEngine.setModifiesInedges(false);
        graphChiEngine.run(new SmokeTest(), 5);
        Iterator<VertexIdValue<Integer>> iterator = VertexAggregator.vertexIterator(graphChiEngine.numVertices(), string, new IntConverter(), graphChiEngine.getVertexIdTranslate());
        int n2 = 0;
        while (iterator.hasNext()) {
            VertexIdValue<Integer> vertexIdValue = iterator.next();
            int n3 = graphChiEngine.getVertexIdTranslate().forward(vertexIdValue.getVertexId());
            int n4 = n3 + 4;
            if (n4 != vertexIdValue.getValue()) {
                throw new IllegalStateException("Expected internal value to be " + n4 + ", but it was " + vertexIdValue.getValue() + "; internal id=" + n3 + "; orig=" + vertexIdValue.getVertexId());
            }
            if (n2 % 10000 == 0) {
                logger.info("Scanning vertices: " + n2);
            }
            ++n2;
        }
        if (n2 != graphChiEngine.numVertices()) {
            throw new IllegalStateException("Error in iterator: did not have numVertices vertices: " + n2 + "/" + graphChiEngine.numVertices());
        }
        logger.info("Ready.");
    }
}

