/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.graphchi.apps;

import edu.cmu.graphchi.ChiFilenames;
import edu.cmu.graphchi.ChiLogger;
import edu.cmu.graphchi.ChiVertex;
import edu.cmu.graphchi.GraphChiContext;
import edu.cmu.graphchi.GraphChiProgram;
import edu.cmu.graphchi.datablocks.FloatConverter;
import edu.cmu.graphchi.datablocks.FloatPair;
import edu.cmu.graphchi.datablocks.FloatPairConverter;
import edu.cmu.graphchi.engine.GraphChiEngine;
import edu.cmu.graphchi.engine.VertexInterval;
import edu.cmu.graphchi.io.CompressedIO;
import edu.cmu.graphchi.preprocessing.EdgeProcessor;
import edu.cmu.graphchi.preprocessing.FastSharder;
import edu.cmu.graphchi.preprocessing.VertexIdTranslate;
import edu.cmu.graphchi.preprocessing.VertexProcessor;
import edu.cmu.graphchi.util.IdFloat;
import edu.cmu.graphchi.util.Toplist;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.TreeSet;
import java.util.logging.Logger;

public class WeightedPagerank
implements GraphChiProgram<Float, FloatPair> {
    private static Logger logger = ChiLogger.getLogger("weighted_pagerank");

    @Override
    public void update(ChiVertex<Float, FloatPair> chiVertex, GraphChiContext graphChiContext) {
        int n;
        float f;
        if (graphChiContext.getIteration() == 0) {
            chiVertex.setValue(Float.valueOf(1.0f));
        } else {
            f = 0.0f;
            for (n = 0; n < chiVertex.numInEdges(); ++n) {
                f += chiVertex.inEdge((int)n).getValue().second;
            }
            chiVertex.setValue(Float.valueOf(0.15f + 0.85f * f));
        }
        f = 0.0f;
        for (n = 0; n < chiVertex.numOutEdges(); ++n) {
            f += chiVertex.outEdge((int)n).getValue().first;
        }
        for (n = 0; n < chiVertex.numOutEdges(); ++n) {
            FloatPair floatPair = chiVertex.outEdge(n).getValue();
            float f2 = chiVertex.outEdge((int)n).getValue().first;
            chiVertex.outEdge(n).setValue(new FloatPair(floatPair.first, chiVertex.getValue().floatValue() * f2 / f));
        }
    }

    @Override
    public void beginIteration(GraphChiContext graphChiContext) {
    }

    @Override
    public void endIteration(GraphChiContext graphChiContext) {
    }

    @Override
    public void beginInterval(GraphChiContext graphChiContext, VertexInterval vertexInterval) {
    }

    @Override
    public void endInterval(GraphChiContext graphChiContext, VertexInterval vertexInterval) {
    }

    @Override
    public void beginSubInterval(GraphChiContext graphChiContext, VertexInterval vertexInterval) {
    }

    @Override
    public void endSubInterval(GraphChiContext graphChiContext, VertexInterval vertexInterval) {
    }

    protected static FastSharder createSharder(String string, int n) throws IOException {
        return new FastSharder<Float, FloatPair>(string, n, new VertexProcessor<Float>(){

            @Override
            public Float receiveVertexValue(int n, String string) {
                return Float.valueOf(string == null ? 0.0f : Float.parseFloat(string));
            }
        }, new EdgeProcessor<FloatPair>(){

            @Override
            public FloatPair receiveEdge(int n, int n2, String string) {
                return new FloatPair(Float.parseFloat(string), 0.0f);
            }
        }, new FloatConverter(), new FloatPairConverter());
    }

    public static void main(String[] stringArray) throws Exception {
        String string = stringArray[0];
        int n = Integer.parseInt(stringArray[1]);
        String string2 = stringArray.length >= 3 ? stringArray[2] : null;
        CompressedIO.disableCompression();
        FastSharder fastSharder = WeightedPagerank.createSharder(string, n);
        if (string.equals("pipein")) {
            fastSharder.shard(System.in, string2);
        } else if (!new File(ChiFilenames.getFilenameIntervals(string, n)).exists()) {
            fastSharder.shard((InputStream)new FileInputStream(new File(string)), string2);
        } else {
            logger.info("Found shards -- no need to preprocess");
        }
        GraphChiEngine<Float, FloatPair> graphChiEngine = new GraphChiEngine<Float, FloatPair>(string, n);
        graphChiEngine.setEdataConverter(new FloatPairConverter());
        graphChiEngine.setVertexDataConverter(new FloatConverter());
        graphChiEngine.setModifiesInedges(false);
        graphChiEngine.run(new WeightedPagerank(), 4);
        logger.info("Ready.");
        int n2 = 0;
        VertexIdTranslate vertexIdTranslate = graphChiEngine.getVertexIdTranslate();
        TreeSet<IdFloat> treeSet = Toplist.topListFloat(string, graphChiEngine.numVertices(), 20);
        for (IdFloat idFloat : treeSet) {
            System.out.println(++n2 + ": " + vertexIdTranslate.backward(idFloat.getVertexId()) + " = " + idFloat.getValue());
        }
    }
}

