/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.graphchi.apps.kcore;

import edu.cmu.graphchi.ChiFilenames;
import edu.cmu.graphchi.ChiLogger;
import edu.cmu.graphchi.ChiVertex;
import edu.cmu.graphchi.GraphChiContext;
import edu.cmu.graphchi.GraphChiProgram;
import edu.cmu.graphchi.datablocks.IntConverter;
import edu.cmu.graphchi.engine.GraphChiEngine;
import edu.cmu.graphchi.engine.VertexInterval;
import edu.cmu.graphchi.io.CompressedIO;
import edu.cmu.graphchi.preprocessing.EdgeProcessor;
import edu.cmu.graphchi.preprocessing.FastSharder;
import edu.cmu.graphchi.preprocessing.VertexProcessor;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.logging.Logger;

public class GraphTransformer
implements GraphChiProgram<Integer, Integer> {
    protected static int nEdgesAdded = 0;
    protected static BufferedWriter bw;
    private static Logger logger;

    public static void startWriting(File file, boolean bl) throws IOException {
        FileWriter fileWriter = new FileWriter(file, bl);
        bw = new BufferedWriter(fileWriter);
    }

    public static void stopWriting() throws IOException {
        bw.close();
    }

    @Override
    public void update(ChiVertex<Integer, Integer> chiVertex, GraphChiContext graphChiContext) {
        int n;
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        for (n = 0; n < chiVertex.numOutEdges(); ++n) {
            arrayList.add(chiVertex.outEdge(n).getVertexId());
        }
        for (n = 0; n < chiVertex.numInEdges(); ++n) {
            if (arrayList.contains(chiVertex.inEdge(n).getVertexId())) continue;
            try {
                bw.write("\n" + chiVertex.getId() + "\t" + chiVertex.inEdge(n).getVertexId());
                ++nEdgesAdded;
                continue;
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
    }

    @Override
    public void beginIteration(GraphChiContext graphChiContext) {
    }

    @Override
    public void endIteration(GraphChiContext graphChiContext) {
    }

    @Override
    public void beginInterval(GraphChiContext graphChiContext, VertexInterval vertexInterval) {
    }

    @Override
    public void endInterval(GraphChiContext graphChiContext, VertexInterval vertexInterval) {
    }

    @Override
    public void beginSubInterval(GraphChiContext graphChiContext, VertexInterval vertexInterval) {
    }

    @Override
    public void endSubInterval(GraphChiContext graphChiContext, VertexInterval vertexInterval) {
    }

    protected static FastSharder createSharder(String string, int n) throws IOException {
        return new FastSharder<Integer, Integer>(string, n, new VertexProcessor<Integer>(){

            @Override
            public Integer receiveVertexValue(int n, String string) {
                return 0;
            }
        }, new EdgeProcessor<Integer>(){

            @Override
            public Integer receiveEdge(int n, int n2, String string) {
                return 0;
            }
        }, new IntConverter(), new IntConverter());
    }

    public static void main(String[] stringArray) throws IOException {
        String string = "./datasets/";
        String string2 = "./output/";
        String string3 = stringArray[0];
        int n = Integer.parseInt(stringArray[1]);
        String string4 = stringArray[2];
        int n2 = stringArray.length >= 4 ? Integer.valueOf(Integer.parseInt(stringArray[3])) : null;
        CompressedIO.disableCompression();
        String string5 = string + string3;
        FastSharder fastSharder = GraphTransformer.createSharder(string5, n);
        if (string5.equals("pipein")) {
            fastSharder.shard(System.in, string4);
        } else if (!new File(ChiFilenames.getFilenameIntervals(string5, n)).exists()) {
            fastSharder.shard((InputStream)new FileInputStream(new File(string5)), string4);
        } else {
            logger.info("Found shards -- no need to preprocess");
        }
        GraphTransformer.startWriting(new File(string5), true);
        GraphChiEngine<Integer, Integer> graphChiEngine = new GraphChiEngine<Integer, Integer>(string5, n);
        graphChiEngine.setMemoryBudgetMb(n2);
        graphChiEngine.setSkipZeroDegreeVertices(true);
        graphChiEngine.setEnableScheduler(true);
        graphChiEngine.setEdataConverter(new IntConverter());
        graphChiEngine.setVertexDataConverter(new IntConverter());
        graphChiEngine.run(new GraphTransformer(), 1);
        GraphTransformer.stopWriting();
        GraphTransformer.startWriting(new File(string2 + "gtransformer-report-" + string3), false);
        bw.write("Total edges added: " + nEdgesAdded + "\n");
        GraphTransformer.stopWriting();
        logger.info("Success!");
    }

    static {
        logger = ChiLogger.getLogger("GraphConverter");
    }
}

