/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.graphchi.apps.pig;

import edu.cmu.graphchi.ChiVertex;
import edu.cmu.graphchi.GraphChiContext;
import edu.cmu.graphchi.GraphChiProgram;
import edu.cmu.graphchi.datablocks.FloatConverter;
import edu.cmu.graphchi.datablocks.FloatPair;
import edu.cmu.graphchi.datablocks.FloatPairConverter;
import edu.cmu.graphchi.engine.GraphChiEngine;
import edu.cmu.graphchi.engine.VertexInterval;
import edu.cmu.graphchi.hadoop.PigGraphChiBase;
import edu.cmu.graphchi.preprocessing.EdgeProcessor;
import edu.cmu.graphchi.preprocessing.FastSharder;
import edu.cmu.graphchi.preprocessing.VertexProcessor;
import edu.cmu.graphchi.vertexdata.VertexAggregator;
import edu.cmu.graphchi.vertexdata.VertexIdValue;
import java.io.IOException;
import java.util.Iterator;
import java.util.logging.Logger;
import org.apache.pig.backend.executionengine.ExecException;
import org.apache.pig.data.Tuple;
import org.apache.pig.data.TupleFactory;

public class PigWeightedPagerank
extends PigGraphChiBase
implements GraphChiProgram<Float, FloatPair> {
    private static Logger logger = Logger.getLogger("weighted_pagerank");
    private Iterator<VertexIdValue<Float>> vertexIterator;

    @Override
    public void update(ChiVertex<Float, FloatPair> chiVertex, GraphChiContext graphChiContext) {
        int n;
        float f;
        if (graphChiContext.getIteration() == 0) {
            chiVertex.setValue(Float.valueOf(1.0f));
        } else {
            f = 0.0f;
            for (n = 0; n < chiVertex.numInEdges(); ++n) {
                f += chiVertex.inEdge((int)n).getValue().second;
            }
            chiVertex.setValue(Float.valueOf(0.15f + 0.85f * f));
        }
        f = 0.0f;
        for (n = 0; n < chiVertex.numOutEdges(); ++n) {
            f += chiVertex.outEdge((int)n).getValue().first;
        }
        for (n = 0; n < chiVertex.numOutEdges(); ++n) {
            FloatPair floatPair = chiVertex.outEdge(n).getValue();
            float f2 = chiVertex.outEdge((int)n).getValue().first;
            chiVertex.outEdge(n).setValue(new FloatPair(f2, chiVertex.getValue().floatValue() * f2 / f));
        }
    }

    @Override
    public void beginIteration(GraphChiContext graphChiContext) {
    }

    @Override
    public void endIteration(GraphChiContext graphChiContext) {
    }

    @Override
    public void beginInterval(GraphChiContext graphChiContext, VertexInterval vertexInterval) {
    }

    @Override
    public void endInterval(GraphChiContext graphChiContext, VertexInterval vertexInterval) {
    }

    @Override
    public void beginSubInterval(GraphChiContext graphChiContext, VertexInterval vertexInterval) {
    }

    @Override
    public void endSubInterval(GraphChiContext graphChiContext, VertexInterval vertexInterval) {
    }

    @Override
    protected String getSchemaString() {
        return "(vertex:int, weight:float)";
    }

    @Override
    protected int getNumShards() {
        return 12;
    }

    @Override
    protected void runGraphChi() throws Exception {
        GraphChiEngine<Float, FloatPair> graphChiEngine = new GraphChiEngine<Float, FloatPair>(this.getGraphName(), this.getNumShards());
        graphChiEngine.setEdataConverter(new FloatPairConverter());
        graphChiEngine.setVertexDataConverter(new FloatConverter());
        graphChiEngine.setModifiesInedges(false);
        graphChiEngine.run(this, 4);
        logger.info("Ready.");
        this.vertexIterator = VertexAggregator.vertexIterator(graphChiEngine.numVertices(), this.getGraphName(), new FloatConverter(), graphChiEngine.getVertexIdTranslate());
    }

    @Override
    protected FastSharder createSharder(String string, int n) throws IOException {
        return new FastSharder<Float, FloatPair>(string, n, new VertexProcessor<Float>(){

            @Override
            public Float receiveVertexValue(int n, String string) {
                return Float.valueOf(string == null ? 0.0f : Float.parseFloat(string));
            }
        }, new EdgeProcessor<FloatPair>(){

            @Override
            public FloatPair receiveEdge(int n, int n2, String string) {
                return new FloatPair(Float.parseFloat(string), 0.0f);
            }
        }, new FloatConverter(), new FloatPairConverter());
    }

    @Override
    protected Tuple getNextResult(TupleFactory tupleFactory) throws ExecException {
        if (this.vertexIterator.hasNext()) {
            Tuple tuple = tupleFactory.newTuple(2);
            VertexIdValue<Float> vertexIdValue = this.vertexIterator.next();
            tuple.set(0, (Object)vertexIdValue.getVertexId());
            tuple.set(1, (Object)vertexIdValue.getValue());
            return tuple;
        }
        return null;
    }
}

