/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.graphchi.apps.randomwalks;

import edu.cmu.graphchi.ChiFilenames;
import edu.cmu.graphchi.ChiLogger;
import edu.cmu.graphchi.ChiVertex;
import edu.cmu.graphchi.EdgeDirection;
import edu.cmu.graphchi.EmptyType;
import edu.cmu.graphchi.preprocessing.FastSharder;
import edu.cmu.graphchi.preprocessing.VertexIdTranslate;
import edu.cmu.graphchi.util.IdCount;
import edu.cmu.graphchi.walks.DrunkardContext;
import edu.cmu.graphchi.walks.DrunkardJob;
import edu.cmu.graphchi.walks.DrunkardMobEngine;
import edu.cmu.graphchi.walks.IntDrunkardContext;
import edu.cmu.graphchi.walks.IntDrunkardFactory;
import edu.cmu.graphchi.walks.IntWalkArray;
import edu.cmu.graphchi.walks.WalkArray;
import edu.cmu.graphchi.walks.WalkUpdateFunction;
import edu.cmu.graphchi.walks.distributions.DrunkardCompanion;
import edu.cmu.graphchi.walks.distributions.IntDrunkardCompanion;
import edu.cmu.graphchi.walks.distributions.RemoteDrunkardCompanion;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.rmi.Naming;
import java.util.Random;
import java.util.logging.Logger;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.PosixParser;

public class PersonalizedPageRank
implements WalkUpdateFunction<EmptyType, EmptyType> {
    private static double RESET_PROBABILITY = 0.15;
    private static Logger logger = ChiLogger.getLogger("personalized-pagerank");
    private DrunkardMobEngine<EmptyType, EmptyType> drunkardMobEngine;
    private String baseFilename;
    private int firstSource;
    private int numSources;
    private int numWalksPerSource;
    private String companionUrl;

    public PersonalizedPageRank(String string, String string2, int n, int n2, int n3, int n4) throws Exception {
        this.baseFilename = string2;
        this.drunkardMobEngine = new DrunkardMobEngine(string2, n, new IntDrunkardFactory());
        this.companionUrl = string;
        this.firstSource = n2;
        this.numSources = n3;
        this.numWalksPerSource = n4;
    }

    private void execute(int n) throws Exception {
        File file = new File(this.baseFilename);
        RemoteDrunkardCompanion remoteDrunkardCompanion = this.companionUrl.equals("local") ? new IntDrunkardCompanion(4, Runtime.getRuntime().maxMemory() / 3L) : (RemoteDrunkardCompanion)Naming.lookup(this.companionUrl);
        DrunkardJob drunkardJob = this.drunkardMobEngine.addJob("personalizedPageRank", EdgeDirection.OUT_EDGES, this, remoteDrunkardCompanion);
        drunkardJob.configureSourceRangeInternalIds(this.firstSource, this.numSources, this.numWalksPerSource);
        this.drunkardMobEngine.run(n);
        int n2 = 100;
        remoteDrunkardCompanion.outputDistributions(this.baseFilename + "_ppr_" + this.firstSource + "_" + (this.firstSource + this.numSources - 1) + ".top" + n2, n2);
        VertexIdTranslate vertexIdTranslate = this.drunkardMobEngine.getVertexIdTranslate();
        IdCount[] idCountArray = remoteDrunkardCompanion.getTop(this.firstSource, 10);
        System.out.println("Top visits from source vertex " + vertexIdTranslate.forward(this.firstSource) + " (internal id=" + this.firstSource + ")");
        for (IdCount idCount : idCountArray) {
            System.out.println(vertexIdTranslate.backward(idCount.id) + ": " + idCount.count);
        }
        if (remoteDrunkardCompanion instanceof DrunkardCompanion) {
            ((DrunkardCompanion)remoteDrunkardCompanion).close();
        }
    }

    @Override
    public void processWalksAtVertex(WalkArray walkArray, ChiVertex<EmptyType, EmptyType> chiVertex, DrunkardContext drunkardContext, Random random) {
        int[] nArray = ((IntWalkArray)walkArray).getArray();
        IntDrunkardContext intDrunkardContext = (IntDrunkardContext)drunkardContext;
        int n = nArray.length;
        int n2 = chiVertex.numOutEdges();
        if (n2 > 0) {
            for (int i = 0; i < n; ++i) {
                int n3 = nArray[i];
                if (random.nextDouble() < RESET_PROBABILITY) {
                    intDrunkardContext.resetWalk(n3, false);
                    continue;
                }
                int n4 = chiVertex.getOutEdgeId(random.nextInt(n2));
                boolean bl = !intDrunkardContext.isWalkStartedFromVertex(n3);
                intDrunkardContext.forwardWalkTo(n3, n4, bl);
            }
        } else {
            for (int i = 0; i < n; ++i) {
                intDrunkardContext.resetWalk(nArray[i], false);
            }
        }
    }

    @Override
    public int[] getNotTrackedVertices(ChiVertex<EmptyType, EmptyType> chiVertex) {
        int[] nArray = new int[1 + chiVertex.numOutEdges()];
        for (int i = 0; i < chiVertex.numOutEdges(); ++i) {
            nArray[i + 1] = chiVertex.getOutEdgeId(i);
        }
        nArray[0] = chiVertex.getId();
        return nArray;
    }

    protected static FastSharder createSharder(String string, int n) throws IOException {
        return new FastSharder(string, n, null, null, null, null);
    }

    public static void main(String[] stringArray) throws Exception {
        Options options = new Options();
        options.addOption("g", "graph", true, "graph file name");
        options.addOption("n", "nshards", true, "number of shards");
        options.addOption("t", "filetype", true, "filetype (edgelist|adjlist)");
        options.addOption("f", "firstsource", true, "id of the first source vertex (internal id)");
        options.addOption("s", "nsources", true, "number of sources");
        options.addOption("w", "walkspersource", true, "number of walks to start from each source");
        options.addOption("i", "niters", true, "number of iterations");
        options.addOption("u", "companion", true, "RMI url to the DrunkardCompanion or 'local' (default)");
        try {
            FastSharder fastSharder;
            String string;
            PosixParser posixParser = new PosixParser();
            CommandLine commandLine = posixParser.parse(options, stringArray);
            String string2 = commandLine.getOptionValue("graph");
            int n = Integer.parseInt(commandLine.getOptionValue("nshards"));
            String string3 = string = commandLine.hasOption("filetype") ? commandLine.getOptionValue("filetype") : null;
            if (string2.equals("pipein")) {
                fastSharder = PersonalizedPageRank.createSharder(string2, n);
                fastSharder.shard(System.in, string);
            } else {
                fastSharder = PersonalizedPageRank.createSharder(string2, n);
                if (!new File(ChiFilenames.getFilenameIntervals(string2, n)).exists()) {
                    fastSharder.shard((InputStream)new FileInputStream(new File(string2)), string);
                } else {
                    logger.info("Found shards -- no need to pre-process");
                }
            }
            int n2 = Integer.parseInt(commandLine.getOptionValue("firstsource"));
            int n3 = Integer.parseInt(commandLine.getOptionValue("nsources"));
            int n4 = Integer.parseInt(commandLine.getOptionValue("walkspersource"));
            int n5 = Integer.parseInt(commandLine.getOptionValue("niters"));
            String string4 = commandLine.hasOption("companion") ? commandLine.getOptionValue("companion") : "local";
            PersonalizedPageRank personalizedPageRank = new PersonalizedPageRank(string4, string2, n, n2, n3, n4);
            personalizedPageRank.execute(n5);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            HelpFormatter helpFormatter = new HelpFormatter();
            helpFormatter.printHelp("PersonalizedPageRank", options);
        }
    }
}

