/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.graphchi.apps.recommendations;

import edu.cmu.graphchi.ChiLogger;
import edu.cmu.graphchi.ChiVertex;
import edu.cmu.graphchi.EdgeDirection;
import edu.cmu.graphchi.apps.ALSMatrixFactorization;
import edu.cmu.graphchi.datablocks.FloatConverter;
import edu.cmu.graphchi.preprocessing.VertexIdTranslate;
import edu.cmu.graphchi.util.IdCount;
import edu.cmu.graphchi.walks.DrunkardContext;
import edu.cmu.graphchi.walks.DrunkardJob;
import edu.cmu.graphchi.walks.DrunkardMobEngine;
import edu.cmu.graphchi.walks.IntDrunkardContext;
import edu.cmu.graphchi.walks.IntDrunkardFactory;
import edu.cmu.graphchi.walks.IntWalkArray;
import edu.cmu.graphchi.walks.WalkArray;
import edu.cmu.graphchi.walks.WalkUpdateFunction;
import edu.cmu.graphchi.walks.WeightedHopper;
import edu.cmu.graphchi.walks.distributions.IntDrunkardCompanion;
import java.util.ArrayList;
import java.util.Random;
import java.util.logging.Logger;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.PosixParser;

public class MovieRecommender {
    protected String baseFilename;
    protected int nShards;
    protected int D;
    protected static Logger logger = ChiLogger.getLogger("movie-recommender");

    public MovieRecommender(String string, int n, int n2) {
        this.baseFilename = string;
        this.nShards = n;
        this.D = n2;
    }

    protected void execute() throws Exception {
        int n;
        ALSMatrixFactorization aLSMatrixFactorization = ALSMatrixFactorization.computeALS(this.baseFilename, this.nShards, this.D, 5);
        logger.info("Computed ALS, now random walks");
        DrunkardMobEngine<Integer, Float> drunkardMobEngine = new DrunkardMobEngine<Integer, Float>(this.baseFilename, this.nShards, new IntDrunkardFactory());
        DrunkardJob drunkardJob = drunkardMobEngine.addJob("positive", EdgeDirection.IN_AND_OUT_EDGES, new PositiveWalkUpdate(), new IntDrunkardCompanion(2, Runtime.getRuntime().maxMemory() / 8L));
        DrunkardJob drunkardJob2 = drunkardMobEngine.addJob("negative", EdgeDirection.IN_AND_OUT_EDGES, new NegativeWalkUpdate(), new IntDrunkardCompanion(2, Runtime.getRuntime().maxMemory() / 8L));
        drunkardMobEngine.setEdataConverter(new FloatConverter());
        ALSMatrixFactorization.BipartiteGraphInfo bipartiteGraphInfo = aLSMatrixFactorization.getGraphInfo();
        VertexIdTranslate vertexIdTranslate = drunkardMobEngine.getVertexIdTranslate();
        ArrayList<Integer> arrayList = new ArrayList<Integer>(bipartiteGraphInfo.getNumLeft());
        int n2 = 50000;
        int n3 = 1000;
        if (n2 > bipartiteGraphInfo.getNumLeft()) {
            bipartiteGraphInfo.getNumLeft();
        }
        logger.info("Compute predictions for first " + n2 + " users");
        for (n = 0; n < n2; ++n) {
            arrayList.add(vertexIdTranslate.forward(n));
        }
        drunkardJob.configureWalkSources(arrayList, n3);
        drunkardJob2.configureWalkSources(arrayList, n3);
        drunkardMobEngine.run(6);
        for (n = 0; n < 500; ++n) {
            int n4 = vertexIdTranslate.forward(n);
            IdCount[] idCountArray = drunkardJob.getCompanion().getTop(n4, 20);
            IdCount[] idCountArray2 = drunkardJob2.getCompanion().getTop(n4, 20);
            double d = 0.0;
            double d2 = 0.0;
            int n5 = Math.min(idCountArray.length, idCountArray2.length);
            for (int i = 0; i < n5; ++i) {
                d += aLSMatrixFactorization.predict(n4, idCountArray[i].id);
                d2 += aLSMatrixFactorization.predict(n4, idCountArray2[i].id);
            }
            long l = System.currentTimeMillis();
            double d3 = 0.0;
            int n6 = bipartiteGraphInfo.getNumRight();
            for (int i = 0; i < n6; ++i) {
                int n7 = vertexIdTranslate.forward(bipartiteGraphInfo.getNumLeft() + i);
                d3 += aLSMatrixFactorization.predict(n4, n7);
            }
            System.out.println(n + " avg pos: " + d / (double)n5 + "; avg neg: " + d2 / (double)n5 + "; all=" + d3 / (double)bipartiteGraphInfo.getNumRight() + " (" + (System.currentTimeMillis() - l) + " ms for " + n6 + " movies");
        }
    }

    public static void main(String[] stringArray) {
        Options options = new Options();
        options.addOption("g", "graph", true, "graph file name");
        options.addOption("n", "nshards", true, "number of shards");
        options.addOption("d", "als_dimension", true, "ALS dimensionality (default 20)");
        try {
            PosixParser posixParser = new PosixParser();
            CommandLine commandLine = posixParser.parse(options, stringArray);
            String string = commandLine.getOptionValue("graph");
            int n = Integer.parseInt(commandLine.getOptionValue("nshards"));
            int n2 = Integer.parseInt(commandLine.hasOption("als_dimension") ? commandLine.getOptionValue("als_dimension") : "5");
            MovieRecommender movieRecommender = new MovieRecommender(string, n, n2);
            movieRecommender.execute();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            HelpFormatter helpFormatter = new HelpFormatter();
            helpFormatter.printHelp("MovieRecommender", options);
        }
    }

    protected class NegativeWalkUpdate
    extends PositiveWalkUpdate {
        protected NegativeWalkUpdate() {
        }

        @Override
        public void processWalksAtVertex(WalkArray walkArray, ChiVertex<Integer, Float> chiVertex, DrunkardContext drunkardContext, Random random) {
            int[] nArray = ((IntWalkArray)walkArray).getArray();
            IntDrunkardContext intDrunkardContext = (IntDrunkardContext)drunkardContext;
            if (chiVertex.numInEdges() > 0 || intDrunkardContext.getIteration() > 0) {
                NegativeWalkUpdate.hopToHighRatings(nArray, chiVertex, intDrunkardContext, random);
            } else {
                int n;
                Object object;
                ArrayList<Integer> arrayList = new ArrayList<Integer>();
                for (int n2 : nArray) {
                    if (intDrunkardContext.isWalkStartedFromVertex(n2)) continue;
                    arrayList.add(n2);
                }
                if (arrayList.size() > 0) {
                    object = new int[arrayList.size()];
                    for (n = 0; n < ((int[])object).length; ++n) {
                        object[n] = (Integer)arrayList.get(n);
                    }
                    NegativeWalkUpdate.hopToHighRatings((int[])object, chiVertex, intDrunkardContext, random);
                }
                object = new ArrayList();
                for (n = 0; n < chiVertex.numOutEdges(); ++n) {
                    if (!(chiVertex.getOutEdgeValue(n).floatValue() < 2.0f)) continue;
                    ((ArrayList)object).add(chiVertex.getOutEdgeId(n));
                }
                if (((ArrayList)object).size() == 0) {
                    logger.info("No badly rated movies for user " + intDrunkardContext.getVertexIdTranslate().backward(chiVertex.getId()));
                    return;
                }
                for (int n3 : nArray) {
                    if (!intDrunkardContext.isWalkStartedFromVertex(n3)) continue;
                    int n4 = (Integer)((ArrayList)object).get(random.nextInt(((ArrayList)object).size()));
                    intDrunkardContext.forwardWalkTo(n3, n4, true);
                    if (chiVertex.getId() != 0) continue;
                    for (int i = 0; i < chiVertex.numOutEdges(); ++i) {
                        if (chiVertex.getOutEdgeId(i) != n4) continue;
                        System.out.println("BAD ====> " + n4 + "; " + chiVertex.getOutEdgeValue(i));
                    }
                }
            }
        }
    }

    protected static class PositiveWalkUpdate
    implements WalkUpdateFunction<Integer, Float> {
        private static final float[] weightedRating = new float[]{0.0f, 1.0E-5f, 1.0E-5f, 1.0E-4f, 100.0f, 1000.0f};

        protected PositiveWalkUpdate() {
        }

        @Override
        public void processWalksAtVertex(WalkArray walkArray, ChiVertex<Integer, Float> chiVertex, DrunkardContext drunkardContext, Random random) {
            int[] nArray = ((IntWalkArray)walkArray).getArray();
            PositiveWalkUpdate.hopToHighRatings(nArray, chiVertex, (IntDrunkardContext)drunkardContext, random);
        }

        protected static void hopToHighRatings(int[] nArray, ChiVertex<Integer, Float> chiVertex, IntDrunkardContext intDrunkardContext, Random random) {
            int[] nArray2 = WeightedHopper.generateRandomHopsAliasMethod(random, chiVertex, nArray.length, EdgeDirection.IN_AND_OUT_EDGES, new WeightedHopper.EdgeWeightMap(){

                @Override
                public float map(float f) {
                    int n = (int)f;
                    return weightedRating[n];
                }
            });
            for (int i = 0; i < nArray.length; ++i) {
                intDrunkardContext.forwardWalkTo(nArray[i], chiVertex.edge(nArray2[i]).getVertexId(), chiVertex.numOutEdges() > 0);
            }
        }

        @Override
        public int[] getNotTrackedVertices(ChiVertex<Integer, Float> chiVertex) {
            int[] nArray = new int[1 + chiVertex.numOutEdges()];
            for (int i = 0; i < chiVertex.numOutEdges(); ++i) {
                nArray[i + 1] = chiVertex.getOutEdgeId(i);
            }
            nArray[0] = chiVertex.getId();
            return nArray;
        }
    }
}

