/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.graphchi.apps.util;

import edu.cmu.graphchi.ChiFilenames;
import edu.cmu.graphchi.ChiLogger;
import edu.cmu.graphchi.ChiVertex;
import edu.cmu.graphchi.GraphChiContext;
import edu.cmu.graphchi.GraphChiProgram;
import edu.cmu.graphchi.engine.GraphChiEngine;
import edu.cmu.graphchi.engine.VertexInterval;
import edu.cmu.graphchi.preprocessing.FastSharder;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.logging.Logger;

public class CreateCassovary
implements GraphChiProgram<Integer, Integer> {
    private static Logger logger = ChiLogger.getLogger("cassovaryconv");
    private BufferedOutputStream bos;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void update(ChiVertex<Integer, Integer> chiVertex, GraphChiContext graphChiContext) {
        block6: {
            try {
                if (chiVertex.numOutEdges() <= 0) break block6;
                CreateCassovary createCassovary = this;
                synchronized (createCassovary) {
                    this.bos.write((graphChiContext.getVertexIdTranslate().backward(chiVertex.getId()) + " " + chiVertex.numOutEdges() + "\n").getBytes());
                    for (int i = 0; i < chiVertex.numOutEdges(); ++i) {
                        this.bos.write((graphChiContext.getVertexIdTranslate().backward(chiVertex.outEdge(i).getVertexId()) + "\n").getBytes());
                    }
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    @Override
    public void beginIteration(GraphChiContext graphChiContext) {
    }

    @Override
    public void endIteration(GraphChiContext graphChiContext) {
    }

    @Override
    public void beginInterval(GraphChiContext graphChiContext, VertexInterval vertexInterval) {
    }

    @Override
    public void endInterval(GraphChiContext graphChiContext, VertexInterval vertexInterval) {
    }

    @Override
    public void beginSubInterval(GraphChiContext graphChiContext, VertexInterval vertexInterval) {
    }

    @Override
    public void endSubInterval(GraphChiContext graphChiContext, VertexInterval vertexInterval) {
    }

    protected static FastSharder createSharder(String string, int n) throws IOException {
        return new FastSharder(string, n, null, null, null, null);
    }

    public static void main(String[] stringArray) throws Exception {
        String string = stringArray[0];
        int n = Integer.parseInt(stringArray[1]);
        String string2 = stringArray.length >= 3 ? stringArray[2] : null;
        FastSharder fastSharder = CreateCassovary.createSharder(string, n);
        if (string.equals("pipein")) {
            fastSharder.shard(System.in, string2);
        } else if (!new File(ChiFilenames.getFilenameIntervals(string, n)).exists()) {
            fastSharder.shard((InputStream)new FileInputStream(new File(string)), string2);
        } else {
            logger.info("Found shards -- no need to preprocess");
        }
        GraphChiEngine graphChiEngine = new GraphChiEngine(string, n);
        graphChiEngine.setEdataConverter(null);
        graphChiEngine.setVertexDataConverter(null);
        graphChiEngine.setModifiesInedges(false);
        graphChiEngine.setDisableInedges(true);
        graphChiEngine.setModifiesOutedges(false);
        graphChiEngine.setOnlyAdjacency(true);
        CreateCassovary createCassovary = new CreateCassovary();
        createCassovary.bos = new BufferedOutputStream(new FileOutputStream(string + ".cassovary"));
        graphChiEngine.run(createCassovary, 1);
        createCassovary.bos.flush();
        createCassovary.bos.close();
        logger.info("Ready.");
    }
}

