/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.graphchi.datablocks;

import edu.cmu.graphchi.datablocks.BytesToValueConverter;

public class FloatConverter
implements BytesToValueConverter<Float> {
    @Override
    public int sizeOf() {
        return 4;
    }

    @Override
    public Float getValue(byte[] byArray) {
        int n = ((byArray[3] & 0xFF) << 24) + ((byArray[2] & 0xFF) << 16) + ((byArray[1] & 0xFF) << 8) + (byArray[0] & 0xFF);
        return Float.valueOf(Float.intBitsToFloat(n));
    }

    @Override
    public void setValue(byte[] byArray, Float f) {
        int n = Float.floatToIntBits(f.floatValue());
        byArray[3] = (byte)(n >>> 24 & 0xFF);
        byArray[2] = (byte)(n >>> 16 & 0xFF);
        byArray[1] = (byte)(n >>> 8 & 0xFF);
        byArray[0] = (byte)(n >>> 0 & 0xFF);
    }
}

