/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.graphchi.datablocks;

import edu.cmu.graphchi.datablocks.BytesToValueConverter;
import edu.cmu.graphchi.datablocks.FloatPair;

public class FloatPairConverter
implements BytesToValueConverter<FloatPair> {
    @Override
    public int sizeOf() {
        return 8;
    }

    @Override
    public FloatPair getValue(byte[] byArray) {
        int n = ((byArray[3] & 0xFF) << 24) + ((byArray[2] & 0xFF) << 16) + ((byArray[1] & 0xFF) << 8) + (byArray[0] & 0xFF);
        int n2 = ((byArray[7] & 0xFF) << 24) + ((byArray[6] & 0xFF) << 16) + ((byArray[5] & 0xFF) << 8) + (byArray[4] & 0xFF);
        return new FloatPair(Float.intBitsToFloat(n), Float.intBitsToFloat(n2));
    }

    @Override
    public void setValue(byte[] byArray, FloatPair floatPair) {
        int n = Float.floatToIntBits(floatPair.first);
        byArray[3] = (byte)(n >>> 24 & 0xFF);
        byArray[2] = (byte)(n >>> 16 & 0xFF);
        byArray[1] = (byte)(n >>> 8 & 0xFF);
        byArray[0] = (byte)(n >>> 0 & 0xFF);
        int n2 = Float.floatToIntBits(floatPair.second);
        byArray[7] = (byte)(n2 >>> 24 & 0xFF);
        byArray[6] = (byte)(n2 >>> 16 & 0xFF);
        byArray[5] = (byte)(n2 >>> 8 & 0xFF);
        byArray[4] = (byte)(n2 >>> 0 & 0xFF);
    }
}

