/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.graphchi.engine;

import edu.cmu.graphchi.ChiVertex;
import edu.cmu.graphchi.Scheduler;
import java.util.BitSet;

public class BitsetScheduler
implements Scheduler {
    private int nvertices;
    private BitSet bitset;
    private boolean hasNewTasks;

    public BitsetScheduler(int n) {
        this.nvertices = n;
        this.bitset = new BitSet(n);
    }

    @Override
    public void addTask(int n) {
        this.bitset.set(n, true);
        this.hasNewTasks = true;
    }

    @Override
    public void removeTasks(int n, int n2) {
        for (int i = n; i <= n2; ++i) {
            this.bitset.set(i, false);
        }
    }

    @Override
    public void addAllTasks() {
        this.hasNewTasks = true;
        this.bitset.set(0, this.bitset.size(), true);
    }

    @Override
    public boolean hasTasks() {
        return this.hasNewTasks;
    }

    @Override
    public boolean isScheduled(int n) {
        return this.bitset.get(n);
    }

    @Override
    public void removeAllTasks() {
        this.bitset.clear();
        this.hasNewTasks = false;
    }

    @Override
    public void scheduleOutNeighbors(ChiVertex chiVertex) {
        int n = chiVertex.numOutEdges();
        for (int i = 0; i < n; ++i) {
            this.addTask(chiVertex.outEdge(i).getVertexId());
        }
    }

    @Override
    public void scheduleInNeighbors(ChiVertex chiVertex) {
        int n = chiVertex.numInEdges();
        for (int i = 0; i < n; ++i) {
            this.addTask(chiVertex.inEdge(i).getVertexId());
        }
    }

    public void reset() {
        this.hasNewTasks = false;
    }
}

