/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.graphchi.engine;

import com.yammer.metrics.Metrics;
import com.yammer.metrics.core.Timer;
import com.yammer.metrics.core.TimerContext;
import edu.cmu.graphchi.ChiFilenames;
import edu.cmu.graphchi.ChiLogger;
import edu.cmu.graphchi.ChiVertex;
import edu.cmu.graphchi.GraphChiContext;
import edu.cmu.graphchi.GraphChiProgram;
import edu.cmu.graphchi.Scheduler;
import edu.cmu.graphchi.datablocks.BytesToValueConverter;
import edu.cmu.graphchi.datablocks.DataBlockManager;
import edu.cmu.graphchi.engine.BitsetScheduler;
import edu.cmu.graphchi.engine.NoEdgesInIntervalException;
import edu.cmu.graphchi.engine.VertexInterval;
import edu.cmu.graphchi.engine.auxdata.DegreeData;
import edu.cmu.graphchi.engine.auxdata.VertexData;
import edu.cmu.graphchi.engine.auxdata.VertexDegree;
import edu.cmu.graphchi.hadoop.PigGraphChiBase;
import edu.cmu.graphchi.preprocessing.VertexIdTranslate;
import edu.cmu.graphchi.shards.MemoryShard;
import edu.cmu.graphchi.shards.SlidingShard;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.FutureTask;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Logger;

public class GraphChiEngine<VertexDataType, EdgeDataType> {
    protected String baseFilename;
    protected int nShards;
    protected ArrayList<VertexInterval> intervals;
    protected ArrayList<SlidingShard<EdgeDataType>> slidingShards;
    protected BytesToValueConverter<EdgeDataType> edataConverter;
    protected BytesToValueConverter<VertexDataType> vertexDataConverter;
    protected GraphChiContextInternal chiContext = new GraphChiContextInternal();
    private DataBlockManager blockManager;
    private ExecutorService parallelExecutor;
    private ExecutorService loadingExecutor;
    private DegreeData degreeHandler;
    private VertexData<VertexDataType> vertexDataHandler;
    protected int subIntervalStart;
    protected int subIntervalEnd;
    protected int maxWindow = 20000000;
    protected boolean enableScheduler = false;
    protected boolean onlyAdjacency = false;
    protected BitsetScheduler scheduler = null;
    protected long nupdates = 0L;
    protected boolean enableDeterministicExecution = true;
    private boolean useStaticWindowSize = false;
    protected long memBudget;
    protected VertexIdTranslate vertexIdTranslate;
    protected boolean hasSetVertexDataConverter = false;
    protected boolean hasSetEdgeDataConverter = false;
    private static final Logger logger = ChiLogger.getLogger("engine");
    private boolean autoLoadNext = false;
    private boolean skipZeroDegreeVertices = false;
    private FutureTask<IntervalData> nextWindow;
    private final Timer loadTimer = Metrics.defaultRegistry().newTimer(GraphChiEngine.class, "shard-loading", TimeUnit.SECONDS, TimeUnit.MINUTES);
    private final Timer executionTimer = Metrics.defaultRegistry().newTimer(GraphChiEngine.class, "execute-updates", TimeUnit.SECONDS, TimeUnit.MINUTES);
    private final Timer waitForFutureTimer = Metrics.defaultRegistry().newTimer(GraphChiEngine.class, "wait-for-future", TimeUnit.SECONDS, TimeUnit.MINUTES);
    private final Timer initVerticesTimer = Metrics.defaultRegistry().newTimer(GraphChiEngine.class, "init-vertices", TimeUnit.SECONDS, TimeUnit.MINUTES);
    private final Timer determineNextWindowTimer = Metrics.defaultRegistry().newTimer(GraphChiEngine.class, "det-next-window", TimeUnit.SECONDS, TimeUnit.MINUTES);
    protected boolean modifiesInedges = true;
    protected boolean modifiesOutedges = true;
    private boolean disableInEdges = false;
    private boolean disableOutEdges = false;

    public GraphChiEngine(String string, int n) throws FileNotFoundException, IOException {
        this.baseFilename = string;
        this.nShards = n;
        this.loadIntervals();
        this.blockManager = new DataBlockManager();
        this.degreeHandler = new DegreeData(string);
        File file = new File(ChiFilenames.getVertexTranslateDefFile(string, n));
        this.vertexIdTranslate = file.exists() ? VertexIdTranslate.fromFile(file) : VertexIdTranslate.identity();
        this.chiContext.setVertexIdTranslate(this.vertexIdTranslate);
        this.memBudget = Runtime.getRuntime().maxMemory() / 4L;
        if (Runtime.getRuntime().maxMemory() < 0x10000000L) {
            throw new IllegalArgumentException("Java Virtual Machine has only " + this.memBudget + "bytes maximum memory." + " Please run the JVM with at least 256 megabytes of memory using -Xmx256m. For better performance, use higher value");
        }
    }

    public ArrayList<VertexInterval> getIntervals() {
        return this.intervals;
    }

    protected void loadIntervals() throws FileNotFoundException, IOException {
        this.intervals = ChiFilenames.loadIntervals(this.baseFilename, this.nShards);
    }

    public void setMemoryBudgetMb(long l) {
        this.memBudget = l * 1024L * 1024L;
    }

    public long getMemoryBudget() {
        return this.memBudget;
    }

    public void setSkipZeroDegreeVertices(boolean bl) {
        this.skipZeroDegreeVertices = bl;
    }

    public int numVertices() {
        return 1 + this.intervals.get(this.intervals.size() - 1).getLastVertex();
    }

    protected void initializeSlidingShards() throws IOException {
        this.slidingShards = new ArrayList();
        for (int i = 0; i < this.nShards; ++i) {
            String string = this.onlyAdjacency ? null : ChiFilenames.getFilenameShardEdata(this.baseFilename, this.edataConverter, i, this.nShards);
            String string2 = ChiFilenames.getFilenameShardsAdj(this.baseFilename, i, this.nShards);
            SlidingShard<EdgeDataType> slidingShard = new SlidingShard<EdgeDataType>(string, string2, this.intervals.get(i).getFirstVertex(), this.intervals.get(i).getLastVertex());
            slidingShard.setConverter(this.edataConverter);
            slidingShard.setDataBlockManager(this.blockManager);
            slidingShard.setModifiesOutedges(this.modifiesOutedges);
            slidingShard.setOnlyAdjacency(this.onlyAdjacency);
            this.slidingShards.add(slidingShard);
        }
    }

    protected MemoryShard<EdgeDataType> createMemoryShard(int n, int n2, int n3) {
        String string = this.onlyAdjacency ? null : ChiFilenames.getFilenameShardEdata(this.baseFilename, this.edataConverter, n3, this.nShards);
        String string2 = ChiFilenames.getFilenameShardsAdj(this.baseFilename, n3, this.nShards);
        MemoryShard<EdgeDataType> memoryShard = new MemoryShard<EdgeDataType>(string, string2, this.intervals.get(n3).getFirstVertex(), this.intervals.get(n3).getLastVertex());
        memoryShard.setConverter(this.edataConverter);
        memoryShard.setDataBlockManager(this.blockManager);
        memoryShard.setOnlyAdjacency(this.onlyAdjacency);
        return memoryShard;
    }

    public void run(GraphChiProgram<VertexDataType, EdgeDataType> graphChiProgram, int n) throws IOException {
        if (!this.hasSetEdgeDataConverter) {
            throw new IllegalStateException("You need to call setEdataConverter() prior to calling run()!");
        }
        if (!this.hasSetVertexDataConverter) {
            throw new IllegalStateException("You need to call setVertexDataConverter() prior to calling run()!");
        }
        int n2 = 4;
        if (Runtime.getRuntime().availableProcessors() > n2) {
            n2 = Runtime.getRuntime().availableProcessors();
        }
        if (System.getProperty("num_threads") != null) {
            n2 = Integer.parseInt(System.getProperty("num_threads"));
        }
        logger.info(":::::::: Using " + n2 + " execution threads :::::::::");
        this.parallelExecutor = Executors.newFixedThreadPool(n2);
        this.loadingExecutor = Executors.newFixedThreadPool(4);
        this.chiContext.setNumIterations(n);
        long l = System.currentTimeMillis();
        this.initializeSlidingShards();
        if (this.enableScheduler) {
            this.initializeScheduler();
            this.chiContext.setScheduler(this.scheduler);
            this.scheduler.addAllTasks();
            logger.info("Using scheduler!");
        } else {
            this.chiContext.setScheduler(new MockScheduler());
        }
        if (this.disableInEdges) {
            ChiVertex.disableInedges = true;
        }
        if (this.disableOutEdges) {
            ChiVertex.disableOutedges = true;
        }
        if (this.vertexDataConverter != null) {
            this.vertexDataHandler = new VertexData<VertexDataType>(this.numVertices(), this.baseFilename, this.vertexDataConverter, true);
            this.vertexDataHandler.setBlockManager(this.blockManager);
        }
        this.chiContext.setNumEdges(this.numEdges());
        for (int i = 0; i < n; ++i) {
            while (!this.blockManager.empty()) {
                try {
                    Thread.sleep(50L);
                }
                catch (InterruptedException interruptedException) {}
            }
            this.blockManager.reset();
            this.chiContext.setIteration(i);
            this.chiContext.setNumVertices(this.numVertices());
            graphChiProgram.beginIteration(this.chiContext);
            if (this.scheduler != null) {
                if (i > 0 && !this.scheduler.hasTasks()) {
                    logger.info("No new tasks to run. Terminating.");
                    break;
                }
                this.scheduler.reset();
            }
            for (int j = 0; j < this.nShards; ++j) {
                int n3 = this.intervals.get(j).getFirstVertex();
                int n4 = this.intervals.get(j).getLastVertex();
                logger.info((double)(System.currentTimeMillis() - l) * 0.001 + "s: iteration: " + i + ", interval: " + n3 + " -- " + n4);
                if (graphChiProgram instanceof PigGraphChiBase) {
                    ((PigGraphChiBase)((Object)graphChiProgram)).setStatusString("GraphChi iteration " + i + " / " + (n - 1) + ";" + "  vertex interval:" + n3 + " -- " + n4);
                }
                graphChiProgram.beginInterval(this.chiContext, this.intervals.get(j));
                MemoryShard<EdgeDataType> memoryShard = null;
                if (!this.disableInEdges) {
                    if (!this.onlyAdjacency || !this.autoLoadNext || this.nextWindow == null) {
                        if (!this.disableOutEdges) {
                            this.slidingShards.get(j).flush();
                        }
                        memoryShard = this.createMemoryShard(n3, n4, j);
                    } else {
                        memoryShard = null;
                    }
                }
                this.subIntervalStart = n3;
                while (this.subIntervalStart <= n4) {
                    int n5 = this.maxWindow;
                    if (Integer.MAX_VALUE - this.subIntervalStart < this.maxWindow) {
                        n5 = Integer.MAX_VALUE - this.subIntervalStart - 1;
                    }
                    if (this.anyVertexScheduled(this.subIntervalStart, Math.min(n4, this.subIntervalStart + n5))) {
                        ChiVertex[] chiVertexArray = null;
                        int n6 = -1;
                        if (!this.autoLoadNext || this.nextWindow == null) {
                            try {
                                this.subIntervalEnd = this.determineNextWindow(this.subIntervalStart, Math.min(n4, this.subIntervalStart + n5));
                            }
                            catch (NoEdgesInIntervalException noEdgesInIntervalException) {
                                logger.info("No edges, skip: " + this.subIntervalStart + " -- " + this.subIntervalEnd);
                                this.subIntervalEnd = this.subIntervalStart + n5;
                                this.subIntervalStart = this.subIntervalEnd + 1;
                                continue;
                            }
                            int n7 = this.subIntervalEnd - this.subIntervalStart + 1;
                            logger.info("Subinterval:: " + this.subIntervalStart + " -- " + this.subIntervalEnd + " (iteration " + i + ")");
                            chiVertexArray = new ChiVertex[n7];
                            logger.info("Init vertices...");
                            n6 = this.initVertices(n7, this.subIntervalStart, chiVertexArray);
                            logger.info("Loading...");
                            long l2 = System.currentTimeMillis();
                            this.loadBeforeUpdates(j, chiVertexArray, memoryShard, this.subIntervalStart, this.subIntervalEnd);
                            logger.info("Load took: " + (System.currentTimeMillis() - l2) + "ms");
                        } else {
                            try {
                                long l3 = System.currentTimeMillis();
                                TimerContext timerContext = this.waitForFutureTimer.time();
                                IntervalData intervalData = this.nextWindow.get();
                                memoryShard = intervalData.getMemShard();
                                timerContext.stop();
                                logger.info("Waiting for future task loading took " + (System.currentTimeMillis() - l3) + " ms");
                                if (this.subIntervalStart != intervalData.getSubInterval().getFirstVertex()) {
                                    throw new IllegalStateException("Future loaders interval does not match the expected one! " + this.subIntervalStart + " != " + intervalData.getSubInterval().getFirstVertex());
                                }
                                this.subIntervalEnd = intervalData.getSubInterval().getLastVertex();
                                n6 = intervalData.getVertexBlockId();
                                chiVertexArray = intervalData.getVertices();
                                this.nextWindow = null;
                            }
                            catch (Exception exception) {
                                throw new RuntimeException(exception);
                            }
                        }
                        if (this.autoLoadNext) {
                            n5 = this.maxWindow;
                            if (Integer.MAX_VALUE - this.subIntervalEnd < this.maxWindow) {
                                n5 = Integer.MAX_VALUE - this.subIntervalEnd - 1;
                            }
                            if (this.subIntervalEnd + 1 <= n4) {
                                this.nextWindow = new FutureTask<IntervalData>(new AutoLoaderTask(new VertexInterval(this.subIntervalEnd + 1, Math.min(n4, this.subIntervalEnd + 1 + n5)), j, memoryShard));
                            } else if (j < this.nShards - 1) {
                                int n8 = this.intervals.get(j + 1).getFirstVertex();
                                int n9 = this.intervals.get(j + 1).getLastVertex();
                                this.slidingShards.get(j).setOffset(memoryShard.getStreamingOffset(), memoryShard.getStreamingOffsetVid(), memoryShard.getStreamingOffsetEdgePtr());
                                this.nextWindow = new FutureTask<IntervalData>(new AutoLoaderTask(new VertexInterval(n8, Math.min(n9, n8 + 1 + n5)), j + 1, this.createMemoryShard(n8, n9, j + 1)));
                            }
                            if (this.nextWindow != null) {
                                this.loadingExecutor.submit(this.nextWindow);
                            }
                        }
                        if (this.scheduler != null) {
                            this.scheduler.removeTasks(this.subIntervalStart, this.subIntervalEnd);
                        }
                        this.chiContext.setCurInterval(new VertexInterval(this.subIntervalStart, this.subIntervalEnd));
                        graphChiProgram.beginSubInterval(this.chiContext, new VertexInterval(this.subIntervalStart, this.subIntervalEnd));
                        long l4 = System.currentTimeMillis();
                        this.execUpdates(graphChiProgram, chiVertexArray);
                        logger.info("Update exec: " + (System.currentTimeMillis() - l4) + " ms.");
                        final int n10 = this.subIntervalStart;
                        final int n11 = n6;
                        this.parallelExecutor.submit(new Runnable(){

                            @Override
                            public void run() {
                                try {
                                    GraphChiEngine.this.vertexDataHandler.releaseAndCommit(n10, n11);
                                }
                                catch (IOException iOException) {
                                    iOException.printStackTrace();
                                }
                            }
                        });
                        this.subIntervalStart = this.subIntervalEnd + 1;
                        graphChiProgram.endSubInterval(this.chiContext, new VertexInterval(this.subIntervalStart, this.subIntervalEnd));
                        continue;
                    }
                    this.subIntervalEnd = this.subIntervalStart + n5;
                    logger.info("Skipped interval - no vertices scheduled. " + this.subIntervalStart + " -- " + this.subIntervalEnd);
                    this.subIntervalStart = this.subIntervalEnd + 1;
                }
                if (this.disableInEdges) continue;
                memoryShard.commitAndRelease(this.modifiesInedges, this.modifiesOutedges);
                if (this.disableOutEdges || this.autoLoadNext) continue;
                this.slidingShards.get(j).setOffset(memoryShard.getStreamingOffset(), memoryShard.getStreamingOffsetVid(), memoryShard.getStreamingOffsetEdgePtr());
            }
            for (SlidingShard<EdgeDataType> slidingShard : this.slidingShards) {
                slidingShard.flush();
                slidingShard.setOffset(0, 0, 0);
            }
            graphChiProgram.endIteration(this.chiContext);
        }
        this.parallelExecutor.shutdown();
        this.loadingExecutor.shutdown();
        if (this.vertexDataHandler != null) {
            this.vertexDataHandler.close();
        }
        logger.info("Engine finished in: " + (double)(System.currentTimeMillis() - l) * 0.001 + " secs.");
        logger.info("Updates: " + this.nupdates);
    }

    private boolean anyVertexScheduled(int n, int n2) {
        if (!this.enableScheduler) {
            return true;
        }
        for (int i = n; i <= n2; ++i) {
            if (!this.scheduler.isScheduled(i)) continue;
            return true;
        }
        return false;
    }

    private void initializeScheduler() {
        this.scheduler = new BitsetScheduler(this.numVertices());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void execUpdates(final GraphChiProgram<VertexDataType, EdgeDataType> graphChiProgram, final ChiVertex<VertexDataType, EdgeDataType>[] chiVertexArray) {
        if (chiVertexArray == null || chiVertexArray.length == 0) {
            return;
        }
        TimerContext timerContext = this.executionTimer.time();
        if (Runtime.getRuntime().availableProcessors() == 1) {
            for (ChiVertex<VertexDataType, EdgeDataType> chiVertex : chiVertexArray) {
                if (chiVertex == null) continue;
                ++this.nupdates;
                graphChiProgram.update(chiVertex, this.chiContext);
            }
        } else {
            final Object object = new Object();
            int n = 1 + chiVertexArray.length / 64;
            int n2 = chiVertexArray.length / n + 1;
            final AtomicInteger atomicInteger = new AtomicInteger(1 + n2);
            if (!this.enableDeterministicExecution) {
                for (ChiVertex<VertexDataType, EdgeDataType> chiVertex : chiVertexArray) {
                    if (chiVertex == null) continue;
                    chiVertex.parallelSafe = true;
                }
            }
            this.parallelExecutor.submit(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    int n = 0;
                    GraphChiContext graphChiContext = GraphChiEngine.this.chiContext.clone(0);
                    try {
                        for (ChiVertex chiVertex : chiVertexArray) {
                            if (chiVertex == null || chiVertex.parallelSafe) continue;
                            ++n;
                            graphChiProgram.update(chiVertex, graphChiContext);
                        }
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                    finally {
                        int n2 = atomicInteger.decrementAndGet();
                        Object object2 = object;
                        synchronized (object2) {
                            GraphChiEngine.this.nupdates += (long)n;
                            if (n2 == 0) {
                                object.notifyAll();
                            }
                        }
                    }
                }
            });
            int n3 = 0;
            while (n3 < n2) {
                final int n4 = n3++;
                final int n5 = n4 * n;
                final int n6 = n5 + n;
                this.parallelExecutor.submit(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        int n = 0;
                        GraphChiContext graphChiContext = GraphChiEngine.this.chiContext.clone(1 + n4);
                        try {
                            int n2 = n6;
                            if (n2 > chiVertexArray.length) {
                                n2 = chiVertexArray.length;
                            }
                            for (int i = n5; i < n2; ++i) {
                                ChiVertex chiVertex = chiVertexArray[i];
                                if (chiVertex == null || !chiVertex.parallelSafe) continue;
                                ++n;
                                graphChiProgram.update(chiVertex, graphChiContext);
                            }
                        }
                        catch (Exception exception) {
                            exception.printStackTrace();
                        }
                        finally {
                            int n3 = atomicInteger.decrementAndGet();
                            Object object2 = object;
                            synchronized (object2) {
                                GraphChiEngine.this.nupdates += (long)n;
                                if (n3 == 0) {
                                    object.notifyAll();
                                }
                            }
                        }
                    }
                });
            }
            Object object2 = object;
            synchronized (object2) {
                while (atomicInteger.get() > 0) {
                    try {
                        object.wait(1500L);
                    }
                    catch (InterruptedException interruptedException) {
                        interruptedException.printStackTrace();
                    }
                    if (atomicInteger.get() <= 0) continue;
                    logger.info("Waiting for execution to finish: countDown:" + atomicInteger.get());
                }
            }
        }
        timerContext.stop();
    }

    protected int initVertices(int n, int n2, ChiVertex<VertexDataType, EdgeDataType>[] chiVertexArray) throws IOException {
        TimerContext timerContext = this.initVerticesTimer.time();
        ChiVertex.edgeValueConverter = this.edataConverter;
        ChiVertex.vertexValueConverter = this.vertexDataConverter;
        ChiVertex.blockManager = this.blockManager;
        int n3 = this.vertexDataConverter != null ? this.vertexDataHandler.load(n2, n2 + n - 1) : -1;
        for (int i = 0; i < n; ++i) {
            if (this.enableScheduler && !this.scheduler.isScheduled(i + n2)) continue;
            VertexDegree vertexDegree = this.degreeHandler.getDegree(i + n2);
            if (this.skipZeroDegreeVertices && vertexDegree.inDegree + vertexDegree.outDegree == 0) continue;
            ChiVertex chiVertex = new ChiVertex(i + n2, vertexDegree);
            if (this.vertexDataConverter != null) {
                chiVertex.setDataPtr(this.vertexDataHandler.getVertexValuePtr(i + n2, n3));
            }
            chiVertexArray[i] = chiVertex;
        }
        timerContext.stop();
        return n3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadBeforeUpdates(int n, final ChiVertex<VertexDataType, EdgeDataType>[] chiVertexArray, MemoryShard<EdgeDataType> memoryShard, final int n2, int n3) throws IOException {
        final Object object = new Object();
        TimerContext timerContext = this.loadTimer.time();
        Object object2 = object;
        synchronized (object2) {
            AtomicInteger atomicInteger;
            block15: {
                atomicInteger = new AtomicInteger(this.disableOutEdges ? 1 : this.nShards);
                if (!this.disableInEdges) {
                    try {
                        logger.info("Memshard: " + n2 + " -- " + n3);
                        memoryShard.loadVertices(n2, n3, chiVertexArray, this.disableOutEdges, this.parallelExecutor);
                        logger.info("Loading memory-shard finished." + Thread.currentThread().getName());
                        if (atomicInteger.decrementAndGet() != 0) break block15;
                        Object object3 = object;
                        synchronized (object3) {
                            object.notifyAll();
                        }
                    }
                    catch (IOException iOException) {
                        iOException.printStackTrace();
                        throw new RuntimeException(iOException);
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                }
            }
            if (!this.disableOutEdges) {
                for (int i = 0; i < this.nShards; ++i) {
                    if (i == n && !this.disableInEdges) continue;
                    int n4 = i;
                    final SlidingShard<EdgeDataType> slidingShard = this.slidingShards.get(i);
                    this.loadingExecutor.submit(new Runnable(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public void run() {
                            block6: {
                                try {
                                    slidingShard.readNextVertices(chiVertexArray, n2, false);
                                    if (atomicInteger.decrementAndGet() != 0) break block6;
                                    Object object2 = object;
                                    synchronized (object2) {
                                        object.notifyAll();
                                    }
                                }
                                catch (IOException iOException) {
                                    iOException.printStackTrace();
                                    throw new RuntimeException(iOException);
                                }
                                catch (Exception exception) {
                                    exception.printStackTrace();
                                }
                            }
                        }
                    });
                }
            }
            try {
                while (atomicInteger.get() > 0) {
                    object.wait(5000L);
                    if (atomicInteger.get() <= 0) continue;
                    logger.info("Still waiting for loading, counter is: " + atomicInteger.get());
                }
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
            }
        }
        timerContext.stop();
    }

    public GraphChiContext getContext() {
        return this.chiContext;
    }

    public long numEdges() {
        long l = 0L;
        for (SlidingShard<EdgeDataType> slidingShard : this.slidingShards) {
            l += slidingShard.getNumEdges();
        }
        return l;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int determineNextWindow(int n, int n2) throws IOException, NoEdgesInIntervalException {
        TimerContext timerContext = this.determineNextWindowTimer.time();
        long l = 0L;
        try {
            int n3;
            this.degreeHandler.load(n, n2);
            if (this.useStaticWindowSize) {
                int n4 = n2;
                return n4;
            }
            long l2 = 0L;
            int n5 = n2 - n;
            int n6 = this.vertexDataConverter != null ? this.vertexDataConverter.sizeOf() : 0;
            int n7 = this.onlyAdjacency ? 0 : this.edataConverter.sizeOf();
            logger.info("Memory budget: " + this.memBudget);
            for (n3 = 0; n3 < n5; ++n3) {
                if (this.enableScheduler && !this.scheduler.isScheduled(n3 + n)) continue;
                VertexDegree vertexDegree = this.degreeHandler.getDegree(n3 + n);
                int n8 = vertexDegree.inDegree;
                int n9 = vertexDegree.outDegree;
                if (n8 + n9 == 0 && this.skipZeroDegreeVertices) continue;
                l += (long)(n8 + n9);
                if ((l2 += (long)(n6 + 256 + (n7 + 4 + 4 + 4) * (n8 + n9))) <= this.memBudget) continue;
                if (l == 0L && this.vertexDataConverter == null) {
                    throw new NoEdgesInIntervalException();
                }
                int n10 = n + n3 - 1;
                return n10;
            }
            if (l == 0L && this.vertexDataConverter == null) {
                throw new NoEdgesInIntervalException();
            }
            n3 = n2;
            return n3;
        }
        finally {
            timerContext.stop();
        }
    }

    public boolean isEnableScheduler() {
        return this.enableScheduler;
    }

    public void setEnableScheduler(boolean bl) {
        this.enableScheduler = bl;
    }

    public void setVertexDataConverter(BytesToValueConverter<VertexDataType> bytesToValueConverter) {
        this.vertexDataConverter = bytesToValueConverter;
        this.hasSetVertexDataConverter = true;
    }

    public void setEdataConverter(BytesToValueConverter<EdgeDataType> bytesToValueConverter) {
        this.edataConverter = bytesToValueConverter;
        this.hasSetEdgeDataConverter = true;
    }

    public boolean isEnableDeterministicExecution() {
        return this.enableDeterministicExecution;
    }

    public void setEnableDeterministicExecution(boolean bl) {
        this.enableDeterministicExecution = bl;
    }

    public boolean isDisableOutEdges() {
        return this.disableOutEdges;
    }

    public void setDisableOutEdges(boolean bl) {
        this.disableOutEdges = bl;
    }

    public boolean isModifiesInedges() {
        return this.modifiesInedges;
    }

    public void setModifiesInedges(boolean bl) {
        this.modifiesInedges = bl;
    }

    public boolean isModifiesOutedges() {
        return this.modifiesOutedges;
    }

    public void setModifiesOutedges(boolean bl) {
        this.modifiesOutedges = bl;
    }

    public boolean isOnlyAdjacency() {
        return this.onlyAdjacency;
    }

    public void setOnlyAdjacency(boolean bl) {
        this.onlyAdjacency = bl;
        this.hasSetEdgeDataConverter = true;
    }

    public void setDisableInedges(boolean bl) {
        this.disableInEdges = bl;
    }

    public boolean isDisableInEdges() {
        return this.disableInEdges;
    }

    public int getMaxWindow() {
        return this.maxWindow;
    }

    public void setMaxWindow(int n) {
        this.maxWindow = n;
    }

    public boolean isUseStaticWindowSize() {
        return this.useStaticWindowSize;
    }

    public void setUseStaticWindowSize(boolean bl) {
        this.useStaticWindowSize = bl;
    }

    public boolean isAutoLoadNext() {
        return this.autoLoadNext;
    }

    public void setAutoLoadNext(boolean bl) {
        this.autoLoadNext = bl;
    }

    public VertexIdTranslate getVertexIdTranslate() {
        return this.vertexIdTranslate;
    }

    public void setVertexIdTranslate(VertexIdTranslate vertexIdTranslate) {
        this.vertexIdTranslate = vertexIdTranslate;
    }

    private class GraphChiContextInternal
    extends GraphChiContext {
        private GraphChiContextInternal() {
        }

        @Override
        protected void setVertexIdTranslate(VertexIdTranslate vertexIdTranslate) {
            super.setVertexIdTranslate(vertexIdTranslate);
        }

        @Override
        public void setThreadLocal(Object object) {
            super.setThreadLocal(object);
        }

        @Override
        protected void setNumVertices(long l) {
            super.setNumVertices(l);
        }

        @Override
        protected void setNumEdges(long l) {
            super.setNumEdges(l);
        }

        @Override
        protected void setScheduler(Scheduler scheduler) {
            super.setScheduler(scheduler);
        }

        @Override
        protected void setNumIterations(int n) {
            super.setNumIterations(n);
        }

        @Override
        protected void setIteration(int n) {
            super.setIteration(n);
        }

        @Override
        protected void setCurInterval(VertexInterval vertexInterval) {
            super.setCurInterval(vertexInterval);
        }
    }

    private class MockScheduler
    implements Scheduler {
        private MockScheduler() {
        }

        @Override
        public void addTask(int n) {
        }

        @Override
        public void removeTasks(int n, int n2) {
        }

        @Override
        public void addAllTasks() {
        }

        @Override
        public boolean hasTasks() {
            return true;
        }

        @Override
        public boolean isScheduled(int n) {
            return true;
        }

        @Override
        public void removeAllTasks() {
        }

        @Override
        public void scheduleOutNeighbors(ChiVertex chiVertex) {
        }

        @Override
        public void scheduleInNeighbors(ChiVertex chiVertex) {
        }
    }

    class AutoLoaderTask
    implements Callable<IntervalData> {
        private ChiVertex<VertexDataType, EdgeDataType>[] vertices;
        private VertexInterval interval;
        private MemoryShard<EdgeDataType> memShard;
        private int intervalNum;

        AutoLoaderTask(VertexInterval vertexInterval, int n, MemoryShard<EdgeDataType> memoryShard) {
            this.interval = vertexInterval;
            this.memShard = memoryShard;
            this.intervalNum = n;
            if (!GraphChiEngine.this.onlyAdjacency) {
                throw new RuntimeException("Can use auto-loading only with only-adjacency mode!");
            }
        }

        @Override
        public IntervalData call() {
            try {
                int n = GraphChiEngine.this.determineNextWindow(this.interval.getFirstVertex(), this.interval.getLastVertex());
                int n2 = n - this.interval.getFirstVertex() + 1;
                this.vertices = new ChiVertex[n2];
                int n3 = GraphChiEngine.this.initVertices(n2, this.interval.getFirstVertex(), this.vertices);
                GraphChiEngine.this.loadBeforeUpdates(this.intervalNum, this.vertices, this.memShard, this.interval.getFirstVertex(), n);
                return new IntervalData(new VertexInterval(this.interval.getFirstVertex(), n), this.vertices, n3, this.memShard, this.intervalNum);
            }
            catch (NoEdgesInIntervalException noEdgesInIntervalException) {
                return new IntervalData(new VertexInterval(this.interval.getFirstVertex(), this.interval.getLastVertex()), this.vertices, -1, this.memShard, this.intervalNum);
            }
            catch (Exception exception) {
                exception.printStackTrace();
                return null;
            }
        }
    }

    class IntervalData {
        private VertexInterval subInterval;
        private ChiVertex<VertexDataType, EdgeDataType>[] vertices;
        private int vertexBlockId;
        private MemoryShard<EdgeDataType> memShard;
        private int intervalNum;

        IntervalData(VertexInterval vertexInterval, ChiVertex<VertexDataType, EdgeDataType>[] chiVertexArray, int n, MemoryShard<EdgeDataType> memoryShard, int n2) {
            this.subInterval = vertexInterval;
            this.vertices = chiVertexArray;
            this.vertexBlockId = n;
            this.intervalNum = n2;
            this.memShard = memoryShard;
        }

        public VertexInterval getSubInterval() {
            return this.subInterval;
        }

        public ChiVertex<VertexDataType, EdgeDataType>[] getVertices() {
            return this.vertices;
        }

        public int getVertexBlockId() {
            return this.vertexBlockId;
        }

        public MemoryShard<EdgeDataType> getMemShard() {
            return this.memShard;
        }

        public int getIntervalNum() {
            return this.intervalNum;
        }
    }
}

