/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.graphchi.engine.auxdata;

import edu.cmu.graphchi.ChiFilenames;
import edu.cmu.graphchi.ChiLogger;
import edu.cmu.graphchi.engine.auxdata.VertexDegree;
import java.io.EOFException;
import java.io.File;
import java.io.IOException;
import ucar.unidata.io.RandomAccessFile;

public class DegreeData {
    private RandomAccessFile degreeFile;
    private byte[] degreeData;
    private int vertexSt;
    private int vertexEn;
    private boolean sparse = false;
    private int lastQuery = 0;
    private int lastId = -1;

    public DegreeData(String string) throws IOException {
        File file = new File(ChiFilenames.getFilenameOfDegreeData(string, true));
        File file2 = new File(ChiFilenames.getFilenameOfDegreeData(string, false));
        if (file.exists()) {
            this.sparse = true;
            this.degreeFile = new RandomAccessFile(file.getAbsolutePath(), "r");
        } else {
            this.sparse = false;
            this.degreeFile = new RandomAccessFile(file2.getAbsolutePath(), "r");
        }
        this.vertexSt = 0;
        this.vertexEn = 0;
    }

    public void load(int n, int n2) throws IOException {
        int n3 = this.vertexEn;
        int n4 = this.vertexSt;
        this.vertexSt = n;
        this.vertexEn = n2;
        long l = (long)(this.vertexEn - this.vertexSt + 1) * 4L * 2L;
        byte[] byArray = this.degreeData;
        this.degreeData = new byte[(int)l];
        int n5 = 0;
        if (n3 > n && n4 <= n) {
            n5 = (n3 - this.vertexSt + 1) * 8;
            System.arraycopy(byArray, byArray.length - n5, this.degreeData, 0, n5);
        }
        if (!this.sparse) {
            int n6 = (int)(l - (long)n5);
            if (n6 == 0) {
                return;
            }
            long l2 = (long)this.vertexSt * 4L * 2L + (long)n5;
            try {
                this.degreeFile.seek(l2);
                this.degreeFile.readFully(this.degreeData, (int)(l - (long)n6), n6);
            }
            catch (EOFException eOFException) {
                ChiLogger.getLogger("engine").info("Error: Tried to read past file: " + l2 + " --- " + (l2 + l));
            }
        } else {
            if (this.lastQuery > n) {
                this.lastId = -1;
                this.degreeFile.seek(0L);
            }
            try {
                while (true) {
                    int n7;
                    int n8 = n7 = this.lastId < 0 ? this.degreeFile.readInt() : this.lastId;
                    if (n7 >= n && n7 <= n2) {
                        this.degreeFile.readFully(this.degreeData, (n7 - this.vertexSt) * 8, 8);
                        VertexDegree vertexDegree = this.getDegree(n7);
                        this.lastId = -1;
                        continue;
                    }
                    if (n7 > this.vertexEn) {
                        this.lastId = n7;
                        break;
                    }
                    this.degreeFile.skipBytes(8);
                }
            }
            catch (EOFException eOFException) {
                this.degreeFile.seek(0L);
            }
            this.lastQuery = n2;
        }
    }

    public VertexDegree getDegree(int n) {
        assert (n >= this.vertexSt && n <= this.vertexEn);
        byte[] byArray = new byte[4];
        int n2 = n - this.vertexSt;
        System.arraycopy(this.degreeData, n2 * 8, byArray, 0, 4);
        int n3 = ((byArray[3] & 0xFF) << 24) + ((byArray[2] & 0xFF) << 16) + ((byArray[1] & 0xFF) << 8) + (byArray[0] & 0xFF);
        System.arraycopy(this.degreeData, n2 * 8 + 4, byArray, 0, 4);
        int n4 = ((byArray[3] & 0xFF) << 24) + ((byArray[2] & 0xFF) << 16) + ((byArray[1] & 0xFF) << 8) + (byArray[0] & 0xFF);
        return new VertexDegree(n3, n4);
    }
}

