/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.graphchi.hadoop;

import edu.cmu.graphchi.ChiLogger;
import edu.cmu.graphchi.preprocessing.EdgeProcessor;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;

public class HDFSGraphLoader {
    private EdgeProcessor edgeProcessor;
    private String hdfsLocation;
    private static final Logger logger = ChiLogger.getLogger("hdfs-graph-loader");

    public HDFSGraphLoader(String string, EdgeProcessor edgeProcessor) {
        this.edgeProcessor = edgeProcessor;
        this.hdfsLocation = string;
    }

    public void load(Configuration configuration) throws Exception {
        Path path;
        FileSystem fileSystem = FileSystem.get((Configuration)configuration);
        if (fileSystem.isFile(path = new Path(this.hdfsLocation))) {
            this.processFile(fileSystem, path);
        } else {
            FileStatus[] fileStatusArray;
            for (FileStatus fileStatus : fileStatusArray = fileSystem.listStatus(path)) {
                logger.info("Dir entry: " + fileStatus.toString() + " " + fileStatus.getPath().getName());
                if (!fileStatus.getPath().getName().startsWith("part-")) continue;
                this.processFile(fileSystem, fileStatus.getPath());
            }
        }
    }

    private void processFile(FileSystem fileSystem, Path path) throws IOException {
        String string;
        logger.info("Process: " + path);
        FSDataInputStream fSDataInputStream = fileSystem.open(path);
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader((InputStream)fSDataInputStream));
        Pattern pattern = Pattern.compile("(\t)+|( )+|(,)+");
        while ((string = bufferedReader.readLine()) != null) {
            String[] stringArray;
            if (string.startsWith("#") || (stringArray = pattern.split(string)).length < 2) continue;
            try {
                int n = Integer.parseInt(stringArray[0]);
                int n2 = Integer.parseInt(stringArray[1]);
                this.edgeProcessor.receiveEdge(n, n2, stringArray.length == 3 ? stringArray[2] : null);
            }
            catch (NumberFormatException numberFormatException) {
                logger.warning("Number format exceptions on line: " + string);
                numberFormatException.printStackTrace();
            }
        }
    }
}

