/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.graphchi.io;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.InflaterInputStream;

public class CompressedIO {
    static boolean COMPRESSION_ENABLED = true;

    public static void readCompressed(File file, byte[] byArray, int n) throws FileNotFoundException, IOException {
        if (COMPRESSION_ENABLED) {
            BufferedInputStream bufferedInputStream = new BufferedInputStream(new FileInputStream(file));
            InflaterInputStream inflaterInputStream = new InflaterInputStream(bufferedInputStream);
            for (int i = 0; i < n; i += inflaterInputStream.read(byArray, i, n - i)) {
            }
            inflaterInputStream.close();
            bufferedInputStream.close();
        } else {
            FileInputStream fileInputStream = new FileInputStream(file);
            for (int i = 0; i < n; i += fileInputStream.read(byArray, i, byArray.length - i)) {
            }
            fileInputStream.close();
        }
    }

    public static void writeCompressed(File file, byte[] byArray, int n) throws FileNotFoundException, IOException {
        if (COMPRESSION_ENABLED) {
            BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(file));
            DeflaterOutputStream deflaterOutputStream = new DeflaterOutputStream(bufferedOutputStream);
            deflaterOutputStream.write(byArray, 0, n);
            deflaterOutputStream.close();
            bufferedOutputStream.close();
        } else {
            BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(file));
            bufferedOutputStream.write(byArray, 0, n);
            bufferedOutputStream.close();
        }
    }

    public static void disableCompression() {
        COMPRESSION_ENABLED = false;
    }

    public static boolean isCompressionEnabled() {
        return COMPRESSION_ENABLED;
    }

    static {
        if ("0".equals(System.getProperty("graphchi.compression"))) {
            CompressedIO.disableCompression();
        }
    }
}

