/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.graphchi.preprocessing;

import edu.cmu.graphchi.ChiFilenames;
import edu.cmu.graphchi.ChiLogger;
import edu.cmu.graphchi.ChiVertex;
import edu.cmu.graphchi.datablocks.BytesToValueConverter;
import edu.cmu.graphchi.datablocks.ChiPointer;
import edu.cmu.graphchi.datablocks.DataBlockManager;
import edu.cmu.graphchi.datablocks.IntConverter;
import edu.cmu.graphchi.engine.auxdata.VertexData;
import edu.cmu.graphchi.io.CompressedIO;
import edu.cmu.graphchi.preprocessing.EdgeProcessor;
import edu.cmu.graphchi.preprocessing.VertexIdTranslate;
import edu.cmu.graphchi.preprocessing.VertexProcessor;
import edu.cmu.graphchi.shards.MemoryShard;
import edu.cmu.graphchi.shards.SlidingShard;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.util.Iterator;
import java.util.Random;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.logging.Logger;
import java.util.zip.DeflaterOutputStream;
import nom.tam.util.BufferedDataInputStream;

public class FastSharder<VertexValueType, EdgeValueType> {
    private String baseFilename;
    private int numShards;
    private int initialIntervalLength;
    private VertexIdTranslate preIdTranslate;
    private VertexIdTranslate finalIdTranslate;
    private DataOutputStream[] shovelStreams;
    private DataOutputStream[] vertexShovelStreams;
    private int maxVertexId = 0;
    private int[] inDegrees;
    private int[] outDegrees;
    private boolean memoryEfficientDegreeCount = false;
    private long numEdges = 0L;
    private boolean useSparseDegrees = false;
    private boolean allowSparseDegreesAndVertexData = false;
    private BytesToValueConverter<EdgeValueType> edgeValueTypeBytesToValueConverter;
    private BytesToValueConverter<VertexValueType> vertexValueTypeBytesToValueConverter;
    private EdgeProcessor<EdgeValueType> edgeProcessor;
    private VertexProcessor<VertexValueType> vertexProcessor;
    private static final Logger logger = ChiLogger.getLogger("fast-sharder");
    private byte[] valueTemplate;
    private byte[] vertexValueTemplate;
    private static Random random = new Random();

    public FastSharder(String string, int n, VertexProcessor<VertexValueType> vertexProcessor, EdgeProcessor<EdgeValueType> edgeProcessor, BytesToValueConverter<VertexValueType> bytesToValueConverter, BytesToValueConverter<EdgeValueType> bytesToValueConverter2) throws IOException {
        this.baseFilename = string;
        this.numShards = n;
        this.initialIntervalLength = Integer.MAX_VALUE / n;
        this.preIdTranslate = new VertexIdTranslate(this.initialIntervalLength, n);
        this.edgeProcessor = edgeProcessor;
        this.vertexProcessor = vertexProcessor;
        this.edgeValueTypeBytesToValueConverter = bytesToValueConverter2;
        this.vertexValueTypeBytesToValueConverter = bytesToValueConverter;
        this.shovelStreams = new DataOutputStream[n];
        this.vertexShovelStreams = new DataOutputStream[n];
        for (int i = 0; i < n; ++i) {
            this.shovelStreams[i] = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(this.shovelFilename(i))));
            if (vertexProcessor == null) continue;
            this.vertexShovelStreams[i] = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(this.vertexShovelFileName(i))));
        }
        this.valueTemplate = this.edgeValueTypeBytesToValueConverter != null ? new byte[this.edgeValueTypeBytesToValueConverter.sizeOf()] : new byte[0];
        if (this.vertexValueTypeBytesToValueConverter != null) {
            this.vertexValueTemplate = new byte[this.vertexValueTypeBytesToValueConverter.sizeOf()];
        }
    }

    private String shovelFilename(int n) {
        return this.baseFilename + ".shovel." + n;
    }

    private String vertexShovelFileName(int n) {
        return this.baseFilename + ".vertexshovel." + n;
    }

    public void addEdge(int n, int n2, String string) throws IOException {
        if (this.maxVertexId < n) {
            this.maxVertexId = n;
        }
        if (this.maxVertexId < n2) {
            this.maxVertexId = n2;
        }
        if (n == n2) {
            VertexValueType VertexValueType;
            if (this.vertexProcessor != null && string != null && (VertexValueType = this.vertexProcessor.receiveVertexValue(n, string)) != null) {
                this.addVertexValue(n % this.numShards, this.preIdTranslate.forward(n), VertexValueType);
            }
            return;
        }
        int n3 = this.preIdTranslate.forward(n);
        int n4 = this.preIdTranslate.forward(n2);
        this.addToShovel(n2 % this.numShards, n3, n4, this.edgeProcessor != null ? (EdgeValueType)this.edgeProcessor.receiveEdge(n, n2, string) : null);
    }

    private void addToShovel(int n, int n2, int n3, EdgeValueType EdgeValueType) throws IOException {
        DataOutputStream dataOutputStream = this.shovelStreams[n];
        dataOutputStream.writeLong(FastSharder.packEdges(n2, n3));
        if (this.edgeValueTypeBytesToValueConverter != null) {
            this.edgeValueTypeBytesToValueConverter.setValue(this.valueTemplate, EdgeValueType);
        }
        dataOutputStream.write(this.valueTemplate);
    }

    public boolean isAllowSparseDegreesAndVertexData() {
        return this.allowSparseDegreesAndVertexData;
    }

    public void setAllowSparseDegreesAndVertexData(boolean bl) {
        this.allowSparseDegreesAndVertexData = bl;
    }

    private void addVertexValue(int n, int n2, VertexValueType VertexValueType) throws IOException {
        DataOutputStream dataOutputStream = this.vertexShovelStreams[n];
        dataOutputStream.writeInt(n2);
        this.vertexValueTypeBytesToValueConverter.setValue(this.vertexValueTemplate, VertexValueType);
        dataOutputStream.write(this.vertexValueTemplate);
    }

    static long packEdges(int n, int n2) {
        return ((long)n << 32) + (long)n2;
    }

    static int getFirst(long l) {
        return (int)(l >> 32);
    }

    static int getSecond(long l) {
        return (int)(l & 0xFFFFFFFFL);
    }

    public void process() throws IOException {
        int n;
        boolean bl = this.memoryEfficientDegreeCount = Runtime.getRuntime().maxMemory() / 5L < (long)this.maxVertexId * 8L;
        if (this.memoryEfficientDegreeCount) {
            logger.info("Going to use memory-efficient, but slower, method to compute vertex degrees.");
        }
        if (!this.memoryEfficientDegreeCount) {
            this.inDegrees = new int[this.maxVertexId + this.numShards];
            this.outDegrees = new int[this.maxVertexId + this.numShards];
        }
        this.finalIdTranslate = new VertexIdTranslate((1 + this.maxVertexId) / this.numShards + 1, this.numShards);
        this.saveVertexTranslate();
        for (n = 0; n < this.numShards; ++n) {
            this.shovelStreams[n].close();
        }
        this.shovelStreams = null;
        this.writeIntervals();
        for (n = 0; n < this.numShards; ++n) {
            this.processShovel(n);
        }
        this.useSparseDegrees = this.allowSparseDegreesAndVertexData ? (long)this.maxVertexId > this.numEdges || "1".equals(System.getProperty("sparsedeg")) : false;
        logger.info("Use sparse output: " + this.useSparseDegrees);
        if (!this.memoryEfficientDegreeCount) {
            this.writeDegrees();
        } else {
            this.computeVertexDegrees();
        }
        if (this.vertexProcessor != null) {
            this.processVertexValues(this.useSparseDegrees);
        }
    }

    private void writeDegrees() throws IOException {
        DataOutputStream dataOutputStream = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(ChiFilenames.getFilenameOfDegreeData(this.baseFilename, this.useSparseDegrees))));
        for (int i = 0; i < this.inDegrees.length; ++i) {
            if (!this.useSparseDegrees) {
                dataOutputStream.writeInt(Integer.reverseBytes(this.inDegrees[i]));
                dataOutputStream.writeInt(Integer.reverseBytes(this.outDegrees[i]));
                continue;
            }
            if (this.inDegrees[i] + this.outDegrees[i] <= 0) continue;
            dataOutputStream.writeInt(Integer.reverseBytes(i));
            dataOutputStream.writeInt(Integer.reverseBytes(this.inDegrees[i]));
            dataOutputStream.writeInt(Integer.reverseBytes(this.outDegrees[i]));
        }
        dataOutputStream.close();
    }

    private void writeIntervals() throws IOException {
        FileWriter fileWriter = new FileWriter(ChiFilenames.getFilenameIntervals(this.baseFilename, this.numShards));
        for (int i = 1; i <= this.numShards; ++i) {
            int n = i * this.finalIdTranslate.getVertexIntervalLength() - 1;
            fileWriter.write(n + "\n");
            if (n <= this.maxVertexId) continue;
            this.maxVertexId = n;
        }
        fileWriter.close();
    }

    private void saveVertexTranslate() throws IOException {
        FileWriter fileWriter = new FileWriter(ChiFilenames.getVertexTranslateDefFile(this.baseFilename, this.numShards));
        fileWriter.write(this.finalIdTranslate.stringRepresentation());
        fileWriter.close();
    }

    private void processVertexValues(boolean bl) throws IOException {
        DataBlockManager dataBlockManager = new DataBlockManager();
        VertexData<VertexValueType> vertexData = new VertexData<VertexValueType>(this.maxVertexId + 1, this.baseFilename, this.vertexValueTypeBytesToValueConverter, bl);
        vertexData.setBlockManager(dataBlockManager);
        for (int i = 0; i < this.numShards; ++i) {
            int n;
            int n2;
            int n3;
            int n4;
            int n5 = i * this.finalIdTranslate.getVertexIntervalLength();
            int n6 = (i + 1) * this.finalIdTranslate.getVertexIntervalLength() - 1;
            if (n6 > this.maxVertexId) {
                n6 = this.maxVertexId;
            }
            this.vertexShovelStreams[i].close();
            File file = new File(this.vertexShovelFileName(i));
            BufferedDataInputStream bufferedDataInputStream = new BufferedDataInputStream(new FileInputStream(file));
            int n7 = this.vertexValueTypeBytesToValueConverter.sizeOf();
            long[] lArray = new long[(int)(file.length() / (long)(4 + n7))];
            if (lArray.length == 0) continue;
            byte[] byArray = new byte[lArray.length * n7];
            for (n4 = 0; n4 < lArray.length; ++n4) {
                n3 = bufferedDataInputStream.readInt();
                n2 = this.finalIdTranslate.forward(this.preIdTranslate.backward(n3));
                lArray[n4] = n2;
                bufferedDataInputStream.readFully(this.vertexValueTemplate);
                n = n4 * n7;
                System.arraycopy(this.vertexValueTemplate, 0, byArray, n, n7);
            }
            FastSharder.sortWithValues(lArray, byArray, n7);
            n4 = 2000000;
            n3 = 0;
            for (n2 = n5; n2 < n6; n2 += n4) {
                n = n2 + n4 - 1;
                if (n > n6) {
                    n = n6;
                }
                int n8 = vertexData.load(n2, n);
                Iterator<Integer> iterator = vertexData.currentIterator();
                while (iterator.hasNext()) {
                    int n9 = iterator.next();
                    while (n3 < lArray.length && lArray[n3] < (long)n9) {
                        ++n3;
                    }
                    if (n3 >= lArray.length) break;
                    if (n9 != (int)lArray[n3]) continue;
                    ChiPointer chiPointer = vertexData.getVertexValuePtr(n9, n8);
                    System.arraycopy(byArray, n3 * n7, this.vertexValueTemplate, 0, n7);
                    dataBlockManager.writeValue(chiPointer, this.vertexValueTemplate);
                }
                vertexData.releaseAndCommit(n2, n8);
            }
        }
    }

    private void processShovel(int n) throws IOException {
        int n2;
        int n3;
        int n4;
        int n5;
        int n6;
        File file = new File(this.shovelFilename(n));
        int n7 = this.edgeValueTypeBytesToValueConverter != null ? this.edgeValueTypeBytesToValueConverter.sizeOf() : 0;
        long[] lArray = new long[(int)(file.length() / (long)(8 + n7))];
        if (lArray.length > 500000000) {
            throw new RuntimeException("Too big shard size, shovel length was: " + lArray.length + " max: " + 500000000);
        }
        byte[] byArray = new byte[lArray.length * n7];
        logger.info("Processing shovel " + n);
        BufferedDataInputStream bufferedDataInputStream = new BufferedDataInputStream(new FileInputStream(file));
        for (int i = 0; i < lArray.length; ++i) {
            long l = bufferedDataInputStream.readLong();
            int n8 = FastSharder.getFirst(l);
            n6 = FastSharder.getSecond(l);
            bufferedDataInputStream.readFully(this.valueTemplate);
            n5 = this.finalIdTranslate.forward(this.preIdTranslate.backward(n8));
            n4 = this.finalIdTranslate.forward(this.preIdTranslate.backward(n6));
            lArray[i] = FastSharder.packEdges(n5, n4);
            n3 = i * n7;
            System.arraycopy(this.valueTemplate, 0, byArray, n3, n7);
            if (this.memoryEfficientDegreeCount) continue;
            int n9 = n4;
            this.inDegrees[n9] = this.inDegrees[n9] + 1;
            int n10 = n5;
            this.outDegrees[n10] = this.outDegrees[n10] + 1;
        }
        this.numEdges += (long)lArray.length;
        bufferedDataInputStream.close();
        file.delete();
        logger.info("Processing shovel " + n + " ... sorting");
        FastSharder.sortWithValues(lArray, byArray, n7);
        logger.info("Processing shovel " + n + " ... writing shard");
        File file2 = new File(ChiFilenames.getFilenameShardsAdj(this.baseFilename, n, this.numShards));
        DataOutputStream dataOutputStream = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(file2)));
        File file3 = new File(file2.getAbsolutePath() + ".index");
        DataOutputStream dataOutputStream2 = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(file3)));
        n6 = 0;
        n5 = 0;
        n4 = 0;
        n3 = 0;
        int n11 = 4096;
        for (n2 = 0; n2 <= lArray.length; ++n2) {
            int n12;
            int n13;
            int n14;
            int n15 = n14 = n2 < lArray.length ? FastSharder.getFirst(lArray[n2]) : -1;
            if (n14 == n6) continue;
            if (n4 - n3 >= n11) {
                dataOutputStream2.writeInt(n6);
                dataOutputStream2.writeInt(dataOutputStream.size());
                dataOutputStream2.writeInt(n4);
                n3 = n4;
            }
            if ((n13 = n2 - n5) > 0) {
                if (n13 < 255) {
                    dataOutputStream.writeByte(n13);
                } else {
                    dataOutputStream.writeByte(255);
                    dataOutputStream.writeInt(Integer.reverseBytes(n13));
                }
            }
            for (n12 = n5; n12 < n2; ++n12) {
                dataOutputStream.writeInt(Integer.reverseBytes(FastSharder.getSecond(lArray[n12])));
                ++n4;
            }
            n5 = n2;
            if (n14 != -1 && (n14 - n6 > 1 || n2 == 0 && n14 > 0)) {
                int n16;
                n12 = n14 - n6 - 1;
                if (n2 == 0 && n14 > 0) {
                    n12 = n14;
                }
                do {
                    dataOutputStream.writeByte(0);
                    n16 = Math.min(254, --n12);
                    dataOutputStream.writeByte(n16);
                } while ((n12 -= n16) > 0);
            }
            n6 = n14;
        }
        dataOutputStream.close();
        dataOutputStream2.close();
        if (n7 > 0) {
            n2 = ChiFilenames.getBlocksize(n7);
            String string = ChiFilenames.getFilenameShardEdata(this.baseFilename, new BytesToValueConverter(){

                @Override
                public int sizeOf() {
                    return FastSharder.this.edgeValueTypeBytesToValueConverter.sizeOf();
                }

                public Object getValue(byte[] byArray) {
                    return null;
                }

                public void setValue(byte[] byArray, Object object) {
                }
            }, n, this.numShards);
            File file4 = new File(string + ".size");
            File file5 = new File(ChiFilenames.getDirnameShardEdataBlock(string, n2));
            if (!file5.exists()) {
                file5.mkdir();
            }
            long l = lArray.length * this.edgeValueTypeBytesToValueConverter.sizeOf();
            FileWriter fileWriter = new FileWriter(file4);
            fileWriter.write(l + "");
            fileWriter.close();
            int n17 = 0;
            int n18 = 0;
            for (long i = 0L; i < l; i += (long)n2) {
                File file6 = new File(ChiFilenames.getFilenameShardEdataBlock(string, n17, n2));
                OutputStream outputStream = CompressedIO.isCompressionEnabled() ? new DeflaterOutputStream(new BufferedOutputStream(new FileOutputStream(file6))) : new FileOutputStream(file6);
                long l2 = Math.min((long)n2, l - i);
                byte[] byArray2 = new byte[(int)l2];
                System.arraycopy(byArray, n18 * n7, byArray2, 0, byArray2.length);
                n18 = (int)((long)n18 + l2 / (long)n7);
                outputStream.write(byArray2);
                outputStream.close();
                ++n17;
            }
            assert (n18 == byArray.length);
        }
    }

    private static int partition(long[] lArray, byte[] byArray, int n, int n2, int n3) {
        int n4 = n2;
        int n5 = n3;
        long l = lArray[n2 + random.nextInt(n3 - n2 + 1)];
        byte[] byArray2 = new byte[n];
        while (n4 <= n5) {
            while (lArray[n4] < l) {
                ++n4;
            }
            while (lArray[n5] > l) {
                --n5;
            }
            if (n4 > n5) continue;
            long l2 = lArray[n4];
            System.arraycopy(byArray, n5 * n, byArray2, 0, n);
            System.arraycopy(byArray, n4 * n, byArray, n5 * n, n);
            System.arraycopy(byArray2, 0, byArray, n4 * n, n);
            lArray[n4] = lArray[n5];
            lArray[n5] = l2;
            ++n4;
            --n5;
        }
        return n4;
    }

    static void quickSort(long[] lArray, byte[] byArray, int n, int n2, int n3) {
        if (n2 < n3) {
            int n4 = FastSharder.partition(lArray, byArray, n, n2, n3);
            if (n2 < n4 - 1) {
                FastSharder.quickSort(lArray, byArray, n, n2, n4 - 1);
            }
            if (n4 < n3) {
                FastSharder.quickSort(lArray, byArray, n, n4, n3);
            }
        }
    }

    public static void sortWithValues(long[] lArray, byte[] byArray, int n) {
        FastSharder.quickSort(lArray, byArray, n, 0, lArray.length - 1);
    }

    public void shard(InputStream inputStream, GraphInputFormat graphInputFormat) throws IOException {
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
        long l = 0L;
        if (!graphInputFormat.equals((Object)GraphInputFormat.MATRIXMARKET)) {
            String string;
            while ((string = bufferedReader.readLine()) != null) {
                String[] stringArray;
                if (string.length() <= 2 || string.startsWith("#")) continue;
                if (++l % 2000000L == 0L) {
                    logger.info("Reading line: " + l);
                }
                if ((stringArray = string.split("\t")).length == 1) {
                    stringArray = string.split(" ");
                }
                if (stringArray.length <= 1) continue;
                if (graphInputFormat == GraphInputFormat.EDGELIST) {
                    if (stringArray.length == 2) {
                        this.addEdge(Integer.parseInt(stringArray[0]), Integer.parseInt(stringArray[1]), null);
                        continue;
                    }
                    if (stringArray.length != 3) continue;
                    this.addEdge(Integer.parseInt(stringArray[0]), Integer.parseInt(stringArray[1]), stringArray[2]);
                    continue;
                }
                if (graphInputFormat == GraphInputFormat.ADJACENCY) {
                    int n = Integer.parseInt(stringArray[0]);
                    int n2 = Integer.parseInt(stringArray[1]);
                    if (n2 != stringArray.length - 2) {
                        if (l < 10L) {
                            throw new IllegalArgumentException("Error on line " + l + "; number of edges does not match number of tokens:" + n2 + " != " + stringArray.length);
                        }
                        logger.warning("Error on line " + l + "; number of edges does not match number of tokens:" + n2 + " != " + stringArray.length);
                        break;
                    }
                    for (int i = 2; i < 2 + n2; ++i) {
                        int n3 = Integer.parseInt(stringArray[i]);
                        this.addEdge(n, n3, null);
                    }
                    continue;
                }
                throw new IllegalArgumentException("Please specify graph input format");
            }
        } else if (graphInputFormat.equals((Object)GraphInputFormat.MATRIXMARKET)) {
            Object object;
            String[] stringArray;
            String string;
            boolean bl = false;
            int n = 0;
            int n4 = 0;
            long l2 = 0L;
            while ((string = bufferedReader.readLine()) != null) {
                ++l;
                if (string.length() <= 2 || string.startsWith("#")) continue;
                if (string.startsWith("%%")) {
                    if (string.contains("matrix coordinate real general")) continue;
                    throw new RuntimeException("Unknown matrix market format!");
                }
                if (string.startsWith("%")) continue;
                stringArray = string.split(" ");
                if (l % 2000000L == 0L) {
                    logger.info("Reading line: " + l + " / " + l2);
                }
                if (!bl) {
                    n = Integer.parseInt(stringArray[0]);
                    n4 = Integer.parseInt(stringArray[1]);
                    l2 = Long.parseLong(stringArray[2]);
                    logger.info("Matrix-market: going to load total of " + l2 + " edges.");
                    bl = true;
                    continue;
                }
                try {
                    object = stringArray[stringArray.length - 1];
                    this.addEdge(Integer.parseInt(stringArray[0]) - 1, n + Integer.parseInt(stringArray[1]) - 1, (String)object);
                }
                catch (NumberFormatException numberFormatException) {
                    logger.severe("Could not parse line: " + string);
                    throw numberFormatException;
                }
            }
            stringArray = this.baseFilename + ".matrixinfo";
            object = new FileOutputStream(new File((String)stringArray));
            ((FileOutputStream)object).write((n + "\t" + n4 + "\t" + l2 + "\n").getBytes());
            ((FileOutputStream)object).close();
        }
        this.process();
    }

    public void shard(InputStream inputStream, String string) throws IOException {
        if (string == null || string.equals("edgelist")) {
            this.shard(inputStream, GraphInputFormat.EDGELIST);
        } else if (string.equals("adjlist") || string.startsWith("adjacency")) {
            this.shard(inputStream, GraphInputFormat.ADJACENCY);
        }
    }

    public void shard(InputStream inputStream) throws IOException {
        this.shard(inputStream, GraphInputFormat.EDGELIST);
    }

    private void computeVertexDegrees() {
        try {
            int n;
            int n2;
            logger.info("Use sparse degrees: " + this.useSparseDegrees);
            DataOutputStream dataOutputStream = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(ChiFilenames.getFilenameOfDegreeData(this.baseFilename, this.useSparseDegrees))));
            SlidingShard[] slidingShardArray = new SlidingShard[this.numShards];
            for (n2 = 0; n2 < this.numShards; ++n2) {
                int n3 = n2 * this.finalIdTranslate.getVertexIntervalLength();
                n = (n2 + 1) * this.finalIdTranslate.getVertexIntervalLength() - 1;
                slidingShardArray[n2] = new SlidingShard(null, ChiFilenames.getFilenameShardsAdj(this.baseFilename, n2, this.numShards), n3, n);
                slidingShardArray[n2].setOnlyAdjacency(true);
            }
            n2 = 2000000;
            ExecutorService executorService = Executors.newFixedThreadPool(4);
            for (n = 0; n < this.numShards; ++n) {
                logger.info("Degree computation round " + n + " / " + this.numShards);
                int n4 = n * this.finalIdTranslate.getVertexIntervalLength();
                int n5 = (n + 1) * this.finalIdTranslate.getVertexIntervalLength() - 1;
                MemoryShard memoryShard = new MemoryShard(null, ChiFilenames.getFilenameShardsAdj(this.baseFilename, n, this.numShards), n4, n5);
                memoryShard.setOnlyAdjacency(true);
                for (int i = n4; i < n5; i += n2) {
                    int n6;
                    int n7 = i + n2 - 1;
                    if (n7 > n5) {
                        n7 = n5;
                    }
                    ChiVertex[] chiVertexArray = new ChiVertex[n7 - i + 1];
                    for (n6 = 0; n6 < chiVertexArray.length; ++n6) {
                        chiVertexArray[n6] = new ChiVertex(n6 + i, null);
                    }
                    memoryShard.loadVertices(i, n7, chiVertexArray, false, executorService);
                    for (n6 = 0; n6 < this.numShards; ++n6) {
                        if (n6 == n) continue;
                        slidingShardArray[n6].readNextVertices(chiVertexArray, i, true);
                    }
                    for (n6 = 0; n6 < chiVertexArray.length; ++n6) {
                        if (!this.useSparseDegrees) {
                            dataOutputStream.writeInt(Integer.reverseBytes(chiVertexArray[n6].numInEdges()));
                            dataOutputStream.writeInt(Integer.reverseBytes(chiVertexArray[n6].numOutEdges()));
                            continue;
                        }
                        if (chiVertexArray[n6].numEdges() <= 0) continue;
                        dataOutputStream.writeInt(Integer.reverseBytes(i + n6));
                        dataOutputStream.writeInt(Integer.reverseBytes(chiVertexArray[n6].numInEdges()));
                        dataOutputStream.writeInt(Integer.reverseBytes(chiVertexArray[n6].numOutEdges()));
                    }
                }
            }
            executorService.shutdown();
            dataOutputStream.close();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public static void main(String[] stringArray) throws Exception {
        String string = stringArray[0];
        int n = Integer.parseInt(stringArray[1]);
        String string2 = stringArray[2];
        FastSharder<Integer, Integer> fastSharder = new FastSharder<Integer, Integer>(string, n, null, new EdgeProcessor<Integer>(){

            @Override
            public Integer receiveEdge(int n, int n2, String string) {
                if (string == null) {
                    return 0;
                }
                return Integer.parseInt(string);
            }
        }, new IntConverter(), new IntConverter());
        fastSharder.shard((InputStream)new FileInputStream(string), string2);
    }

    public static enum GraphInputFormat {
        EDGELIST,
        ADJACENCY,
        MATRIXMARKET;

    }
}

