/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.graphchi.queries;

import edu.cmu.graphchi.ChiFilenames;
import edu.cmu.graphchi.ChiLogger;
import edu.cmu.graphchi.datablocks.BytesToValueConverter;
import edu.cmu.graphchi.io.CompressedIO;
import edu.cmu.graphchi.shards.ShardIndex;
import edu.cmu.graphchi.vertexdata.VertexIdValue;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.logging.Logger;
import ucar.unidata.io.RandomAccessFile;

public class VertexQuery {
    private static final int NTHREADS = 4;
    private static final Logger logger = ChiLogger.getLogger("vertexquery");
    private ArrayList<Shard> shards = new ArrayList();
    private ExecutorService executor;

    public VertexQuery(String string, int n) throws IOException {
        for (int i = 0; i < n; ++i) {
            this.shards.add(new Shard(string, i, n));
        }
        this.executor = Executors.newFixedThreadPool(4);
    }

    public HashMap<Integer, Integer> queryOutNeighborsAndCombine(Collection<Integer> collection) {
        HashMap<Integer, Integer> hashMap;
        Object object;
        ArrayList<Future<HashMap<Integer, Integer>>> arrayList = new ArrayList<Future<HashMap<Integer, Integer>>>();
        long l = System.currentTimeMillis();
        HashMap<Integer, Integer> hashMap2 = new HashMap<Integer, Integer>(1000000);
        logger.info("Cached queries took: " + (System.currentTimeMillis() - l));
        Iterator<Shard> iterator = this.shards.iterator();
        while (iterator.hasNext()) {
            Object object2 = object = iterator.next();
            arrayList.add(this.executor.submit(new Callable<HashMap<Integer, Integer>>((Shard)object2, collection){
                final /* synthetic */ Shard val$_shard;
                final /* synthetic */ Collection val$queryVertices;
                {
                    this.val$_shard = shard;
                    this.val$queryVertices = collection;
                }

                @Override
                public HashMap<Integer, Integer> call() throws Exception {
                    HashMap<Integer, Integer> hashMap = this.val$_shard.queryAndCombine(this.val$queryVertices);
                    return hashMap;
                }
            }));
        }
        try {
            hashMap = hashMap2;
            for (int i = 0; i < arrayList.size(); ++i) {
                object = (HashMap)((Future)arrayList.get(i)).get();
                for (Map.Entry entry : ((HashMap)object).entrySet()) {
                    if (hashMap.containsKey(entry.getKey())) {
                        hashMap.put((Integer)entry.getKey(), (Integer)entry.getValue() + hashMap.get(entry.getKey()));
                        continue;
                    }
                    hashMap.put((Integer)entry.getKey(), (Integer)entry.getValue());
                }
            }
        }
        catch (InterruptedException interruptedException) {
            throw new RuntimeException(interruptedException);
        }
        catch (ExecutionException executionException) {
            throw new RuntimeException(executionException);
        }
        return hashMap;
    }

    public HashMap<Integer, ArrayList<Integer>> queryOutNeighbors(Collection<Integer> collection) {
        HashMap<Integer, ArrayList<Integer>> hashMap;
        Object object;
        ArrayList<Future<HashMap<Integer, ArrayList<Integer>>>> arrayList = new ArrayList<Future<HashMap<Integer, ArrayList<Integer>>>>();
        long l = System.currentTimeMillis();
        HashMap<Integer, ArrayList<Integer>> hashMap2 = new HashMap<Integer, ArrayList<Integer>>(1000);
        Iterator<Shard> iterator = this.shards.iterator();
        while (iterator.hasNext()) {
            Object object2 = object = iterator.next();
            arrayList.add(this.executor.submit(new Callable<HashMap<Integer, ArrayList<Integer>>>((Shard)object2, collection){
                final /* synthetic */ Shard val$_shard;
                final /* synthetic */ Collection val$queryVertices;
                {
                    this.val$_shard = shard;
                    this.val$queryVertices = collection;
                }

                @Override
                public HashMap<Integer, ArrayList<Integer>> call() throws Exception {
                    HashMap<Integer, ArrayList<Integer>> hashMap = this.val$_shard.query(this.val$queryVertices);
                    return hashMap;
                }
            }));
        }
        try {
            hashMap = hashMap2;
            for (int i = 0; i < arrayList.size(); ++i) {
                object = (HashMap)((Future)arrayList.get(i)).get();
                for (Map.Entry entry : ((HashMap)object).entrySet()) {
                    ArrayList<Integer> arrayList2 = hashMap.get(entry.getKey());
                    if (arrayList2 == null) {
                        hashMap.put((Integer)entry.getKey(), (ArrayList<Integer>)entry.getValue());
                        continue;
                    }
                    arrayList2.addAll((Collection)entry.getValue());
                }
            }
        }
        catch (InterruptedException interruptedException) {
            throw new RuntimeException(interruptedException);
        }
        catch (ExecutionException executionException) {
            throw new RuntimeException(executionException);
        }
        return hashMap;
    }

    public HashSet<Integer> queryOutNeighbors(int n) throws IOException {
        HashSet hashSet;
        Object object;
        Object object2;
        ArrayList<Future<HashSet<Integer>>> arrayList = new ArrayList<Future<HashSet<Integer>>>();
        Iterator<Shard> iterator = this.shards.iterator();
        while (iterator.hasNext()) {
            object = object2 = iterator.next();
            arrayList.add(this.executor.submit(new Callable<HashSet<Integer>>((Shard)object, n){
                final /* synthetic */ Shard val$_shard;
                final /* synthetic */ int val$internalId;
                {
                    this.val$_shard = shard;
                    this.val$internalId = n;
                }

                @Override
                public HashSet<Integer> call() throws Exception {
                    return this.val$_shard.query(this.val$internalId);
                }
            }));
        }
        try {
            hashSet = (HashSet)((Future)arrayList.get(0)).get();
            for (int i = 1; i < arrayList.size(); ++i) {
                object2 = (HashSet)((Future)arrayList.get(i)).get();
                object = ((HashSet)object2).iterator();
                while (object.hasNext()) {
                    Integer n2 = (Integer)object.next();
                    hashSet.add(n2);
                }
            }
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
        return hashSet;
    }

    public void shutdown() {
        this.executor.shutdown();
    }

    static class Shard {
        RandomAccessFile adjFile;
        ShardIndex index;
        int shardNum;
        int numShards;
        String fileName;

        private Shard(String string, int n, int n2) throws IOException {
            this.shardNum = n;
            this.numShards = n2;
            this.fileName = string;
            File file = new File(ChiFilenames.getFilenameShardsAdj(string, n, n2));
            this.adjFile = new RandomAccessFile(file.getAbsolutePath(), "r", 65536);
            this.index = new ShardIndex(file);
        }

        public HashMap<Integer, Integer> queryAndCombine(Collection<Integer> collection) throws IOException {
            ArrayList<Integer> arrayList = new ArrayList<Integer>(collection);
            Collections.sort(arrayList);
            ArrayList<ShardIndex.IndexEntry> arrayList2 = new ArrayList<ShardIndex.IndexEntry>(arrayList.size());
            for (Integer object2 : arrayList) {
                arrayList2.add(this.index.lookup(object2));
            }
            HashMap hashMap = new HashMap(5000);
            Object var5_6 = null;
            Object var6_9 = null;
            int n = 0;
            int n2 = 0;
            for (int i = 0; i < arrayList.size(); ++i) {
                ShardIndex.IndexEntry indexEntry = (ShardIndex.IndexEntry)arrayList2.get(i);
                int n3 = arrayList.get(i);
                if (i == 0 || !indexEntry.equals(var6_9)) {
                    n = indexEntry.vertex;
                    n2 = indexEntry.fileOffset;
                    this.adjFile.seek(n2);
                }
                while (n <= n3) {
                    int n4;
                    int n5;
                    int n6 = this.adjFile.readUnsignedByte();
                    assert (n6 >= 0);
                    ++n2;
                    if (n6 == 0) {
                        ++n;
                        n5 = this.adjFile.readUnsignedByte();
                        ++n2;
                        assert (n5 >= 0);
                        n += n5;
                        continue;
                    }
                    if (n6 == 255) {
                        n4 = this.adjFile.readInt();
                        n2 += 4;
                    } else {
                        n4 = n6;
                    }
                    if (n == n3) {
                        while (--n4 >= 0) {
                            n5 = this.adjFile.readInt();
                            Integer n7 = (Integer)hashMap.get(n5);
                            if (n7 == null) {
                                hashMap.put(n5, 1);
                                continue;
                            }
                            hashMap.put(n5, 1 + n7);
                        }
                    } else {
                        this.adjFile.skipBytes(n4 * 4);
                    }
                    ++n;
                }
            }
            return hashMap;
        }

        public HashMap<Integer, ArrayList<Integer>> query(Collection<Integer> collection) throws IOException {
            ArrayList<Integer> arrayList = new ArrayList<Integer>(collection);
            Collections.sort(arrayList);
            ArrayList<ShardIndex.IndexEntry> arrayList2 = new ArrayList<ShardIndex.IndexEntry>(arrayList.size());
            for (Integer object2 : arrayList) {
                arrayList2.add(this.index.lookup(object2));
            }
            HashMap hashMap = new HashMap(collection.size());
            Object var5_6 = null;
            Object var6_9 = null;
            int n = 0;
            int n2 = 0;
            for (int i = 0; i < arrayList.size(); ++i) {
                ShardIndex.IndexEntry indexEntry = (ShardIndex.IndexEntry)arrayList2.get(i);
                int n3 = arrayList.get(i);
                boolean bl = false;
                if (i == 0 || !indexEntry.equals(var6_9)) {
                    n = indexEntry.vertex;
                    n2 = indexEntry.fileOffset;
                    this.adjFile.seek(n2);
                }
                while (n <= n3) {
                    int n4;
                    int n5 = this.adjFile.readUnsignedByte();
                    assert (n5 >= 0);
                    ++n2;
                    if (n5 == 0) {
                        ++n;
                        int n6 = this.adjFile.readUnsignedByte();
                        ++n2;
                        assert (n6 >= 0);
                        n += n6;
                        continue;
                    }
                    if (n5 == 255) {
                        n4 = this.adjFile.readInt();
                        n2 += 4;
                    } else {
                        n4 = n5;
                    }
                    if (n == n3) {
                        ArrayList<Integer> arrayList3 = new ArrayList<Integer>(n4);
                        bl = true;
                        while (--n4 >= 0) {
                            int n7 = this.adjFile.readInt();
                            arrayList3.add(n7);
                        }
                        hashMap.put(n3, arrayList3);
                    } else {
                        this.adjFile.skipBytes(n4 * 4);
                    }
                    ++n;
                }
                if (bl) continue;
                hashMap.put(n3, new ArrayList(0));
            }
            return hashMap;
        }

        public HashSet<Integer> query(int n) throws IOException {
            return new HashSet<Integer>((Collection)this.query(Collections.singletonList(n)).get(n));
        }

        public <VT> List<VertexIdValue<VT>> queryWithValues(int n, BytesToValueConverter<VT> bytesToValueConverter) throws IOException {
            ArrayList<VertexIdValue<VT>> arrayList = new ArrayList<VertexIdValue<VT>>();
            ShardIndex.IndexEntry indexEntry = this.index.lookup(n);
            int n2 = indexEntry.vertex;
            int n3 = indexEntry.fileOffset;
            int n4 = indexEntry.edgePointer;
            String string = ChiFilenames.getFilenameShardEdata(this.fileName, bytesToValueConverter, this.shardNum, this.numShards);
            int n5 = ChiFilenames.getShardEdataSize(string);
            this.adjFile.seek(n3);
            int n6 = ChiFilenames.getBlocksize(bytesToValueConverter.sizeOf());
            byte[] byArray = new byte[n6];
            int n7 = -1;
            byte[] byArray2 = new byte[bytesToValueConverter.sizeOf()];
            while (n2 <= n) {
                int n8;
                int n9;
                int n10 = this.adjFile.readUnsignedByte();
                assert (n10 >= 0);
                ++n3;
                if (n10 == 0) {
                    ++n2;
                    n9 = this.adjFile.readUnsignedByte();
                    ++n3;
                    assert (n9 >= 0);
                    n2 += n9;
                    continue;
                }
                if (n10 == 255) {
                    n8 = this.adjFile.readInt();
                    n3 += 4;
                } else {
                    n8 = n10;
                }
                if (n2 == n) {
                    while (--n8 >= 0) {
                        String string2;
                        n9 = this.adjFile.readInt();
                        int n11 = n4 * bytesToValueConverter.sizeOf() / n6;
                        if (n11 != n7) {
                            string2 = ChiFilenames.getFilenameShardEdataBlock(string, n11, n6);
                            n7 = n11;
                            int n12 = Math.min(n6, n5 - n11 * n6);
                            CompressedIO.readCompressed(new File(string2), byArray, n12);
                        }
                        System.arraycopy(byArray, n4 * bytesToValueConverter.sizeOf() % n6, byArray2, 0, bytesToValueConverter.sizeOf());
                        string2 = bytesToValueConverter.getValue(byArray2);
                        arrayList.add(new VertexIdValue<String>(n9, string2));
                        ++n4;
                    }
                } else {
                    this.adjFile.skipBytes(n8 * 4);
                    n4 += n8;
                }
                ++n2;
            }
            return arrayList;
        }
    }
}

