/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.graphchi.queries.demo;

import edu.cmu.graphchi.ChiFilenames;
import edu.cmu.graphchi.ChiLogger;
import edu.cmu.graphchi.datablocks.FloatConverter;
import edu.cmu.graphchi.preprocessing.VertexIdTranslate;
import edu.cmu.graphchi.queries.VertexQuery;
import edu.cmu.graphchi.util.IdCount;
import edu.cmu.graphchi.util.MultinomialSampler;
import edu.cmu.graphchi.vertexdata.VertexAggregator;
import edu.cmu.graphchi.vertexdata.VertexIdValue;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Random;
import java.util.TreeSet;
import java.util.logging.Logger;

public class FriendsOfFriends {
    private VertexQuery queryEngine;
    private static final Logger logger = ChiLogger.getLogger("fof");
    private VertexIdTranslate translator;
    private String baseFilename;
    private boolean weightByPagerank;
    private int numShards;
    private float[] ranks;
    private BufferedWriter logWriter = new BufferedWriter(new FileWriter("fof.log"));

    public FriendsOfFriends(String string, int n, boolean bl) throws IOException {
        this.queryEngine = new VertexQuery(string, n);
        this.baseFilename = string;
        this.weightByPagerank = bl;
        this.numShards = n;
        this.translator = VertexIdTranslate.fromFile(new File(ChiFilenames.getVertexTranslateDefFile(string, n)));
        if (bl) {
            this.loadRanks();
        }
    }

    private void loadRanks() throws IOException {
        logger.info("Loading ranks...");
        long l = System.currentTimeMillis();
        int n = ChiFilenames.numVertices(this.baseFilename, this.numShards);
        this.ranks = new float[n];
        Iterator<VertexIdValue<Float>> iterator = VertexAggregator.vertexIterator(n, this.baseFilename, new FloatConverter(), VertexIdTranslate.identity());
        while (iterator.hasNext()) {
            VertexIdValue<Float> vertexIdValue = iterator.next();
            this.ranks[vertexIdValue.getVertexId()] = vertexIdValue.getValue().floatValue();
        }
        logger.info("Loaded ranks to memory in " + (System.currentTimeMillis() - l) + " ms");
    }

    public String recommendFriends(int n, int n2) throws IOException {
        TreeSet<IdCount> treeSet;
        int n3 = this.translator.forward(n);
        logger.info("Querying for " + this.namify(n) + " --> " + n3);
        long l = System.currentTimeMillis();
        boolean bl = false;
        HashSet<Integer> hashSet = this.queryEngine.queryOutNeighbors(n3);
        long l2 = System.currentTimeMillis() - l;
        logger.info("Found " + hashSet.size() + " friends  in " + l2 + " ms.");
        int n4 = hashSet.size();
        Random random = new Random();
        if (hashSet.size() > n2) {
            ArrayList<Integer> arrayList = new ArrayList<Integer>(hashSet);
            hashSet.clear();
            if (this.ranks != null) {
                float[] fArray = new float[arrayList.size()];
                for (int i = 0; i < fArray.length; ++i) {
                    fArray[i] = this.ranks[arrayList.get(i)];
                }
                for (Object object : treeSet = (TreeSet<IdCount>)MultinomialSampler.generateSamplesAliasMethod(random, fArray, n2 * 2)) {
                    hashSet.add(arrayList.get((int)object));
                    if (hashSet.size() != n2) {
                        continue;
                    }
                    break;
                }
            } else {
                for (int i = 0; i < n2; ++i) {
                    hashSet.add(arrayList.get(Math.abs(random.nextInt()) % arrayList.size()));
                }
            }
        }
        if (hashSet.size() == 0) {
            return "";
        }
        l = System.currentTimeMillis();
        HashMap<Integer, Integer> hashMap = this.queryEngine.queryOutNeighborsAndCombine(hashSet);
        hashMap.remove(n3);
        long l3 = System.currentTimeMillis() - l;
        treeSet = hashSet.iterator();
        while (treeSet.hasNext()) {
            int n5 = treeSet.next();
            hashMap.remove(n5);
        }
        logger.info("Found " + hashMap.size() + " friends-of-friends (that are not friends) in " + l3 + "ms");
        int n6 = 20;
        TreeSet<IdCount> treeSet2 = new TreeSet<IdCount>();
        for (Map.Entry<Integer, Integer> entry : hashMap.entrySet()) {
            if (treeSet2.size() < n6) {
                treeSet2.add(new IdCount(this.translator.backward(entry.getKey()), entry.getValue()));
                continue;
            }
            int idCount = ((IdCount)treeSet2.last()).count;
            if (entry.getValue() <= idCount) continue;
            treeSet2.pollLast();
            treeSet2.add(new IdCount(this.translator.backward(entry.getKey()), entry.getValue()));
        }
        Object object = "";
        for (IdCount idCount : treeSet2) {
            System.out.println(this.namify(idCount.id) + " : " + idCount.count);
            object = (String)object + this.namify(idCount.id) + " : " + idCount.count + "\n";
        }
        this.logWriter.write(n4 + "," + l2 + "," + l3 + "\n");
        return object;
    }

    private String namify(Integer n) throws IOException {
        File file = new File(this.baseFilename + "_names.dat");
        if (!file.exists()) {
            return n + "";
        }
        int n2 = n * 16;
        RandomAccessFile randomAccessFile = new RandomAccessFile(file.getAbsolutePath(), "r");
        randomAccessFile.seek(n2);
        byte[] byArray = new byte[16];
        randomAccessFile.read(byArray);
        randomAccessFile.close();
        return new String(byArray) + "(" + n + ")";
    }

    public static void main(String[] stringArray) throws Exception {
        String string = stringArray[0];
        int n = Integer.parseInt(stringArray[1]);
        FriendsOfFriends friendsOfFriends = new FriendsOfFriends(string, n, false);
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(System.in));
        while (true) {
            int n2;
            System.out.print("Enter vertex id to get friends-of-friends >> :: ");
            String string2 = bufferedReader.readLine();
            if (string2.startsWith("q")) break;
            if (string2.startsWith("t")) {
                for (n2 = 10; n2 < 1000; ++n2) {
                    friendsOfFriends.recommendFriends(n2, 1000);
                }
                break;
            }
            if (string2.startsWith("b")) {
                friendsOfFriends.queryEngine.shutdown();
                friendsOfFriends = new FriendsOfFriends(string, n, false);
                n2 = ChiFilenames.numVertices(string, n);
                Random random = new Random();
                for (int i = 0; i < 1000000; ++i) {
                    int n3 = random.nextInt(n2);
                    if (n3 % 10 <= 4) {
                        n3 = random.nextInt(n2 % 100000);
                    }
                    friendsOfFriends.recommendFriends(n3, 4000);
                    if (i % 1000 == 0) {
                        logger.info("Benchmark round " + i);
                    }
                    friendsOfFriends.logWriter.flush();
                }
            }
            n2 = Integer.parseInt(string2);
            friendsOfFriends.recommendFriends(n2, 500);
        }
        friendsOfFriends.queryEngine.shutdown();
    }
}

