/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.graphchi.scala.apps;

import edu.cmu.graphchi.datablocks.FloatConverter;
import edu.cmu.graphchi.preprocessing.EdgeProcessor;
import edu.cmu.graphchi.preprocessing.FastSharder;
import edu.cmu.graphchi.preprocessing.VertexProcessor;
import edu.cmu.graphchi.scala.EdgeDirection;
import edu.cmu.graphchi.scala.GraphChiScala;
import edu.cmu.graphchi.scala.INEDGES;
import edu.cmu.graphchi.scala.OUTEDGES;
import edu.cmu.graphchi.scala.ScalaChiVertex;
import edu.cmu.graphchi.util.IdFloat;
import edu.cmu.graphchi.util.Toplist;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.TreeSet;
import scala.Function1;
import scala.Function2;
import scala.Function4;
import scala.Predef$;
import scala.Serializable;
import scala.collection.JavaConversions$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;

public final class PagerankScala$ {
    public static final PagerankScala$ MODULE$;

    static {
        new PagerankScala$();
    }

    public void main(String[] args) {
        String filename = args[0];
        int nshards = new StringOps(Predef$.MODULE$.augmentString(args[1])).toInt();
        String filetype = args[2];
        int niters = 4;
        FastSharder<Float, Float> sharder = new FastSharder<Float, Float>(filename, nshards, new VertexProcessor<Float>(){

            public Float receiveVertexValue(int vertexId, String token) {
                return Predef$.MODULE$.float2Float(1.0f);
            }
        }, new EdgeProcessor<Float>(){

            public Float receiveEdge(int from, int to, String token) {
                return Predef$.MODULE$.float2Float(1.0f);
            }
        }, new FloatConverter(), new FloatConverter());
        sharder.shard((InputStream)new FileInputStream(filename), filetype);
        GraphChiScala<Float, Float, Float> graphchi = new GraphChiScala<Float, Float, Float>(filename, nshards);
        graphchi.setEdataConverter(new FloatConverter());
        graphchi.setVertexDataConverter(new FloatConverter());
        graphchi.initializeVertices((Function1<ScalaChiVertex<Float, Float>, Float>)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Float apply(ScalaChiVertex<Float, Float> v) {
                return Predef$.MODULE$.float2Float(1.0f);
            }
        });
        graphchi.foreach(niters, (EdgeDirection)new INEDGES(), Predef$.MODULE$.float2Float(0.0f), (Function4<ScalaChiVertex<Float, Float>, Float, Object, Float, Float>)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Float apply(ScalaChiVertex<Float, Float> v, Float edgeval, int iter, Float gather) {
                return Predef$.MODULE$.float2Float(Predef$.MODULE$.Float2float(gather) + Predef$.MODULE$.Float2float(edgeval));
            }
        }, (Function2<Float, ScalaChiVertex<Float, Float>, Float>)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Float apply(Float gather, ScalaChiVertex<Float, Float> v) {
                return Predef$.MODULE$.float2Float(0.15f + 0.85f * Predef$.MODULE$.Float2float(gather));
            }
        }, (EdgeDirection)new OUTEDGES(), (Function1<ScalaChiVertex<Float, Float>, Float>)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Float apply(ScalaChiVertex<Float, Float> v) {
                return Predef$.MODULE$.float2Float(Predef$.MODULE$.Float2float(v.value()) / (float)v.outDegree());
            }
        });
        TreeSet<IdFloat> top20 = Toplist.topListFloat(filename, graphchi.numVertices(), 20);
        IntRef i = new IntRef(0);
        JavaConversions$.MODULE$.asScalaSet(top20).foreach((Function1)new Serializable(graphchi, i){
            public static final long serialVersionUID = 0L;
            private final GraphChiScala graphchi$1;
            private final IntRef i$1;

            public final void apply(IdFloat vertexRank) {
                ++this.i$1.elem;
                System.out.println(new StringBuilder().append(this.i$1.elem).append((Object)": ").append((Object)BoxesRunTime.boxToInteger((int)this.graphchi$1.vertexTranslate().backward(vertexRank.getVertexId()))).append((Object)" = ").append((Object)BoxesRunTime.boxToFloat((float)vertexRank.getValue())).toString());
            }
            {
                this.graphchi$1 = graphchi$1;
                this.i$1 = i$1;
            }
        });
    }

    private PagerankScala$() {
        MODULE$ = this;
    }
}

