/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.graphchi.shards;

import edu.cmu.graphchi.ChiFilenames;
import edu.cmu.graphchi.ChiLogger;
import edu.cmu.graphchi.ChiVertex;
import edu.cmu.graphchi.datablocks.BytesToValueConverter;
import edu.cmu.graphchi.datablocks.ChiPointer;
import edu.cmu.graphchi.datablocks.DataBlockManager;
import edu.cmu.graphchi.io.CompressedIO;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.logging.Logger;
import java.util.zip.GZIPInputStream;
import nom.tam.util.BufferedDataInputStream;

public class SlidingShard<EdgeDataType> {
    private String edgeDataFilename;
    private String adjDataFilename;
    private int rangeStart;
    private int rangeEnd;
    private DataBlockManager blockManager;
    private ArrayList<Block> activeBlocks;
    public long edataFilesize;
    public long adjFilesize;
    private Block curBlock = null;
    private int edataOffset = 0;
    private int blockSize = -1;
    private int sizeOf = -1;
    private int adjOffset = 0;
    private int curvid = 0;
    private boolean onlyAdjacency = false;
    private boolean asyncEdataLoading = true;
    private BytesToValueConverter<EdgeDataType> converter;
    private BufferedDataInputStream adjFile;
    private boolean modifiesOutedges = true;
    private static final Logger logger = ChiLogger.getLogger("slidingshard");

    public SlidingShard(String string, String string2, int n, int n2) throws IOException {
        this.edgeDataFilename = string;
        this.adjDataFilename = string2;
        this.rangeStart = n;
        this.rangeEnd = n2;
        this.adjFilesize = new File(string2).length();
        if (string != null) {
            this.edataFilesize = ChiFilenames.getShardEdataSize(string);
            this.activeBlocks = new ArrayList();
        } else {
            this.onlyAdjacency = true;
        }
    }

    public void finalize() {
        for (Block block : this.activeBlocks) {
            block.release();
        }
    }

    private void checkCurblock(int n) {
        if (this.curBlock == null || this.curBlock.end < this.edataOffset + n) {
            if (this.curBlock != null && !this.curBlock.active) {
                this.curBlock.release();
            }
            int n2 = this.edataOffset / this.blockSize * this.blockSize;
            int n3 = this.edataOffset / this.blockSize;
            this.curBlock = new Block(this.edgeDataFilename, n2, (int)Math.min((long)(n2 + this.blockSize), this.edataFilesize), n3, this.blockSize);
            this.curBlock.ptr = this.edataOffset - n2;
            this.activeBlocks.add(this.curBlock);
        }
    }

    private ChiPointer readEdgePtr() {
        assert (this.sizeOf >= 0);
        if (this.onlyAdjacency) {
            return null;
        }
        this.checkCurblock(this.sizeOf);
        ChiPointer chiPointer = new ChiPointer(this.curBlock.blockId, this.curBlock.ptr);
        this.curBlock.ptr += this.sizeOf;
        this.edataOffset += this.sizeOf;
        return chiPointer;
    }

    public void skip(int n) throws IOException {
        int n2 = n * 4;
        this.adjOffset += n2;
        this.adjFile.skipBytes(n2);
        this.edataOffset += this.sizeOf * n;
        if (this.curBlock != null) {
            this.curBlock.ptr += this.sizeOf * n;
        }
    }

    public void readNextVertices(ChiVertex[] chiVertexArray, int n, boolean bl) throws IOException {
        int n2 = chiVertexArray.length;
        this.curBlock = null;
        this.releasePriorToOffset(false, bl);
        assert (this.activeBlocks.size() <= 1);
        if (!this.onlyAdjacency && !this.activeBlocks.isEmpty()) {
            this.curBlock = this.activeBlocks.get(0);
        }
        if (this.adjFile == null) {
            File file = new File(this.adjDataFilename + ".gz");
            if (file.exists()) {
                logger.info("Note: using compressed: " + file.getName());
                this.adjFile = new BufferedDataInputStream(new GZIPInputStream(new FileInputStream(file)), 0x100000);
            } else {
                this.adjFile = new BufferedDataInputStream(new FileInputStream(this.adjDataFilename), 0x100000);
            }
            this.adjFile.skipBytes(this.adjOffset);
        }
        try {
            for (int i = this.curvid - n; i < n2; ++i) {
                int n3;
                int n4 = this.adjFile.readUnsignedByte();
                assert (n4 >= 0);
                ++this.adjOffset;
                if (n4 == 0) {
                    ++this.curvid;
                    int n5 = this.adjFile.readUnsignedByte();
                    ++this.adjOffset;
                    assert (n5 >= 0);
                    this.curvid += n5;
                    i += n5;
                    continue;
                }
                if (n4 == 255) {
                    n3 = this.adjFile.readIntReversed();
                    this.adjOffset += 4;
                } else {
                    n3 = n4;
                }
                if (i < 0) {
                    this.skip(n3);
                } else {
                    ChiVertex chiVertex = chiVertexArray[i];
                    assert (chiVertex == null || chiVertex.getId() == this.curvid);
                    if (chiVertex != null) {
                        while (--n3 >= 0) {
                            int n6 = this.adjFile.readIntReversed();
                            this.adjOffset += 4;
                            ChiPointer chiPointer = this.readEdgePtr();
                            if (!this.onlyAdjacency) {
                                if (!this.curBlock.active) {
                                    if (this.asyncEdataLoading) {
                                        this.curBlock.readAsync();
                                    } else {
                                        this.curBlock.readNow();
                                    }
                                }
                                this.curBlock.active = true;
                            }
                            chiVertex.addOutEdge(chiPointer == null ? -1 : chiPointer.blockId, chiPointer == null ? -1 : chiPointer.offset, n6);
                            if (n6 >= this.rangeStart && n6 <= this.rangeEnd) continue;
                            throw new IllegalStateException("Target " + n6 + " not in range!");
                        }
                    } else {
                        this.skip(n3);
                    }
                }
                ++this.curvid;
            }
        }
        catch (EOFException eOFException) {
            // empty catch block
        }
    }

    public void flush() throws IOException {
        this.releasePriorToOffset(true, false);
    }

    public void setOffset(int n, int n2, int n3) {
        try {
            if (this.adjFile != null) {
                this.adjFile.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.adjFile = null;
        this.adjOffset = n;
        this.curvid = n2;
        this.edataOffset = n3;
    }

    public void releasePriorToOffset(boolean bl, boolean bl2) throws IOException {
        if (this.onlyAdjacency) {
            return;
        }
        for (int i = this.activeBlocks.size() - 1; i >= 0; --i) {
            Block block = this.activeBlocks.get(i);
            if (block.end > this.edataOffset && !bl) continue;
            this.commit(block, bl, bl2);
            this.activeBlocks.remove(i);
        }
    }

    public long getEdataFilesize() {
        return this.edataFilesize;
    }

    public long getAdjFilesize() {
        return this.adjFilesize;
    }

    public DataBlockManager getDataBlockManager() {
        return this.blockManager;
    }

    public void setDataBlockManager(DataBlockManager dataBlockManager) {
        this.blockManager = dataBlockManager;
    }

    public BytesToValueConverter<EdgeDataType> getConverter() {
        return this.converter;
    }

    public void setConverter(BytesToValueConverter<EdgeDataType> bytesToValueConverter) {
        this.converter = bytesToValueConverter;
        if (bytesToValueConverter == null) {
            this.sizeOf = 0;
            return;
        }
        this.sizeOf = bytesToValueConverter.sizeOf();
        this.blockSize = ChiFilenames.getBlocksize(this.sizeOf);
    }

    void commit(Block block, boolean bl, boolean bl2) throws IOException {
        boolean bl3 = bl2 = bl2 || !this.modifiesOutedges;
        if (bl) {
            if (!bl2) {
                block.commitNow();
            }
            block.release();
        } else if (!bl2) {
            block.commitAsync();
        } else {
            block.release();
        }
    }

    public void setModifiesOutedges(boolean bl) {
        this.modifiesOutedges = bl;
    }

    public void setOnlyAdjacency(boolean bl) {
        this.onlyAdjacency = bl;
    }

    public long getNumEdges() {
        if (this.converter == null) {
            return this.edataFilesize / 4L;
        }
        return this.edataFilesize / (long)this.converter.sizeOf();
    }

    class Block {
        String blockFileName;
        int offset;
        int end;
        int blockId;
        int ptr;
        boolean active = false;

        Block(String string, int n, int n2, int n3, int n4) {
            this.end = n2;
            this.offset = n;
            this.blockId = SlidingShard.this.blockManager.allocateBlock(n2 - n);
            this.ptr = 0;
            this.blockFileName = ChiFilenames.getFilenameShardEdataBlock(string, n3, n4);
        }

        void readAsync() throws IOException {
            this.readNow();
        }

        void readNow() throws IOException {
            byte[] byArray = SlidingShard.this.blockManager.getRawBlock(this.blockId);
            CompressedIO.readCompressed(new File(this.blockFileName), byArray, this.end - this.offset);
        }

        void commitNow() throws IOException {
            byte[] byArray = SlidingShard.this.blockManager.getRawBlock(this.blockId);
            CompressedIO.writeCompressed(new File(this.blockFileName), byArray, this.end - this.offset);
        }

        void commitAsync() throws IOException {
            this.commitNow();
            this.release();
        }

        void release() {
            SlidingShard.this.blockManager.release(this.blockId);
        }
    }
}

