/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.graphchi.toolkits.collaborative_filtering;

import edu.cmu.graphchi.ChiVertex;
import edu.cmu.graphchi.GraphChiContext;
import edu.cmu.graphchi.GraphChiProgram;
import edu.cmu.graphchi.datablocks.FloatConverter;
import edu.cmu.graphchi.engine.GraphChiEngine;
import edu.cmu.graphchi.engine.VertexInterval;
import edu.cmu.graphchi.preprocessing.VertexIdTranslate;
import edu.cmu.graphchi.toolkits.collaborative_filtering.Common;
import edu.cmu.graphchi.toolkits.collaborative_filtering.IO;
import edu.cmu.graphchi.toolkits.collaborative_filtering.ProblemSetup;
import edu.cmu.graphchi.toolkits.collaborative_filtering.RMSEEngine;
import edu.cmu.graphchi.util.FileUtils;
import java.io.BufferedWriter;
import java.io.FileWriter;
import org.apache.commons.math.linear.ArrayRealVector;
import org.apache.commons.math.linear.BlockRealMatrix;
import org.apache.commons.math.linear.CholeskyDecompositionImpl;
import org.apache.commons.math.linear.NotPositiveDefiniteMatrixException;
import org.apache.commons.math.linear.RealMatrix;
import org.apache.commons.math.linear.RealVector;

public class ALS
extends ProblemSetup
implements GraphChiProgram<Integer, Float> {
    double LAMBDA = 0.065;

    private ALS() {
    }

    public static double als_predict(RealVector realVector, RealVector realVector2) {
        double d = realVector.dotProduct(realVector2);
        d = Math.min(d, maxval);
        d = Math.max(d, minval);
        return d;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void update(ChiVertex<Integer, Float> chiVertex, GraphChiContext graphChiContext) {
        block13: {
            if (chiVertex.numEdges() == 0) {
                return;
            }
            BlockRealMatrix blockRealMatrix = new BlockRealMatrix(D, D);
            ArrayRealVector arrayRealVector = new ArrayRealVector(D);
            RealVector realVector = latent_factors_inmem.getRowAsVector(chiVertex.getId());
            try {
                int n;
                double d = 0.0;
                boolean bl = chiVertex.numOutEdges() > 0;
                for (n = 0; n < chiVertex.numEdges(); ++n) {
                    int n2;
                    int n3;
                    float f = chiVertex.edge(n).getValue().floatValue();
                    RealVector realVector2 = latent_factors_inmem.getRowAsVector(chiVertex.edge(n).getVertexId());
                    for (n3 = 0; n3 < D; ++n3) {
                        arrayRealVector.setEntry(n3, arrayRealVector.getEntry(n3) + realVector2.getEntry(n3) * (double)f);
                        for (n2 = n3; n2 < D; ++n2) {
                            blockRealMatrix.setEntry(n2, n3, blockRealMatrix.getEntry(n2, n3) + realVector2.getEntry(n3) * realVector2.getEntry(n2));
                        }
                    }
                    for (n3 = 0; n3 < D; ++n3) {
                        for (n2 = n3 + 1; n2 < D; ++n2) {
                            blockRealMatrix.setEntry(n3, n2, blockRealMatrix.getEntry(n2, n3));
                        }
                    }
                    if (!bl) continue;
                    double d2 = ALS.als_predict(realVector2, (RealVector)new ArrayRealVector(realVector));
                    d += Math.pow(d2 - (double)f, 2.0);
                }
                for (n = 0; n < D; ++n) {
                    blockRealMatrix.setEntry(n, n, blockRealMatrix.getEntry(n, n) + this.LAMBDA * (double)chiVertex.numEdges());
                }
                RealVector realVector3 = new CholeskyDecompositionImpl((RealMatrix)blockRealMatrix).getSolver().solve((RealVector)arrayRealVector);
                latent_factors_inmem.setRow(chiVertex.getId(), realVector3.getData());
                if (!bl) break block13;
                ALS aLS = this;
                synchronized (aLS) {
                    train_rmse += d;
                }
            }
            catch (NotPositiveDefiniteMatrixException notPositiveDefiniteMatrixException) {
                logger.warning("Matrix was not positive definite: " + blockRealMatrix);
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        }
    }

    @Override
    public void beginIteration(GraphChiContext graphChiContext) {
        train_rmse = 0.0;
        if (graphChiContext.getIteration() == 0) {
            this.init_feature_vectors(graphChiContext.getNumVertices());
        }
    }

    @Override
    public void endIteration(GraphChiContext graphChiContext) {
        train_rmse = Math.sqrt(train_rmse / 3298163.0);
        ProblemSetup.validation_rmse_engine.calc_validation_rmse(training, nShards);
    }

    @Override
    public void beginInterval(GraphChiContext graphChiContext, VertexInterval vertexInterval) {
    }

    @Override
    public void endInterval(GraphChiContext graphChiContext, VertexInterval vertexInterval) {
    }

    @Override
    public void beginSubInterval(GraphChiContext graphChiContext, VertexInterval vertexInterval) {
    }

    @Override
    public void endSubInterval(GraphChiContext graphChiContext, VertexInterval vertexInterval) {
    }

    public static void main(String[] stringArray) throws Exception {
        ALS aLS = new ALS();
        Common.parse_command_line_arguments(stringArray);
        logger.info("Set latent factor dimension to: " + D);
        IO.convert_matrix_market();
        validation_rmse_engine = new RMSEEngine();
        validation_rmse_engine.init_validation();
        GraphChiEngine graphChiEngine = new GraphChiEngine(ProblemSetup.training, ProblemSetup.nShards);
        graphChiEngine.setEdataConverter(new FloatConverter());
        graphChiEngine.setEnableDeterministicExecution(false);
        graphChiEngine.setVertexDataConverter(null);
        graphChiEngine.setModifiesInedges(false);
        graphChiEngine.setModifiesOutedges(false);
        graphChiEngine.run(aLS, 5);
        aLS.writeOutputMatrices(graphChiEngine.getVertexIdTranslate());
    }

    private void writeOutputMatrices(VertexIdTranslate vertexIdTranslate) throws Exception {
        int n;
        int n2;
        String string = FileUtils.readToString(training + ".matrixinfo");
        String[] stringArray = string.split("\t");
        int n3 = Integer.parseInt(stringArray[0]);
        int n4 = Integer.parseInt(stringArray[1]);
        String string2 = training + "_U.mm";
        BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(string2));
        bufferedWriter.write("%%MatrixMarket matrix array real general\n");
        bufferedWriter.write(D + " " + n3 + "\n");
        for (int i = 0; i < n3; ++i) {
            n2 = vertexIdTranslate.forward(i);
            for (n = 0; n < D; ++n) {
                bufferedWriter.write(latent_factors_inmem.getValue(n2, n) + "\n");
            }
        }
        bufferedWriter.close();
        String string3 = training + "_V.mm";
        bufferedWriter = new BufferedWriter(new FileWriter(string3));
        bufferedWriter.write("%%MatrixMarket matrix array real general\n");
        bufferedWriter.write(D + " " + n4 + "\n");
        for (n2 = 0; n2 < n4; ++n2) {
            n = vertexIdTranslate.forward(n3 + n2);
            for (int i = 0; i < D; ++i) {
                bufferedWriter.write(latent_factors_inmem.getValue(n, i) + "\n");
            }
        }
        bufferedWriter.close();
        logger.info("Latent factor matrices saved: " + training + "_U.mm" + ", " + training + "_V.mm");
    }
}

