/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.graphchi.toolkits.collaborative_filtering;

import edu.cmu.graphchi.ChiFilenames;
import edu.cmu.graphchi.datablocks.FloatConverter;
import edu.cmu.graphchi.datablocks.IntConverter;
import edu.cmu.graphchi.preprocessing.EdgeProcessor;
import edu.cmu.graphchi.preprocessing.FastSharder;
import edu.cmu.graphchi.toolkits.collaborative_filtering.ProblemSetup;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;

public class IO {
    public static void convert_matrix_market() throws IOException {
        FastSharder fastSharder = IO.createSharder(ProblemSetup.training, ProblemSetup.nShards);
        if (!new File(ChiFilenames.getFilenameIntervals(ProblemSetup.training, ProblemSetup.nShards)).exists() || !new File(ProblemSetup.training + ".matrixinfo").exists()) {
            fastSharder.shard((InputStream)new FileInputStream(new File(ProblemSetup.training)), FastSharder.GraphInputFormat.MATRIXMARKET);
        } else {
            ProblemSetup.logger.info("Found shards -- no need to preprocess");
        }
    }

    protected static FastSharder createSharder(String string, int n) throws IOException {
        return new FastSharder<Integer, Float>(string, n, null, new EdgeProcessor<Float>(){

            @Override
            public Float receiveEdge(int n, int n2, String string) {
                return Float.valueOf(string == null ? 0.0f : Float.parseFloat(string));
            }
        }, new IntConverter(), new FloatConverter());
    }
}

