/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.graphchi.util;

import java.util.Random;
import org.apache.commons.math.linear.ArrayRealVector;
import org.apache.commons.math.linear.RealVector;

public class HugeDoubleMatrix
implements Cloneable {
    private int BLOCKSIZE = 0x1000000;
    private long nrows;
    private long ncols;
    private double[][] data;

    public HugeDoubleMatrix(long l, long l2, double d) {
        this.nrows = l;
        this.ncols = l2;
        while ((long)this.BLOCKSIZE % l2 != 0L) {
            ++this.BLOCKSIZE;
        }
        long l3 = l * l2;
        int n = (int)(l3 / (long)this.BLOCKSIZE + (long)(l3 % (long)this.BLOCKSIZE == 0L ? 0 : 1));
        this.data = new double[n][];
        System.out.println("Creating " + n + " blocks");
        for (int i = 0; i < n; ++i) {
            this.data[i] = new double[this.BLOCKSIZE];
            if (d == 0.0) continue;
            double[] dArray = this.data[i];
            for (int j = 0; j < this.BLOCKSIZE; ++j) {
                dArray[j] = d;
            }
        }
    }

    public HugeDoubleMatrix(long l, long l2) {
        this(l, l2, 0.0);
    }

    public long size() {
        return this.nrows * this.ncols;
    }

    public long getNumRows() {
        return this.nrows;
    }

    public double getValue(int n, int n2) {
        long l = (long)n * this.ncols + (long)n2;
        int n3 = (int)(l / (long)this.BLOCKSIZE);
        int n4 = (int)(l % (long)this.BLOCKSIZE);
        return this.data[n3][n4];
    }

    public void setValue(int n, int n2, double d) {
        long l = (long)n * this.ncols + (long)n2;
        int n3 = (int)(l / (long)this.BLOCKSIZE);
        int n4 = (int)(l % (long)this.BLOCKSIZE);
        this.data[n3][n4] = d;
    }

    public void add(int n, int n2, double d) {
        long l = (long)n * this.ncols + (long)n2;
        int n3 = (int)(l / (long)this.BLOCKSIZE);
        int n4 = (int)(l % (long)this.BLOCKSIZE);
        double[] dArray = this.data[n3];
        int n5 = n4;
        dArray[n5] = dArray[n5] + d;
    }

    public double[] getRowBlock(int n) {
        long l = (long)n * this.ncols;
        int n2 = (int)(l / (long)this.BLOCKSIZE);
        return this.data[n2];
    }

    public int getBlockIdx(int n) {
        long l = (long)n * this.ncols;
        int n2 = (int)(l % (long)this.BLOCKSIZE);
        return n2;
    }

    public double[] getEmptyRow() {
        double[] dArray = new double[(int)this.ncols];
        return dArray;
    }

    public void multiplyRow(int n, float f) {
        int n2 = 0;
        while ((long)n2 < this.ncols) {
            this.setValue(n, n2, this.getValue(n, n2) * (double)f);
            ++n2;
        }
    }

    public void getRow(int n, double[] dArray) {
        long l = (long)n * this.ncols;
        int n2 = (int)(l / (long)this.BLOCKSIZE);
        int n3 = (int)(l % (long)this.BLOCKSIZE);
        System.arraycopy(this.data[n2], n3, dArray, 0, (int)this.ncols);
    }

    public RealVector getRowAsVector(int n) {
        double[] dArray = new double[(int)this.ncols];
        long l = (long)n * this.ncols;
        int n2 = (int)(l / (long)this.BLOCKSIZE);
        int n3 = (int)(l % (long)this.BLOCKSIZE);
        System.arraycopy(this.data[n2], n3, dArray, 0, (int)this.ncols);
        return new ArrayRealVector(dArray);
    }

    public void setRow(int n, double[] dArray) {
        long l = (long)n * this.ncols;
        int n2 = (int)(l / (long)this.BLOCKSIZE);
        int n3 = (int)(l % (long)this.BLOCKSIZE);
        System.arraycopy(dArray, 0, this.data[n2], n3, (int)this.ncols);
    }

    public void normalizeSquared(int n) {
        double d = 0.0;
        int n2 = 0;
        while ((long)n2 < this.nrows) {
            double d2 = this.getValue(n2, n);
            d += d2 * d2;
            ++n2;
        }
        System.out.println("Normalize-squared: " + n + " sqr: " + d);
        float f = (float)Math.sqrt(d);
        System.out.println("Div : " + f);
        if (Float.isInfinite(f) || Float.isNaN(f)) {
            throw new RuntimeException("Illegal normalizer: " + f);
        }
        if (d == 0.0) {
            throw new IllegalArgumentException("Column was all-zeros!");
        }
        int n3 = 0;
        while ((long)n3 < this.nrows) {
            double d3 = this.getValue(n3, n);
            this.setValue(n3, n, d3 / (double)f);
            ++n3;
        }
    }

    public void setColumn(int n, double d) {
        int n2 = 0;
        while ((long)n2 < this.nrows) {
            this.setValue(n2, n, d);
            ++n2;
        }
    }

    public void zeroLessThan(float f) {
        for (int i = 0; i < this.data.length; ++i) {
            double[] dArray = this.data[i];
            for (int j = 0; j < dArray.length; ++j) {
                if (dArray[j] == 0.0 || !(dArray[j] < (double)f)) continue;
                dArray[j] = 0.0;
            }
        }
    }

    public void binaryFilter(double d, double d2) {
        for (int i = 0; i < this.data.length; ++i) {
            double[] dArray = this.data[i];
            for (int j = 0; j < dArray.length; ++j) {
                dArray[j] = (dArray[j] >= d ? 1.0 : 0.0) * d2;
            }
        }
    }

    public void randomize(double d, double d2) {
        Random random = new Random();
        for (int i = 0; i < this.data.length; ++i) {
            double[] dArray = this.data[i];
            for (int j = 0; j < dArray.length; ++j) {
                dArray[j] = d + (d2 - d) * random.nextDouble();
            }
        }
    }
}

