/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.graphchi.util;

import edu.cmu.graphchi.datablocks.IntConverter;
import edu.cmu.graphchi.preprocessing.VertexIdTranslate;
import edu.cmu.graphchi.util.IdCount;
import edu.cmu.graphchi.vertexdata.ForeachCallback;
import edu.cmu.graphchi.vertexdata.VertexAggregator;
import java.io.BufferedOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;

public class LabelAnalysis {
    public static Collection<IdCount> computeLabels(String string, int n, VertexIdTranslate vertexIdTranslate) throws IOException {
        final HashMap hashMap = new HashMap(1000000);
        VertexAggregator.foreach(n, string, new IntConverter(), new ForeachCallback<Integer>(){

            @Override
            public void callback(int n, Integer n2) {
                if (n != n2) {
                    IdCount idCount = (IdCount)hashMap.get(n2);
                    if (idCount == null) {
                        idCount = new IdCount(n2, 1);
                        hashMap.put(n2, idCount);
                    }
                    ++idCount.count;
                }
            }
        });
        BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(string + ".components"));
        for (IdCount idCount : hashMap.values()) {
            String string2 = vertexIdTranslate.backward(idCount.id) + "," + idCount.count + "\n";
            bufferedOutputStream.write(string2.getBytes());
        }
        bufferedOutputStream.flush();
        bufferedOutputStream.close();
        return hashMap.values();
    }
}

