/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.graphchi.walks;

import edu.cmu.graphchi.walks.DrunkardFactory;
import edu.cmu.graphchi.walks.WalkManager;
import edu.cmu.graphchi.walks.distributions.RemoteDrunkardCompanion;
import java.util.Collections;
import java.util.List;

public class DrunkardJob {
    private String name;
    private WalkManager walkManager;
    private RemoteDrunkardCompanion companion;
    private DrunkardFactory factory;
    protected int numVertices;

    public DrunkardJob(String string, RemoteDrunkardCompanion remoteDrunkardCompanion, int n, DrunkardFactory drunkardFactory) {
        this.name = string;
        this.numVertices = n;
        this.companion = remoteDrunkardCompanion;
        this.factory = drunkardFactory;
    }

    public void configureSourceRangeInternalIds(int n, int n2, int n3) {
        if (this.walkManager != null) {
            throw new IllegalStateException("You can configure walks only once!");
        }
        this.walkManager = this.factory.createWalkManager(this.numVertices, n2);
        for (int i = n; i < n + n2; ++i) {
            this.walkManager.addWalkBatch(i, n3);
        }
    }

    public void configureWalkSources(List<Integer> list, int n) {
        if (this.walkManager != null) {
            throw new IllegalStateException("You can configure walks only once!");
        }
        this.walkManager = this.factory.createWalkManager(this.numVertices, list.size());
        Collections.sort(list);
        for (int n2 : list) {
            this.walkManager.addWalkBatch(n2, n);
        }
    }

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        this.name = string;
    }

    public RemoteDrunkardCompanion getCompanion() {
        return this.companion;
    }

    public WalkManager getWalkManager() {
        return this.walkManager;
    }
}

